/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.importing.wizards.SelectImportPluginSource;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDepInfo;
import org.eclipse.epf.library.edit.validation.PluginDependencyInfoMgr;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportPluginWizard
extends BaseWizard
implements IImportWizard {
    protected SelectImportPluginSource page1;
    protected SelectPluginsToImport page2;
    protected PluginImportData data = new PluginImportData();
    protected PluginImportingService service = PluginImportingService.newInstance(this.data);
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.import.importPluginWizard";

    public ImportPluginWizard() {
        this.setWindowTitle(ImportResources.importPluginsWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public void addPages() {
        ILibraryManager manager;
        IFileManager fileMgr = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            fileMgr.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null && manager.isMethodLibraryReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importPluginsWizard_title, ImportResources.ImportPluginWizard_readonly);
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        if (this.wizardExtender == null) {
            this.page1 = new SelectImportPluginSource(this.data, this.service);
            this.addPage((IWizardPage)this.page1);
            this.page2 = new SelectPluginsToImport(this.data, this.service);
            this.addPage((IWizardPage)this.page2);
            return;
        }
        ArrayList<Object> wizardPages = new ArrayList<Object>();
        IWizardPage page = this.wizardExtender.getReplaceWizardPage(SelectImportPluginSource.PAGE_NAME);
        if (page != null) {
            ((SelectImportPluginSource)page).setData(this.data);
            ((SelectImportPluginSource)page).setService(this.service);
            wizardPages.add(page);
        } else {
            this.page1 = new SelectImportPluginSource(this.data, this.service);
            wizardPages.add((Object)this.page1);
        }
        page = this.wizardExtender.getReplaceWizardPage(SelectPluginsToImport.PAGE_NAME);
        if (page != null) {
            wizardPages.add(page);
        } else {
            this.page2 = new SelectPluginsToImport(this.data, this.service);
            wizardPages.add((Object)this.page2);
        }
        super.getNewWizardPages(wizardPages);
        for (IWizardPage iWizardPage : wizardPages) {
            super.addPage(iWizardPage);
        }
        this.wizardExtender.initWizardPages(wizardPages);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIImages.IMG_METHOD_PLUGIN);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.page2) {
            return false;
        }
        return this.page2.isPageComplete();
    }

    public boolean performFinish() {
        String message;
        boolean yes;
        PluginModifyInfo modifyInfo = this.checkModify();
        if (modifyInfo.readonlyPlugins.size() > 0) {
            String error = modifyInfo.getReadonlyMessage().toString();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, error);
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        Iterator<PluginImportData.PluginInfo> it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            if (++i > 20) {
                String msg = "\n\t. . .";
                buffer.append(msg);
                break;
            }
            PluginImportData.PluginInfo info = it.next();
            if (info.existingPlugin == null || !info.selected) continue;
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append("\t").append(info.name);
        }
        if (buffer.length() > 0 && !(yes = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(ImportResources.importPluginsWizard_title, NLS.bind((String)ImportResources.ImportPluginWizard_warn_existing_plugins, (Object)buffer.toString())))) {
            return false;
        }
        if (modifyInfo.lockedPlugins.size() > 0) {
            message = String.valueOf(modifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
            boolean yes2 = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(ImportResources.importPluginsWizard_title, message);
            if (!yes2) {
                return false;
            }
        }
        if (ProcessUtil.isSynFree() && !this.service.isSynFreeLib()) {
            message = ImportResources.ImportNoSynLibToSynLib_Error;
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importPluginsWizard_title, message);
            return false;
        }
        if (!ProcessUtil.isSynFree() && this.service.isSynFreeLib()) {
            message = ImportResources.ImportSynLibToNoSynLib_Error;
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importPluginsWizard_title, message);
            return false;
        }
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ImportResources.ImportPluginWizard_MSG1, -1);
                        ImportPluginWizard.this.service.performImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportPluginWizard_error, realException.getMessage());
            return false;
        }
        try {
            this.checkPluginCircularDependency();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ImportUIPreferences.addImportPluginDir(this.data.llData.getParentFolder());
        ImportUIPreferences.setCheckBasePlugins(this.service.isCheckBasePlugins());
        return true;
    }

    public PluginModifyInfo checkModify() {
        PluginModifyInfo modifyInfo = new PluginModifyInfo();
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            MethodPlugin plugin = info.existingPlugin;
            if (plugin == null || !info.selected) continue;
            if (!plugin.getUserChangeable().booleanValue()) {
                modifyInfo.lockedPlugins.add(plugin);
                continue;
            }
            IStatus status = TngUtil.checkEdit((EObject)plugin, (Object)this.getShell());
            if (status.isOK()) continue;
            modifyInfo.readonlyPlugins.add(plugin);
        }
        return modifyInfo;
    }

    private void checkPluginCircularDependency() {
        PluginDependencyInfoMgr mgr = new PluginDependencyInfoMgr(LibraryService.getInstance().getCurrentMethodLibrary());
        PluginDependencyInfoMgr.CheckResult result = mgr.checkCircularDependnecy(null, false);
        if (result.circularList != null && !result.circularList.isEmpty()) {
            List cirPlugins = (List)result.circularList.get(0);
            String msg = "";
            int i = 0;
            while (i < cirPlugins.size()) {
                PluginDepInfo pinfo = (PluginDepInfo)cirPlugins.get(i);
                if (i != 0) {
                    msg = String.valueOf(msg) + ", ";
                }
                msg = String.valueOf(msg) + pinfo.getPlugin().getName();
                ++i;
            }
            ImportPlugin.getDefault().getMsgDialog().displayWarning(ImportResources.ImportPluginWizard_warn_circular_plugins, msg);
        }
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }
}

