/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectConfigSpecsToImportPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener {
    public static final String PAGE_NAME = SelectConfigSpecsToImportPage.class.getName();
    private static final String libraryConfigSpecExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecExists;
    private static final String libraryConfigSpecNotExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecNotExists;
    private static final String configSpecNoSelection = ImportResources.SelectConfigSpecsToImportPage_configSpecNoSelection;
    private static final String configSpecDataLabel = ImportResources.SelectConfigSpecsToImportPage_configSpecDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_briefDescImport;
    private Label importConfigSpecLabel;
    private Text ctrl_briefDescLibrary;
    private Label libraryConfigSpecLabel;
    private Composite container;
    private ConfigurationImportData data;
    private Button selectAllButton;
    private Button deselectAllButton;

    public SelectConfigSpecsToImportPage(ConfigurationImportData data) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectConfigSpecsWizardPage_title);
        this.setDescription(ImportResources.selectConfigSpecsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/imp_lib_conf_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite tableContainer = new Composite(this.container, 0);
        tableContainer.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableContainer.setLayoutData((Object)gridData);
        Composite container1 = new Composite(tableContainer, 0);
        container1.setLayout((Layout)new GridLayout(3, false));
        SelectConfigSpecsToImportPage.createLabel((Composite)container1, (String)ImportResources.SelectConfigSpecsToImportPage_label_configs);
        this.selectAllButton = SelectConfigSpecsToImportPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.deselectAllButton = SelectConfigSpecsToImportPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.ctrl_chkboxTableViewer = SelectConfigSpecsToImportPage.createCheckboxTableViewer((Composite)tableContainer, (int)1);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_CONFIGURATON;
            }

            public String getText(Object element) {
                return super.getText(element);
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite importContainer = new Composite(this.container, 0);
        importContainer.setLayout((Layout)new GridLayout());
        importContainer.setLayoutData((Object)new GridData(768));
        this.createImportConfigSpecInfo(importContainer);
        Composite libraryContainer = new Composite(this.container, 0);
        libraryContainer.setLayout((Layout)new GridLayout());
        libraryContainer.setLayoutData((Object)new GridData(768));
        this.createLibraryConfigSpecInfo(libraryContainer);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportConfigSpecInfo(Composite container) {
        this.importConfigSpecLabel = SelectConfigSpecsToImportPage.createLabel((Composite)container, (String)configSpecNoSelection, (int)1);
        SelectConfigSpecsToImportPage.createLine((Composite)container, (int)1);
        SelectConfigSpecsToImportPage.createLabel((Composite)container, (String)ImportResources.SelectConfigSpecsToImportPage_label_desc, (int)1);
        this.ctrl_briefDescImport = SelectConfigSpecsToImportPage.createMultiLineText((Composite)container, (String)"", (int)275, (int)100, (int)1);
    }

    private void createLibraryConfigSpecInfo(Composite container) {
        this.libraryConfigSpecLabel = SelectConfigSpecsToImportPage.createLabel((Composite)container, (String)configSpecNoSelection, (int)1);
        SelectConfigSpecsToImportPage.createLine((Composite)container, (int)1);
        SelectConfigSpecsToImportPage.createLabel((Composite)container, (String)ImportResources.SelectConfigSpecsToImportPage_label_desc, (int)1);
        this.ctrl_briefDescLibrary = SelectConfigSpecsToImportPage.createMultiLineText((Composite)container, (String)"", (int)275, (int)100, (int)1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectConfigSpecsToImportPage.this.ctrl_chkboxTableViewer.setAllChecked(true);
                SelectConfigSpecsToImportPage.this.setPageComplete(SelectConfigSpecsToImportPage.this.isPageComplete());
                SelectConfigSpecsToImportPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectConfigSpecsToImportPage.this.ctrl_chkboxTableViewer.setAllChecked(false);
                SelectConfigSpecsToImportPage.this.setPageComplete(SelectConfigSpecsToImportPage.this.isPageComplete());
                SelectConfigSpecsToImportPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((ConfigSpecs.Entry)configs[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    private void setDisplayAttributes(ConfigSpecs.Entry spec) {
        this.ctrl_briefDescImport.setText(spec.configSpec.brief_desc == null ? "" : spec.configSpec.brief_desc);
        this.importConfigSpecLabel.setText(configSpecDataLabel);
        if (spec.existingConfig != null) {
            this.ctrl_briefDescLibrary.setText(spec.existingConfig.getBriefDescription());
            this.libraryConfigSpecLabel.setText(libraryConfigSpecExists);
        } else {
            this.libraryConfigSpecLabel.setText(libraryConfigSpecNotExists);
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.ctrl_briefDescImport.setText("");
        this.ctrl_briefDescLibrary.setText("");
        this.libraryConfigSpecLabel.setText(configSpecNoSelection);
        this.importConfigSpecLabel.setText(configSpecNoSelection);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.ctrl_chkboxTableViewer.getCheckedElements().length > 0) {
            for (ConfigSpecs.Entry e : this.data.specs.configs) {
                e.selected = this.ctrl_chkboxTableViewer.getChecked((Object)e);
            }
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = true;
        } else {
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = false;
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void onEnterPage(Object obj) {
        this.ctrl_chkboxTableViewer.setInput((Object)this.data.specs.configs);
        if (this.data.specs.configs.size() > 0) {
            StructuredSelection sel = new StructuredSelection(this.data.specs.configs.get(0));
            this.ctrl_chkboxTableViewer.setSelection((ISelection)sel);
        }
    }
}

