/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportPluginWizard;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SelectImportPluginSource
extends DestinationCommonPage {
    public static final String PAGE_NAME = SelectImportPluginSource.class.getName();
    private static final Status OK_STATUS = new Status(0, ImportResources.SelectImportPluginSource_not_used, 0, "", null);
    private PluginImportData data;
    private PluginImportingService service;
    private Status status = OK_STATUS;

    protected SelectImportPluginSource() {
        super(PAGE_NAME, null);
        this.setTitle(ImportResources.selectPluginsDirWizardPage_title);
        this.setDescription(ImportResources.selectPluginsDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/imp_meth_plugin_wizban.gif"));
    }

    public SelectImportPluginSource(PluginImportData data, PluginImportingService service) {
        super(PAGE_NAME, data.llData);
        this.setTitle(ImportResources.selectPluginsDirWizardPage_title);
        this.setDescription(ImportResources.selectPluginsDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/imp_meth_plugin_wizban.gif"));
        this.service = service;
        this.data = data;
    }

    public void setData(PluginImportData data) {
        this.data = data;
        this.llData = data.llData;
    }

    public void setService(PluginImportingService service) {
        this.service = service;
    }

    protected void initControls() {
        String[] exportDirs = ImportUIPreferences.getImportPluginDirs();
        if (exportDirs != null && exportDirs.length > 0) {
            this.exportPathCombo.setItems(exportDirs);
            this.exportPathCombo.setText(exportDirs[0]);
        }
        super.initControls();
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        boolean returnValue = false;
        this.status = OK_STATUS;
        if (this.exportPathCombo.getText().length() > 0) {
            this.saveToDataModel();
            File libDir = new File(this.exportPathCombo.getText());
            if (!libDir.exists()) {
                this.status = new Status(4, ImportResources.SelectImportPluginSource_not_used, 0, ImportResources.SelectImportPluginSource_no_path, null);
            } else {
                returnValue = true;
            }
        }
        this.applyToStatusLine();
        return returnValue;
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        this.service.validate(null);
        String error = this.data.getErrorInfo().getError();
        if (error != null && error.length() > 0) {
            super.setErrorMessage(error);
            return this;
        }
        SelectPluginsToImport page = ((ImportPluginWizard)this.getWizard()).page2;
        page.onEnterPage(null);
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != OK_STATUS) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    protected void createAdditionalControls(Composite composite) {
        Group optionGroup = new Group(composite, 0);
        optionGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        optionGroup.setLayoutData((Object)gridData);
        optionGroup.setText(ImportResources.optionGroup_text);
        boolean checkBasePlugins = ImportUIPreferences.getCheckBasePlugins();
        this.setCheckBasePlugins(checkBasePlugins);
        Button checkBaseRadioButton = SelectImportPluginSource.createRadioButton((Composite)optionGroup, (String)ImportResources.checkBaseRadioButton_text, (int)1, (boolean)checkBasePlugins);
        checkBaseRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectImportPluginSource.this.setCheckBasePlugins(true);
            }
        });
        Button ignoreRemoveRadioButton = SelectImportPluginSource.createRadioButton((Composite)optionGroup, (String)ImportResources.ignoreRemoveRadioButton_text, (int)1, (!checkBasePlugins ? 1 : 0) != 0);
        ignoreRemoveRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectImportPluginSource.this.setCheckBasePlugins(false);
            }
        });
    }

    private void setCheckBasePlugins(boolean checkBasePlugins) {
        this.service.setCheckBasePlugins(checkBasePlugins);
    }
}

