/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportPluginWizard;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectPluginsToImport
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME = SelectPluginsToImport.class.getName();
    private static final String libraryPluginExists = ImportResources.SelectPluginsToImport_libraryPluginExists;
    private static final String libraryPluginNotExists = ImportResources.SelectPluginsToImport_libraryPluginNotExists;
    private static final String pluginNoSelection = ImportResources.SelectPluginsToImport_pluginNoSelection;
    private static final String pluginDataLabel = ImportResources.SelectPluginsToImport_pluginDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_authorImport;
    private Text ctrl_versionImport;
    private Text ctrl_briefDescImport;
    private Label importPluginLabel;
    private Text ctrl_authorLibrary;
    private Text ctrl_versionLibrary;
    private Text ctrl_briefDescLibrary;
    private Label libraryPluginLabel;
    private Composite container;
    private int checkedCount = 0;
    private List checkedPluginList = new ArrayList();
    private PluginImportData data;
    private PluginImportingService service;
    private Button selectAllButton;
    private Button deselectAllButton;

    public SelectPluginsToImport(PluginImportData data, PluginImportingService service) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectPluginsWizardPage_title);
        this.setDescription(ImportResources.selectPluginsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/imp_meth_plugin_wizban.gif"));
        this.service = service;
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite tableContainer = new Composite(this.container, 0);
        tableContainer.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableContainer.setLayoutData((Object)gridData);
        Composite container1 = new Composite(tableContainer, 0);
        container1.setLayout((Layout)new GridLayout(3, false));
        SelectPluginsToImport.createLabel((Composite)container1, (String)ImportResources.SelectPluginsToImport_label_plugins);
        this.selectAllButton = SelectPluginsToImport.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.deselectAllButton = SelectPluginsToImport.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.ctrl_chkboxTableViewer = SelectPluginsToImport.createCheckboxTableViewer((Composite)tableContainer, (int)2);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite importContainer = new Composite(this.container, 0);
        importContainer.setLayout((Layout)new GridLayout());
        this.createImportPluginInfo(importContainer);
        Composite libraryContainer = new Composite(this.container, 0);
        libraryContainer.setLayout((Layout)new GridLayout());
        this.createLibraryPluginInfo(libraryContainer);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportPluginInfo(Composite container) {
        this.importPluginLabel = SelectPluginsToImport.createLabel((Composite)container, (String)pluginNoSelection, (int)1);
        SelectPluginsToImport.createLine((Composite)container, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_author, (int)1);
        this.ctrl_authorImport = SelectPluginsToImport.createMultiLineText((Composite)container, (String)"", (int)275, (int)40, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_version, (int)1);
        this.ctrl_versionImport = SelectPluginsToImport.createText((Composite)container, (String)"", (int)275, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_desc, (int)1);
        this.ctrl_briefDescImport = SelectPluginsToImport.createMultiLineText((Composite)container, (String)"", (int)275, (int)100, (int)1);
    }

    private void createLibraryPluginInfo(Composite container) {
        this.libraryPluginLabel = SelectPluginsToImport.createLabel((Composite)container, (String)pluginNoSelection, (int)1);
        SelectPluginsToImport.createLine((Composite)container, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_author, (int)1);
        this.ctrl_authorLibrary = SelectPluginsToImport.createMultiLineText((Composite)container, (String)"", (int)275, (int)40, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_version, (int)1);
        this.ctrl_versionLibrary = SelectPluginsToImport.createText((Composite)container, (String)"", (int)275, (int)1);
        SelectPluginsToImport.createLabel((Composite)container, (String)ImportResources.SelectPluginsToImport_label_desc, (int)1);
        this.ctrl_briefDescLibrary = SelectPluginsToImport.createMultiLineText((Composite)container, (String)"", (int)275, (int)100, (int)1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectPluginsToImport.this.ctrl_chkboxTableViewer.setAllChecked(true);
                ImportPluginWizard wizard = (ImportPluginWizard)SelectPluginsToImport.this.getWizard();
                if (!wizard.data.getPlugins().isEmpty()) {
                    SelectPluginsToImport.this.checkedPluginList.clear();
                    SelectPluginsToImport.this.checkedPluginList.addAll(wizard.data.getPlugins());
                    SelectPluginsToImport.this.checkedCount = SelectPluginsToImport.this.checkedPluginList.size();
                    SelectPluginsToImport.this.setAllSelected(wizard.data, true);
                    String message = SelectPluginsToImport.this.service.validateSelection();
                    if (message != null && message.length() > 0) {
                        SelectPluginsToImport.this.setErrorMessage(message);
                    } else {
                        SelectPluginsToImport.this.setErrorMessage(null);
                    }
                }
                SelectPluginsToImport.this.setPageComplete(SelectPluginsToImport.this.isPageComplete());
                SelectPluginsToImport.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectPluginsToImport.this.ctrl_chkboxTableViewer.setAllChecked(false);
                SelectPluginsToImport.this.checkedPluginList.clear();
                SelectPluginsToImport.this.checkedCount = 0;
                ImportPluginWizard wizard = (ImportPluginWizard)SelectPluginsToImport.this.getWizard();
                SelectPluginsToImport.this.setAllSelected(wizard.data, false);
                SelectPluginsToImport.this.setPageComplete(SelectPluginsToImport.this.isPageComplete());
                SelectPluginsToImport.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void setAllSelected(PluginImportData data, boolean selected) {
        for (PluginImportData.PluginInfo info : data.getPlugins()) {
            info.selected = selected;
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        String message;
        Object obj = event.getElement();
        if (obj instanceof PluginImportData.PluginInfo) {
            ((PluginImportData.PluginInfo)obj).selected = event.getChecked();
        }
        if ((message = this.service.validateSelection()) != null && message.length() > 0) {
            super.setErrorMessage(message);
        } else {
            super.setErrorMessage(null);
        }
        if (event.getChecked()) {
            ++this.checkedCount;
            this.checkedPluginList.add(obj);
        } else {
            --this.checkedCount;
            this.checkedPluginList.remove(obj);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] plugin = selection.toArray();
            this.setDisplayAttributes((PluginImportData.PluginInfo)plugin[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(PluginImportData.PluginInfo plugin) {
        this.ctrl_authorImport.setText(plugin.authors == null ? "" : plugin.authors);
        this.ctrl_versionImport.setText(plugin.version == null ? "" : plugin.version);
        this.ctrl_briefDescImport.setText(plugin.brief_desc == null ? "" : plugin.brief_desc);
        this.importPluginLabel.setText(pluginDataLabel);
        if (plugin.existingPlugin != null) {
            this.libraryPluginLabel.setText(libraryPluginExists);
            this.ctrl_authorLibrary.setText(plugin.existingPlugin.getAuthors());
            this.ctrl_versionLibrary.setText(plugin.existingPlugin.getVersion());
            this.ctrl_briefDescLibrary.setText(plugin.existingPlugin.getBriefDescription());
        } else {
            this.libraryPluginLabel.setText(libraryPluginNotExists);
            this.ctrl_authorLibrary.setText("");
            this.ctrl_versionLibrary.setText("");
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.importPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorImport.setText("");
        this.ctrl_versionImport.setText("");
        this.ctrl_briefDescImport.setText("");
        this.libraryPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorLibrary.setText("");
        this.ctrl_versionLibrary.setText("");
        this.ctrl_briefDescLibrary.setText("");
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    public void onEnterPage(Object obj) {
        List<PluginImportData.PluginInfo> plugins = this.data.getPlugins();
        if (plugins != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)plugins.toArray());
            if (!plugins.isEmpty()) {
                StructuredSelection selection = new StructuredSelection((Object)plugins.get(0));
                this.ctrl_chkboxTableViewer.setSelection((ISelection)selection);
            }
        }
    }
}

