/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.ui.IUIHelper;
import org.eclipse.epf.library.edit.ui.LibraryEditUIPlugin;
import org.eclipse.epf.library.edit.ui.ProcessListSelectionDialog;
import org.eclipse.epf.library.edit.ui.TeamSelection;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class UIHelper
implements IUIHelper {
    private static void getTeamsInScope(AdapterFactory adapterFactory, BreakdownElement e, Role role, List teamList) {
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, ITreeItemContentProvider.class);
        Collection children = itemProvider.getChildren((Object)e);
        for (Object obj : children) {
            if (!(obj instanceof TeamProfile)) continue;
            TeamProfile team = (TeamProfile)obj;
            ArrayList allTeams = new ArrayList();
            ProcessUtil.getAllSubTeams((TeamProfile)team, allTeams);
            for (Object o : allTeams) {
                List roles;
                if (!(o instanceof TeamProfile) || !(roles = ProcessUtil.getRoles((List)((TeamProfile)o).getTeamRoles())).contains(role)) continue;
                teamList.add(o);
            }
        }
        Object currentParent = itemProvider.getParent((Object)e);
        if (currentParent != null) {
            UIHelper.getTeamsInScope(adapterFactory, (BreakdownElement)currentParent, role, teamList);
        }
    }

    public TeamProfile getTeam(Activity activity, Role role, Object UIContext) {
        ArrayList teamList = new ArrayList();
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        UIHelper.getTeamsInScope((AdapterFactory)adapterFactory, (BreakdownElement)activity, role, teamList);
        if (teamList.size() == 1) {
            return (TeamProfile)teamList.get(0);
        }
        if (teamList.size() > 1) {
            return TeamSelection.getSelectedTeam(teamList, role, UIContext instanceof Shell ? (Shell)UIContext : null);
        }
        return null;
    }

    public IStatus runInModalContext(final IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Object uiContext) {
        org.eclipse.jface.operation.IRunnableWithProgress op = new org.eclipse.jface.operation.IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                operation.run(monitor);
            }
        };
        try {
            ModalContext.run((org.eclipse.jface.operation.IRunnableWithProgress)op, (boolean)true, (IProgressMonitor)monitor, (Display)((Shell)uiContext).getDisplay());
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            LibraryEditPlugin.INSTANCE.log((Object)e);
            Throwable ex = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            String msg = TngUtil.toStackTraceString((Throwable)ex);
            return new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, ex);
        }
    }

    public List selectTasks(List taskList, WorkProduct wp) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getColumnText(Object obj, int column) {
                if (obj instanceof MethodElement) {
                    return TngUtil.getPresentationName((Object)obj);
                }
                return super.getText(obj);
            }
        };
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        try {
            ProcessListSelectionDialog dlg = new ProcessListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), taskList, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_wplistdlg_msg, (Object)wp.getName()));
            dlg.setTitle(LibraryEditResources.ui_UserInteractionHelper_tasks);
            dlg.setBlockOnOpen(true);
            dlg.open();
            Object[] objs = dlg.getResult();
            ArrayList<Object> selectedTasks = new ArrayList<Object>();
            if (objs != null && objs.length > 0) {
                int i = 0;
                while (i < objs.length) {
                    selectedTasks.add(objs[i]);
                    ++i;
                }
            }
            ArrayList<Object> arrayList = selectedTasks;
            return arrayList;
        }
        finally {
            labelProvider.dispose();
            contentProvider.dispose();
        }
    }

    public List selectWorkProducts(List wpList, Role role) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getColumnText(Object obj, int column) {
                if (obj instanceof MethodElement) {
                    return TngUtil.getPresentationName((Object)obj);
                }
                return super.getText(obj);
            }
        };
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        try {
            ProcessListSelectionDialog dlg = new ProcessListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), wpList, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_rolelistdlg_msg, (Object)role.getName()));
            dlg.setTitle(LibraryEditResources.ui_UserInteractionHelper_workproducts);
            dlg.setBlockOnOpen(true);
            dlg.open();
            Object[] objs = dlg.getResult();
            ArrayList<Object> selectedWps = new ArrayList<Object>();
            if (objs != null && objs.length > 0) {
                int i = 0;
                while (i < objs.length) {
                    selectedWps.add(objs[i]);
                    ++i;
                }
            }
            ArrayList<Object> arrayList = selectedWps;
            return arrayList;
        }
        finally {
            labelProvider.dispose();
            contentProvider.dispose();
        }
    }

    public IStatus runAsJob(final IRunnableWithProgress runnable, String taskName, Object shell) {
        WorkspaceJob job = new WorkspaceJob(taskName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    runnable.run(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getCause() != null ? e.getCause() : e;
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, ex.toString(), ex);
                    return status;
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, e.toString(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().showInDialog((Shell)shell, (Job)job);
        job.schedule();
        return job.getResult();
    }

    public boolean runInUI(IRunnableWithProgress runnable, ISchedulingRule rule, Object shell) {
        if (shell == null) {
            shell = LibraryEditPlugin.getDefault().getContext();
        }
        ProgressMonitorDialog context = new ProgressMonitorDialog((Shell)shell);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (org.eclipse.jface.operation.IRunnableWithProgress)new RunnableWithProgress(runnable), rule);
            return true;
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            String title = LibraryEditResources.errorDialog_title;
            ExtensionManager.getDefaultUserInteractionHandler().getMessenger().showError(title, e.toString(), null, e);
            return false;
        }
    }

    public static boolean runWithProgress(final IRunnableWithProgress runnable, final IRunnableContext runnableContext, final boolean canCancel, final String msg) {
        block5: {
            final MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
            final org.eclipse.jface.operation.IRunnableWithProgress operation = new org.eclipse.jface.operation.IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(msg, -1);
                    monitor.subTask("");
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (RuntimeException e) {
                            String msg2;
                            if (e instanceof MessageException) {
                                msg2 = e.getMessage();
                            } else {
                                StringWriter strWriter = new StringWriter();
                                e.printStackTrace(new PrintWriter(strWriter));
                                msg2 = strWriter.toString();
                            }
                            status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg2, (Throwable)e));
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                if (Display.getCurrent() == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                runnableContext.run(true, canCancel, operation);
                            }
                            catch (Exception e) {
                                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                            }
                        }
                    });
                } else {
                    runnableContext.run(true, canCancel, operation);
                }
                if (!status.isOK()) {
                    ExtensionManager.getDefaultUserInteractionHandler().getMessenger().showError(LibraryEditResources.errorDialog_title, LibraryEditResources.error_msgWithDetails, (IStatus)status);
                    break block5;
                }
                return true;
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return false;
    }

    public boolean runWithProgress(IRunnableWithProgress runnable, boolean canCancel, String msg) {
        return UIHelper.runWithProgress(runnable, this.getRunnableContext(), false, msg);
    }

    public IRunnableContext getRunnableContext() {
        Object uiCtx = ExtensionManager.getDefaultUserInteractionHandler().getUIContext();
        Shell shell = uiCtx instanceof Shell ? (Shell)uiCtx : MsgBox.getDefaultShell();
        return new ProgressMonitorDialog(shell);
    }

    public static Viewer doGetViewer(AdapterFactory adapterFactory, Process proc) {
        if (adapterFactory instanceof ExposedAdapterFactory) {
            for (Object listener : Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners())) {
                Viewer viewer;
                if (!(listener instanceof IContentProvider) || !(listener instanceof IViewerProvider) || !((viewer = ((IViewerProvider)listener).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != proc) continue;
                return viewer;
            }
        }
        return null;
    }

    public boolean refreshNeeded(AdapterFactory adapterFactory, BSActivityItemProvider itemProvider) {
        BSActivityItemProvider adapter;
        Object element;
        Process process = (Process)itemProvider.getTopItem();
        if (process == null) {
            return false;
        }
        Viewer viewer = UIHelper.doGetViewer(adapterFactory, process);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return true;
        }
        Iterator iter = TngUtil.getContributors((VariabilityElement)process);
        while (iter.hasNext()) {
            element = iter.next();
            adapter = (BSActivityItemProvider)adapterFactory.adapt(element, ITreeItemContentProvider.class);
            if (!this.refreshNeeded(adapterFactory, adapter)) continue;
            return true;
        }
        iter = TngUtil.getGeneralizers((VariabilityElement)process, (VariabilityType)VariabilityType.EXTENDS);
        while (iter.hasNext()) {
            element = iter.next();
            adapter = (BSActivityItemProvider)adapterFactory.adapt(element, ITreeItemContentProvider.class);
            if (!this.refreshNeeded(adapterFactory, adapter)) continue;
            return true;
        }
        return false;
    }

    public void refreshAllViewers(final ExposedAdapterFactory adapterFactory) {
        UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

            @Override
            public void run() {
                for (Object listener : Collections.unmodifiableList(adapterFactory.getChangeListeners())) {
                    Viewer viewer;
                    if (!(listener instanceof IContentProvider) || !(listener instanceof IViewerProvider) || (viewer = ((IViewerProvider)listener).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent)) continue;
                    viewer.refresh();
                }
            }
        }, true);
    }

    public void refreshViewer(AdapterFactory factory, Process proc) {
        final Viewer viewer = UIHelper.doGetViewer(factory, proc);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

                @Override
                public void run() {
                    viewer.refresh();
                }
            }, true);
        }
    }

    public void refreshIDsInViewer(final ExposedAdapterFactory adapterFactory) {
        UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

            @Override
            public void run() {
                for (Object listener : Collections.unmodifiableList(adapterFactory.getChangeListeners())) {
                    Process proc;
                    BSActivityItemProvider itemProvider;
                    Viewer viewer;
                    if (!(listener instanceof IContentProvider) || !(listener instanceof IViewerProvider) || (viewer = ((IViewerProvider)listener).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent) || !(itemProvider = (BSActivityItemProvider)adapterFactory.adapt((Notifier)(proc = ((ProcessComponent)viewer.getInput()).getProcess()), ITreeItemContentProvider.class)).isRefreshAllIDsRequired()) continue;
                    ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)proc);
                    viewer.refresh();
                    itemProvider.setRefreshAllIDsRequired(false);
                }
            }
        }, true);
    }

    public Object getViewer(AdapterFactory adapterFactory, Process proc) {
        return UIHelper.doGetViewer(adapterFactory, proc);
    }

    public void runSafely(final Runnable runnable, boolean synchronous) {
        Display display = null;
        try {
            display = Display.getCurrent();
        }
        catch (Exception exception) {}
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    LibraryEditUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        };
        if (display == null) {
            try {
                display = Display.getDefault();
            }
            catch (Exception exception) {}
            if (display != null) {
                if (synchronous) {
                    display.syncExec(runner);
                } else {
                    display.asyncExec(runner);
                }
            } else {
                runner.run();
            }
        } else if (synchronous) {
            runner.run();
        } else {
            display.asyncExec(runner);
        }
    }

    public void runWithBusyIndicator(Runnable runnable) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
    }

    public void runInUI(final IRunnableWithProgress runnable, String taskName) {
        Shell shell = (Shell)LibraryEditPlugin.getDefault().getContext();
        if (shell == null) {
            try {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
                return;
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                throw new WrappedException(e);
            }
        }
        WorkbenchJob job = new WorkbenchJob(taskName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("", -1);
                try {
                    runnable.run(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getCause() != null ? e.getCause() : e;
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, ex.toString(), ex);
                    return status;
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, e.toString(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().showInDialog(shell, (Job)job);
        job.schedule();
    }

    private static class RunnableWithProgress
    implements org.eclipse.jface.operation.IRunnableWithProgress {
        private IRunnableWithProgress operation;

        public RunnableWithProgress(IRunnableWithProgress op) {
            this.operation = op;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.operation.run(monitor);
        }
    }
}

