/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.category;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.internal.IListenerProvider;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCategoryItemProvider
extends org.eclipse.epf.uma.provider.CustomCategoryItemProvider
implements IDefaultNameSetter,
ILibraryItemProvider,
IListenerProvider {
    public CustomCategoryItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public void setParent(Object parent) {
    }

    public Object getParent(Object object) {
        if (TngUtil.isRootCustomCategory((CustomCategory)object)) {
            return null;
        }
        return super.getParent(object);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), UmaFactory.eINSTANCE.createCustomCategory()));
    }

    @Override
    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements());
        }
        return this.childrenFeatures;
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        if (feature instanceof EReference && child instanceof EObject) {
            EReference reference = (EReference)feature;
            EClass parentClass = reference.getEContainingClass();
            EClass childClass = ((EObject)child).eClass();
            String name = "full/ctool16/Create" + parentClass.getName() + "_" + reference.getName() + "_" + childClass.getName();
            try {
                return LibraryEditPlugin.INSTANCE.getImage(name);
            }
            catch (MissingResourceException e) {
                System.err.println(e.getMessage());
                return null;
            }
        }
        return EMFEditPlugin.INSTANCE.getImage("full/ctool16/CreateChild");
    }

    private static void handleRemoved(CustomCategory category) {
        if (AssociationHelper.getCustomCategories((DescribableElement)category).isEmpty()) {
            Iterator iter = category.getCategorizedElements().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof CustomCategory)) continue;
                iter.remove();
            }
            EcoreUtil.remove((EObject)category);
        }
    }

    public void notifyChanged(Notification notification) {
        this.setDefaultName(notification);
        this.updateChildren(notification);
        switch (notification.getFeatureID(CustomCategory.class)) {
            case 0: {
                MethodPlugin plugin;
                TngUtil.refreshContributors((IChangeNotifier)this, notification, false, true);
                if (TngUtil.isRootCustomCategory((CustomCategory)notification.getNotifier()) || (plugin = MethodElementUtil.getMethodModel(notification.getNotifier())) == null) break;
                CustomCategory root = TngUtil.getRootCustomCategory(plugin);
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)root, true, false));
                break;
            }
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                break;
            }
            case 22: {
                ContentPackage pkg = (ContentPackage)((EObject)notification.getNotifier()).eContainer();
                if (pkg != null && "Hidden".equals(pkg.getName())) {
                    pkg = (ContentPackage)pkg.eContainer();
                }
                switch (notification.getEventType()) {
                    case 3: {
                        CustomCategory category;
                        Object obj = notification.getNewValue();
                        if (!(obj instanceof CustomCategory) || (category = (CustomCategory)obj).eContainer() != null) break;
                        pkg.getContentElements().add(category);
                        break;
                    }
                    case 5: {
                        for (Object obj : (Collection)notification.getNewValue()) {
                            CustomCategory category;
                            if (!(obj instanceof CustomCategory) || (category = (CustomCategory)obj).eContainer() != null) continue;
                            pkg.getContentElements().add(category);
                        }
                        break;
                    }
                }
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (!this.isWrappingNeeded(object)) {
            return value;
        }
        return TngUtil.createWrapper(this.adapterFactory, object, feature, value, index);
    }

    public String getText(Object object) {
        return TngUtil.getLabel((VariabilityElement)object, this.getString("_UI_CustomCategory_type"), true);
    }

    public boolean hasChildren(Object object) {
        CustomCategory category = (CustomCategory)object;
        return !category.getCategorizedElements().isEmpty();
    }

    public void setDefaultName(Notification msg) {
        int featureId;
        CustomCategoryItemProvider defaultNameSetter = this;
        if (defaultNameSetter.getInterestedFeatureOwnerClass() != null && (featureId = msg.getFeatureID(defaultNameSetter.getInterestedFeatureOwnerClass())) == defaultNameSetter.getInterestedFeatureID()) {
            switch (msg.getEventType()) {
                case 3: {
                    this.setDefaultName(msg.getNewValue(), msg.getNotifier());
                    break;
                }
                case 5: {
                    Iterator iter = ((Collection)msg.getNewValue()).iterator();
                    while (iter.hasNext()) {
                        this.setDefaultName(iter.next(), msg.getNotifier());
                    }
                    break;
                }
            }
        }
    }

    private void setDefaultName(Object obj, Object parent) {
        String ccName;
        String baseName = null;
        if (obj instanceof CustomCategory && ((ccName = ((CustomCategory)obj).getName()) == null || ccName.trim().length() == 0)) {
            baseName = "new_custom_category";
            TngUtil.setDefaultName((CustomCategory)parent, (CustomCategory)obj, baseName);
        }
    }

    @Override
    public int getInterestedFeatureID() {
        return 22;
    }

    @Override
    public Class getInterestedFeatureOwnerClass() {
        return CustomCategory.class;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection, int index) {
        ArrayList selection = new ArrayList();
        for (Object element : collection) {
            if (!(element instanceof CustomCategory) || owner instanceof DescribableElement && TngUtil.isAncessorOf((CustomCategory)element, (DescribableElement)owner)) continue;
            selection.add(element);
        }
        if (selection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(domain, owner, feature, collection, index)));
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection) {
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    public void setLabel(String label) {
    }

    public Object getImage(Object object) {
        File file;
        URI imgUri;
        Object image;
        if (TngUtil.isRootCustomCategory((CustomCategory)object)) {
            return LibraryEditPlugin.INSTANCE.getImage("full/obj16/CustomCategories");
        }
        if (object instanceof DescribableElement && ((DescribableElement)object).getNodeicon() != null && (image = LibraryEditPlugin.INSTANCE.getSharedImage(imgUri = TngUtil.getFullPathofNodeorShapeIconURI((EObject)((DescribableElement)object), ((DescribableElement)object).getNodeicon()))) != null && (file = new File(imgUri.getPath())).exists()) {
            return image;
        }
        return super.getImage(object);
    }

    @Override
    public void setDefaultName(Object obj) {
    }

    @Override
    public List<INotifyChangedListener> getNotifyChangedListeners() {
        if (this.changeNotifier instanceof ChangeNotifier) {
            return new ArrayList<INotifyChangedListener>((Collection<INotifyChangedListener>)((ChangeNotifier)this.changeNotifier));
        }
        return Collections.emptyList();
    }

    public Collection getChildren(Object object) {
        Collection col = super.getChildren(object);
        if (TngUtil.isRootCustomCategory((CustomCategory)object)) {
            ArrayList sortList = new ArrayList();
            sortList.addAll(col);
            Collections.sort(sortList, PresentationContext.INSTANCE.getComparator());
            return sortList;
        }
        if (object instanceof MethodElement) {
            List<Object> sortList = CategorySortHelper.sortCategoryElements((MethodElement)object, col.toArray());
            return sortList;
        }
        return col;
    }
}

