/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BatchCommand
extends AbstractCommand {
    private Map objectToOldFeatureValuesMap;
    private Map objectToNewFeatureValuesMap;
    private boolean clear;

    public BatchCommand(boolean clear) {
        this.clear = clear;
    }

    public boolean canExecute() {
        return this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty();
    }

    public void execute() {
        if (this.objectToNewFeatureValuesMap == null || this.objectToNewFeatureValuesMap.isEmpty()) {
            return;
        }
        if (this.objectToOldFeatureValuesMap == null) {
            this.objectToOldFeatureValuesMap = new HashMap();
        }
        for (Map.Entry entry2 : this.objectToNewFeatureValuesMap.entrySet()) {
            EObject eObj = (EObject)entry2.getKey();
            Map featureMap = (Map)entry2.getValue();
            for (Map.Entry entry2 : featureMap.entrySet()) {
                EStructuralFeature feature = (EStructuralFeature)entry2.getKey();
                if (feature.isMany()) {
                    if (this.clear) {
                        eObj.eSet(feature, entry2.getValue());
                        continue;
                    }
                    ((List)eObj.eGet(feature)).addAll((Collection)entry2.getValue());
                    continue;
                }
                Object oldValue = eObj.eGet(feature);
                if (oldValue == entry2.getValue()) continue;
                this.saveOldFeatureValue(eObj, feature);
                eObj.eSet(feature, entry2.getValue());
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        EStructuralFeature feature;
        Map featureMap;
        EObject eObj;
        if (this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty()) {
            for (Map.Entry entry22 : this.objectToNewFeatureValuesMap.entrySet()) {
                eObj = (EObject)entry22.getKey();
                featureMap = (Map)entry22.getValue();
                for (Map.Entry entry22 : featureMap.entrySet()) {
                    feature = (EStructuralFeature)entry22.getKey();
                    if (!feature.isMany()) continue;
                    ((List)eObj.eGet(feature)).removeAll((Collection)entry22.getValue());
                }
            }
        }
        if (this.objectToOldFeatureValuesMap != null && !this.objectToOldFeatureValuesMap.isEmpty()) {
            for (Map.Entry entry22 : this.objectToOldFeatureValuesMap.entrySet()) {
                eObj = (EObject)entry22.getKey();
                featureMap = (Map)entry22.getValue();
                for (Map.Entry entry22 : featureMap.entrySet()) {
                    feature = (EStructuralFeature)entry22.getKey();
                    eObj.eSet(feature, entry22.getValue());
                }
            }
            this.objectToOldFeatureValuesMap.clear();
        }
    }

    public void addFeatureValue(EObject obj, EStructuralFeature feature, Object value) {
        BatchCommand.addFeatureValue(this.getObjectToNewFeatureValuesMap(), obj, feature, value);
    }

    public void addFeatureValues(EObject obj, EStructuralFeature feature, Collection values) {
        BatchCommand.addFeatureValues(this.getObjectToNewFeatureValuesMap(), obj, feature, values);
    }

    public Map getObjectToNewFeatureValuesMap() {
        if (this.objectToNewFeatureValuesMap == null) {
            this.objectToNewFeatureValuesMap = new HashMap();
        }
        return this.objectToNewFeatureValuesMap;
    }

    protected void saveOldFeatureValue(EObject eObj, EStructuralFeature feature) {
        HashMap featureMap;
        ArrayList value = eObj.eGet(feature);
        if (feature.isMany()) {
            value = new ArrayList(value);
        }
        if ((featureMap = (HashMap)this.objectToOldFeatureValuesMap.get(eObj)) == null) {
            featureMap = new HashMap();
            this.objectToOldFeatureValuesMap.put(eObj, featureMap);
        }
        featureMap.put(feature, value);
    }

    public void dispose() {
        if (this.objectToNewFeatureValuesMap != null) {
            this.objectToNewFeatureValuesMap.clear();
            this.objectToNewFeatureValuesMap = null;
        }
        if (this.objectToOldFeatureValuesMap != null) {
            this.objectToOldFeatureValuesMap.clear();
            this.objectToOldFeatureValuesMap = null;
        }
    }

    public static void addFeatureValue(Map descriptorToNewFeatureValuesMap, EObject object, EStructuralFeature feature, Object value) {
        HashMap<EStructuralFeature, Object> featureMap = (HashMap<EStructuralFeature, Object>)descriptorToNewFeatureValuesMap.get(object);
        if (featureMap == null) {
            featureMap = new HashMap<EStructuralFeature, Object>();
            descriptorToNewFeatureValuesMap.put(object, featureMap);
        }
        if (feature.isMany()) {
            ArrayList<Object> list = (ArrayList<Object>)featureMap.get(feature);
            if (list == null) {
                list = new ArrayList<Object>();
                featureMap.put(feature, list);
            }
            list.add(value);
        } else {
            featureMap.put(feature, value);
        }
    }

    public static void addFeatureValues(Map descriptorToNewFeatureValuesMap, EObject object, EStructuralFeature feature, Collection values) {
        ArrayList list;
        HashMap featureMap = (HashMap)descriptorToNewFeatureValuesMap.get(object);
        if (featureMap == null) {
            featureMap = new HashMap();
            descriptorToNewFeatureValuesMap.put(object, featureMap);
        }
        if ((list = (ArrayList)featureMap.get(feature)) == null) {
            list = new ArrayList();
            featureMap.put(feature, list);
        }
        list.addAll(values);
    }
}

