/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeQrCommand
extends MethodElementSetPropertyCommand {
    private boolean remove = false;
    private List<MethodElement> items;
    private Set<MethodElement> affectedSet = new HashSet<MethodElement>();
    private String qualifierId;
    private String oppositeName;

    public ChangeQrCommand(MethodElement element, List<MethodElement> items, String qualifierId, boolean remove) {
        super(element, "me_references");
        this.items = items;
        this.remove = remove;
        this.qualifierId = qualifierId;
        this.oppositeName = ExtendReferenceMap.getOppositeName(qualifierId);
    }

    @Override
    public void redo() {
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        List<MethodElement> listValue = propUtil.getQReferenceListById(this.element, this.qualifierId, true);
        if (listValue == null || this.items == null || this.items.isEmpty()) {
            return;
        }
        for (MethodElement p : this.items) {
            if (this.remove) {
                if (!listValue.remove(p)) continue;
                this.affectedSet.add(p);
                propUtil.removeOpposite(this.oppositeName, this.element, p);
                continue;
            }
            if (listValue.contains(p) || !listValue.add(p)) continue;
            this.affectedSet.add(p);
            propUtil.addOpposite(this.oppositeName, this.element, p);
        }
        try {
            this.value = propUtil.getReferencesXml(this.element, false);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.redo();
    }

    @Override
    public void undo() {
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        try {
            for (MethodElement p : this.affectedSet) {
                if (this.remove) {
                    propUtil.addOpposite(this.oppositeName, this.element, p);
                    continue;
                }
                propUtil.removeOpposite(this.oppositeName, this.element, p);
            }
            this.value = propUtil.getReferencesXml(this.element, true);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.undo();
    }
}

