/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.util.ExtendedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeReferenceCommand
extends MethodElementSetPropertyCommand {
    private boolean remove = false;
    private List<MethodElement> items;
    private Set<MethodElement> affectedSet = new HashSet<MethodElement>();
    private ExtendedReference reference;

    public ChangeReferenceCommand(MethodElement element, List<MethodElement> items, ExtendedReference reference, boolean remove) {
        super(element, "me_references");
        this.items = items;
        this.remove = remove;
        this.reference = reference;
    }

    @Override
    public void redo() {
        PropUtil propUtil = PropUtil.getPropUtil();
        List<MethodElement> listValue = propUtil.getExtendedReferenceList(this.element, this.reference, true);
        if (listValue == null || this.items == null || this.items.isEmpty()) {
            return;
        }
        for (MethodElement p : this.items) {
            if (this.remove) {
                if (!listValue.remove(p)) continue;
                this.affectedSet.add(p);
                propUtil.removeOpposite(this.reference, this.element, p);
                continue;
            }
            if (listValue.contains(p) || !listValue.add(p)) continue;
            this.affectedSet.add(p);
            propUtil.addOpposite(this.reference, this.element, p);
        }
        try {
            this.value = propUtil.getReferencesXml(this.element, false);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.redo();
    }

    @Override
    public void undo() {
        PropUtil propUtil = PropUtil.getPropUtil();
        try {
            for (MethodElement p : this.affectedSet) {
                if (this.remove) {
                    propUtil.addOpposite(this.reference, this.element, p);
                    continue;
                }
                propUtil.removeOpposite(this.reference, this.element, p);
            }
            this.value = propUtil.getReferencesXml(this.element, true);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.undo();
    }
}

