/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeUdtCommand
extends MethodElementSetPropertyCommand {
    private boolean remove = false;
    private List<Practice> items;
    private Set<Practice> affectedSet = new HashSet<Practice>();

    public ChangeUdtCommand(MethodElement element, List<Practice> items, boolean remove) {
        super(element, "me_references");
        this.items = items;
        this.remove = remove;
    }

    @Override
    public void redo() {
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        List<Practice> listValue = propUtil.getUdtList(this.element, true);
        if (listValue == null || this.items == null || this.items.isEmpty()) {
            return;
        }
        for (Practice p : this.items) {
            if (this.remove) {
                if (!listValue.remove(p)) continue;
                this.affectedSet.add(p);
                propUtil.removeOpposite(ExtendReferenceMap.UdtList, this.element, (MethodElement)p);
                continue;
            }
            if (listValue.contains(p) || !listValue.add(p)) continue;
            this.affectedSet.add(p);
            propUtil.addOpposite(ExtendReferenceMap.UdtList, this.element, (MethodElement)p);
        }
        try {
            this.value = propUtil.getReferencesXml(this.element, false);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.redo();
    }

    @Override
    public void undo() {
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        try {
            for (Practice p : this.affectedSet) {
                if (this.remove) {
                    propUtil.addOpposite(ExtendReferenceMap.UdtList, this.element, (MethodElement)p);
                    continue;
                }
                propUtil.removeOpposite(ExtendReferenceMap.UdtList, this.element, (MethodElement)p);
            }
            this.value = propUtil.getReferencesXml(this.element, true);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        super.undo();
    }
}

