/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.CommandStatusChecker;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.command.SaveStatus;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementAddCommand
extends CommandWrapper
implements IResourceAwareCommand {
    public static final Map<EClass, Collection<EStructuralFeature>> typeToExcludedFeaturesFromCheck = new HashMap<EClass, Collection<EStructuralFeature>>();
    protected boolean canUndo = true;
    protected AddCommand addCommand;
    protected Map elementToOldPluginMap;
    protected boolean removeXRefRequired;
    protected MethodPlugin ownerPlugin;
    protected ArrayList addList;
    protected MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
    protected boolean runWithProgress;
    protected ArrayList<EStructuralFeature> featuresToCheck;
    protected ArrayList nestedCommands;
    private HashSet modifiedResources;
    private ILibraryPersister.FailSafeMethodLibraryPersister persister;
    private Resource resource;
    private static ResourceManager resMgr = null;
    private static StringValidator stringValidator = null;

    public static void excludeFromCheck(EClass type, EStructuralFeature feature) {
        Collection<EStructuralFeature> features = typeToExcludedFeaturesFromCheck.get(type);
        if (features == null) {
            features = new HashSet<EStructuralFeature>();
        }
        features.add(feature);
    }

    public MethodElementAddCommand(Command command) {
        this(command, true);
    }

    public MethodElementAddCommand(Command command, boolean runWithProgress) {
        super(command);
        this.addCommand = (AddCommand)TngUtil.unwrap(command);
        this.setRunWithProgress(runWithProgress);
    }

    public void setRunWithProgress(boolean runWithProgress) {
        this.runWithProgress = runWithProgress;
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public Collection getResult() {
        if (this.status.isOK()) {
            return super.getResult();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleError(IStatus errorStatus) {
        Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.createElementError_msg, errorStatus);
        this.status.add(errorStatus);
        this.status.addAll(errorStatus);
    }

    public void dispose() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                Command cmd = (Command)this.nestedCommands.get(i);
                try {
                    cmd.dispose();
                }
                catch (Exception exception) {}
                --i;
            }
        }
        super.dispose();
    }

    public void execute() {
        Object shell = LibraryEditPlugin.getDefault().getContext();
        Collection resourcesToChange = this.getModifiedResources();
        IStatus execStatus = UserInteractionHelper.checkModify(resourcesToChange, shell);
        if (!execStatus.isOK()) {
            this.handleError(execStatus);
            return;
        }
        execStatus = UserInteractionHelper.checkConfigurationsToUpdate(this.addCommand, shell);
        if (!execStatus.isOK()) {
            this.handleError(execStatus);
            return;
        }
        if (this.willSaveModifiedResources() && !UserInteractionHelper.checkOutOfSynch(resourcesToChange)) {
            this.status.add(Status.CANCEL_STATUS);
            return;
        }
        this.doAdd();
    }

    public void undo() {
        this.undoNestedCommands();
        super.undo();
    }

    private void undoNestedCommands() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                block14: {
                    Command cmd = (Command)this.nestedCommands.get(i);
                    try {
                        try {
                            if (cmd.canUndo()) {
                                cmd.undo();
                            }
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                            try {
                                cmd.dispose();
                            }
                            catch (Exception exception) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            cmd.dispose();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        cmd.dispose();
                    }
                    catch (Exception exception) {}
                }
                --i;
            }
        }
    }

    private boolean checkFolder(Object shell) {
        IFileBasedLibraryPersister persister = (IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi");
        ArrayList<String> foldersToCheck = new ArrayList<String>();
        Iterator iter = this.addCommand.getCollection().iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || !persister.hasOwnResource(element)) continue;
            String folder = persister.getFolderRelativePath((MethodElement)element);
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
            String baseFolder = null;
            if (plugin == null) {
                MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)this.addCommand.getOwner());
                baseFolder = new File(lib.eResource().getURI().toFileString()).getParent();
            } else {
                baseFolder = new File(plugin.eResource().getURI().toFileString()).getParent();
            }
            foldersToCheck.add(String.valueOf(baseFolder) + File.separator + folder);
        }
        if (!foldersToCheck.isEmpty()) {
            String[] folders = new String[foldersToCheck.size()];
            foldersToCheck.toArray(folders);
            IStatus status = Services.getFileManager().checkModify(folders, shell);
            if (!status.isOK()) {
                this.handleError(status);
                return false;
            }
        }
        return true;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private boolean isMove() {
        Iterator iter;
        Command cmd = TngUtil.unwrap(this.command);
        if (cmd instanceof AddCommand && (iter = ((AddCommand)cmd).getCollection().iterator()).hasNext()) {
            EObject element = (EObject)iter.next();
            return UmaUtil.getMethodPlugin((EObject)element) != null;
        }
        return false;
    }

    public static Collection<Reference> getIllegalOutgoingReferences(MethodPlugin ownerPlugin, EObject e, Collection<Reference> illegalReferences) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (illegalReferences == null) {
            illegalReferences = new ArrayList<Reference>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)e.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            MethodPlugin plugin;
            EObject eObject = (EObject)featureIterator.next();
            EStructuralFeature feature = featureIterator.feature();
            if (feature.isDerived() || (plugin = UmaUtil.getMethodPlugin((EObject)eObject)) == null || plugin == ownerPlugin || Misc.isBaseOf(plugin, ownerPlugin, map)) continue;
            illegalReferences.add(new Reference(e, feature, eObject, -1));
            if (feature != UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement()) continue;
            feature = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType();
            illegalReferences.add(new Reference(e, feature, e.eGet(feature), -1));
        }
        return illegalReferences;
    }

    private static void removeReferences(Collection<Reference> references) {
        for (Reference ref : references) {
            if (ref.feature.isMany()) {
                List list = (List)ref.owner.eGet(ref.feature);
                list.remove(ref.value);
                continue;
            }
            ref.owner.eSet(ref.feature, null);
        }
    }

    public static Collection<Reference> removeIllegalReferences(MethodPlugin ownerPlugin, EObject e) {
        Collection<Reference> removeRefs = MethodElementAddCommand.getIllegalOutgoingReferences(ownerPlugin, e, null);
        MethodElementAddCommand.removeReferences(removeRefs);
        return removeRefs;
    }

    private static boolean hasNext(Iterator iter) {
        return iter.hasNext();
    }

    public static boolean hasIllegalReference(MethodPlugin ownerPlugin, EObject e, Collection moveList) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)e.eCrossReferences().iterator();
        while (MethodElementAddCommand.hasNext((Iterator)featureIterator)) {
            MethodPlugin plugin;
            EObject eObject = (EObject)featureIterator.next();
            if (moveList.contains(eObject) || (plugin = UmaUtil.getMethodPlugin((EObject)eObject)) == null || plugin == ownerPlugin || Misc.isBaseOf(plugin, ownerPlugin, map)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferencedIllegally(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Collection references = AssociationHelper.getReferences((MethodElement)e);
        for (MethodElement element : references) {
            MethodPlugin plugin;
            if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || moveList.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == ownerPlugin || Misc.isBaseOf(ownerPlugin, plugin, map)) continue;
            return true;
        }
        return false;
    }

    private static void checkModify(EObject element) {
        IStatus status = TngUtil.checkEdit(element, null);
        if (!status.isOK()) {
            throw new MessageException(TngUtil.getMessage(status));
        }
    }

    public static Collection removeIllegalReferencesTo(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        ArrayList<MethodElement> affectedReferencers = new ArrayList<MethodElement>();
        Collection references = AssociationHelper.getReferences((MethodElement)e);
        for (MethodElement element : references) {
            MethodPlugin plugin;
            if (moveList.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == ownerPlugin || Misc.isBaseOf(ownerPlugin, plugin, map)) continue;
            MethodElementAddCommand.checkModify((EObject)element);
            MethodElementAddCommand.removeReferences((EObject)element, (EObject)e);
            affectedReferencers.add(element);
        }
        return affectedReferencers;
    }

    private static Collection getXReferences(EObject referencer, EObject referenced, Collection xReferences) {
        if (xReferences == null) {
            xReferences = new ArrayList<EStructuralFeature>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)referencer.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject eObject = (EObject)featureIterator.next();
            EStructuralFeature feature = featureIterator.feature();
            if (eObject != referenced) continue;
            xReferences.add(feature);
        }
        return xReferences;
    }

    public static Collection removeReferences(EObject referencer, EObject referenced) {
        Collection removeRefs = MethodElementAddCommand.getXReferences(referencer, referenced, null);
        for (EStructuralFeature f : removeRefs) {
            if (f.isMany()) {
                ((Collection)referencer.eGet(f)).remove(referenced);
                continue;
            }
            referencer.eSet(f, null);
        }
        return removeRefs;
    }

    public static boolean hasIllegalReferenceIncludingAllChildren(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        if (ownerPlugin == UmaUtil.getMethodPlugin((EObject)e)) {
            return false;
        }
        if (MethodElementAddCommand.hasIllegalReference(ownerPlugin, (EObject)e, moveList)) {
            return true;
        }
        TreeIterator iterator = e.eAllContents();
        while (iterator.hasNext()) {
            if (!MethodElementAddCommand.hasIllegalReference(ownerPlugin, (EObject)iterator.next(), moveList)) continue;
            return true;
        }
        return false;
    }

    protected void superExecute() {
        super.execute();
    }

    protected Collection getFeaturesToCheck() {
        if (this.featuresToCheck == null) {
            this.featuresToCheck = new ArrayList();
            this.featuresToCheck.add((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        return this.featuresToCheck;
    }

    protected IValidator createValidator(EObject e, EStructuralFeature feature) {
        IValidator validator = null;
        if (this.addCommand.getFeature() instanceof EReference) {
            validator = IValidatorFactory.INSTANCE.createValidator(this.addCommand.getOwner(), (EReference)this.addCommand.getFeature(), (EClass)null, e, feature);
        }
        return validator;
    }

    private void getOffStringToCheckName(Object e, Collection objectsToCheckName) {
        if (this.addCommand.getOwner() instanceof ProcessPackage && this.addCommand.getFeature() == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && e instanceof ProcessPackage && !(e instanceof ProcessComponent)) {
            MethodElementAddCommand.getProcessComponents((ProcessPackage)e, objectsToCheckName);
        }
    }

    private static void getProcessComponents(ProcessPackage pkg, Collection objectsToCheckName) {
        for (Object childPkg : pkg.getChildPackages()) {
            if (childPkg instanceof ProcessComponent) {
                objectsToCheckName.add(childPkg);
                continue;
            }
            if (!(childPkg instanceof ProcessPackage)) continue;
            MethodElementAddCommand.getProcessComponents((ProcessPackage)childPkg, objectsToCheckName);
        }
    }

    protected boolean checkStringValue(NamedElement e, EStructuralFeature feature, Collection objectsToAdd) {
        Collection<EStructuralFeature> excludedFeaturesToCheck = typeToExcludedFeaturesFromCheck.get(e.eClass());
        if (excludedFeaturesToCheck != null && excludedFeaturesToCheck.contains(feature)) {
            return true;
        }
        IValidator validator = this.createValidator((EObject)e, feature);
        if (validator != null) {
            String newName = null;
            try {
                newName = MethodElementAddCommand.checkStringValue(e, feature, validator, objectsToAdd);
            }
            catch (OperationCanceledException operationCanceledException) {
                return false;
            }
            if (newName != null) {
                newName = newName.trim();
                e.eSet(feature, (Object)newName);
                this.featureChanged((EObject)e, feature, newName);
            }
        }
        return true;
    }

    protected boolean checkStringValue(EStructuralFeature feature) {
        ArrayList objectsToCheckName = new ArrayList();
        Collection objectsToAdd = this.addCommand.getCollection();
        for (NamedElement e : objectsToAdd) {
            if (!this.checkStringValue(e, feature, objectsToAdd)) {
                return false;
            }
            this.getOffStringToCheckName(e, objectsToCheckName);
        }
        for (NamedElement e : objectsToCheckName) {
            EAttribute f;
            if (this.checkStringValue(e, (EStructuralFeature)(f = UmaPackage.eINSTANCE.getNamedElement_Name()), objectsToCheckName)) continue;
            return false;
        }
        return true;
    }

    protected void featureChanged(EObject object, EStructuralFeature feature, Object newValue) {
    }

    private static Collection getElementsToCheckName(AddCommand addCommand) {
        ArrayList elements = new ArrayList(addCommand.getCollection());
        for (Object element : addCommand.getCollection()) {
            if (!(element instanceof ProcessPackage)) continue;
            AbstractTreeIterator iterator = new AbstractTreeIterator(element, false){
                private static final long serialVersionUID = 1L;

                protected Iterator getChildren(Object object) {
                    if (object instanceof ProcessComponent) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                    if (object instanceof ProcessPackage) {
                        return ((ProcessPackage)object).getChildPackages().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (iterator.hasNext()) {
                Object pkg = iterator.next();
                if (!(pkg instanceof ProcessComponent)) continue;
                elements.add(pkg);
            }
        }
        return elements;
    }

    protected static Map checkName(AddCommand addCommand) {
        Collection elementsToCheck = MethodElementAddCommand.getElementsToCheckName(addCommand);
        HashMap<NamedElement, String> elementToNewNameMap = new HashMap<NamedElement, String>();
        for (NamedElement e : elementsToCheck) {
            IValidator validator = e instanceof ContentElement ? new ContentElementNameValidator(addCommand.getOwner(), addCommand.getFeature(), (ContentElement)e, new ValidatorFactory.TypeFilter((EObject)e)) : IValidatorFactory.INSTANCE.createNameValidator((Object)addCommand.getOwner(), e);
            String newName = null;
            try {
                newName = MethodElementAddCommand.checkStringValue(e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), validator, elementsToCheck);
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            if (newName == null) continue;
            IStatus status = UserInteractionHelper.checkModify((EObject)e, LibraryEditPlugin.getDefault().getContext());
            String title = LibraryEditResources.errorDialog_title;
            String msg = MessageFormat.format(LibraryEditResources.errorDialog_cannotRename, TngUtil.getTypeText((EObject)e), e.getName(), newName);
            while (!status.isOK()) {
                IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
                if (uiHandler != null) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    if (uiHandler.selectOne(nArray, title, msg, null) != 1) continue;
                    return null;
                }
                return null;
            }
            elementToNewNameMap.put(e, newName);
        }
        return elementToNewNameMap;
    }

    public static String checkStringValue(NamedElement e, EStructuralFeature feature, IValidator validator, Collection objectsToAdd) throws OperationCanceledException {
        String msg;
        final StringValidator strValidator = MethodElementAddCommand.getStringValidator();
        strValidator.setElements(objectsToAdd);
        strValidator.setFeature(feature);
        strValidator.setValidator(validator);
        String str = (String)e.eGet(feature);
        if (str != null && str.length() > 0 && (msg = strValidator.isValid(str)) != null) {
            String featureTxt = TngUtil.getFeatureText(feature);
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)e.getName());
            String currentValue = (String)e.eGet(feature);
            AbstractStringValidator inputValidator = new AbstractStringValidator(){

                public String isValid(String newText) {
                    if (strValidator != null) {
                        return UserInteractionHelper.getSimpleErrorMessage(strValidator.isValid(newText));
                    }
                    return null;
                }
            };
            IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
            if (uiHandler != null) {
                UserInput input = new UserInput("", 0, false, null, null, inputValidator, null);
                input.setInput(currentValue);
                List<UserInput> userInputs = Collections.singletonList(input);
                if (uiHandler.requestInput(title, dlgMsg, userInputs)) {
                    return (String)userInputs.get(0).getInput();
                }
                throw new OperationCanceledException();
            }
        }
        return null;
    }

    public Collection getAffectedObjects() {
        Set<EObject> affectedObjects = super.getAffectedObjects();
        if (affectedObjects == null) {
            EObject owner = this.addCommand.getOwner();
            affectedObjects = owner == null ? Collections.EMPTY_SET : Collections.singleton(owner);
        }
        return affectedObjects;
    }

    protected Collection getElementsToCheckForIllegalReferences() {
        return this.addCommand.getCollection();
    }

    private static boolean isExcludedFromOutgoingReferenceCheck(Object e) {
        return e instanceof ProcessPackage || e instanceof ProcessElement;
    }

    protected String checkForIllegalReferences() {
        Collection elements = this.getElementsToCheckForIllegalReferences();
        this.addList = new ArrayList(elements);
        for (Object element : elements) {
            TreeIterator iterator = element.eAllContents();
            while (iterator.hasNext()) {
                this.addList.add(iterator.next());
            }
        }
        this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
        this.removeXRefRequired = false;
        if (this.ownerPlugin != null) {
            for (Object element : this.addCommand.getCollection()) {
                if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || !(element instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)element, this.addList)) continue;
                this.removeXRefRequired = true;
                break;
            }
        }
        if (this.removeXRefRequired) {
            return LibraryEditResources.invalidReferencesError_reason;
        }
        return null;
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
        }
        if (this.addFeatureIsContainment()) {
            ILibraryPersister persister = Services.getDefaultLibraryPersister();
            boolean saveOwnerResource = false;
            for (Object e : this.addCommand.getCollection()) {
                if (persister.hasOwnResourceWithoutReferrer(e)) continue;
                saveOwnerResource = true;
            }
            if (saveOwnerResource) {
                this.modifiedResources.add(this.addCommand.getOwner().eResource());
            }
        } else {
            this.modifiedResources.add(this.addCommand.getOwner().eResource());
        }
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                Command cmd = (Command)this.nestedCommands.get(i);
                try {
                    Collection<? extends Resource> resources;
                    if (cmd instanceof IResourceAwareCommand && (resources = ((IResourceAwareCommand)cmd).getModifiedResources()) != null) {
                        this.modifiedResources.addAll(resources);
                    }
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                --i;
            }
        }
        return this.modifiedResources;
    }

    protected boolean willSaveModifiedResources() {
        return true;
    }

    private ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        return Services.getDefaultLibraryPersister().getFailSafePersister();
    }

    /*
     * Exception decompiling
     */
    protected void saveModifiedResources() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection replaceTextReferences(Collection elementsToCopyRefContents) {
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        ITextReferenceReplacer txtRefReplacer = ExtensionManager.getTextReferenceReplacer();
        if (txtRefReplacer == null) {
            return modifiedResources;
        }
        EditingDomain ed = this.addCommand.getDomain();
        if (ed instanceof TraceableAdapterFactoryEditingDomain) {
            Map copyToOriginalMap = ((TraceableAdapterFactoryEditingDomain)ed).getCopyToOriginalMap();
            HashMap oldToNewObjectMap = new HashMap();
            for (Map.Entry entry : copyToOriginalMap.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key == null || val == null) continue;
                oldToNewObjectMap.put(val, key);
            }
            for (EObject element : elementsToCopyRefContents) {
                TreeIterator childIter = element.eAllContents();
                while (childIter.hasNext()) {
                    EObject child = (EObject)childIter.next();
                    for (EAttribute attribute : child.eClass().getEAllAttributes()) {
                        String newtext;
                        String text;
                        if (!attribute.isChangeable() || attribute.isDerived() || !attribute.isMany() && !child.eIsSet((EStructuralFeature)attribute) || attribute.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass() || (text = (String)child.eGet((EStructuralFeature)attribute)) == null || (newtext = txtRefReplacer.replace(text, child, oldToNewObjectMap)).equals(text)) continue;
                        child.eSet((EStructuralFeature)attribute, (Object)newtext);
                        modifiedResources.add(child.eResource());
                    }
                }
            }
        }
        return modifiedResources;
    }

    protected void doAdd() {
        try {
            int ret;
            IUserInteractionHandler uiHandler;
            for (EStructuralFeature feature : this.getFeaturesToCheck()) {
                if (this.checkStringValue(feature)) continue;
                return;
            }
            boolean showWarning = false;
            EditingDomain ed = this.addCommand.getDomain();
            if (ed instanceof TraceableAdapterFactoryEditingDomain) {
                Map copyToOriginalMap = ((TraceableAdapterFactoryEditingDomain)ed).getCopyToOriginalMap();
                if (this.addCommand.getCollection() != null && this.addCommand.getCollection().size() > 0 && copyToOriginalMap.containsKey(this.addCommand.getCollection().toArray()[0])) {
                    this.elementToOldPluginMap = new HashMap();
                    for (Map.Entry entry : copyToOriginalMap.entrySet()) {
                        if (!(entry.getValue() instanceof MethodElement) || entry.getValue() instanceof MethodConfiguration) continue;
                        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)entry.getValue()));
                        if (plugin != null) {
                            this.elementToOldPluginMap.put(entry.getKey(), plugin);
                            continue;
                        }
                        showWarning = true;
                    }
                }
            }
            if (showWarning) {
                Messenger.INSTANCE.showWarning(this.getLabel(), LibraryEditResources.MethodElementAddCommand_originalNotFoundWarning_msg);
            }
            final StringBuffer msgBuff = new StringBuffer();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    String msg = MethodElementAddCommand.this.checkForIllegalReferences();
                    if (msg != null) {
                        msgBuff.append(msg);
                    }
                }
            };
            NullProgressMonitor defaultMonitor = null;
            if (!this.runWithProgress) {
                defaultMonitor = new NullProgressMonitor();
            }
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress(operation, LibraryEditResources.checkingReferencesTask_name);
            } else {
                try {
                    operation.run((IProgressMonitor)defaultMonitor);
                }
                catch (RuntimeException e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw e;
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw new RuntimeException(e.toString());
                }
            }
            if (msgBuff.length() > 0 && (uiHandler = ExtensionManager.getDefaultUserInteractionHandler()) != null && (ret = uiHandler.selectOne(new int[]{4, 5}, this.getLabel(), msgBuff.toString(), null)) == 5) {
                return;
            }
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.MethodElementAddCommand_errorSavingFiles, null);
            operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    if (MethodElementAddCommand.this.removeXRefRequired) {
                        monitor.subTask("");
                        for (EObject element : MethodElementAddCommand.this.addList) {
                            if (!(element instanceof MethodElement)) continue;
                            MethodElementAddCommand.removeIllegalReferences(MethodElementAddCommand.this.ownerPlugin, element);
                        }
                    }
                    MethodElementAddCommand.this.superExecute();
                    PropUtil propUtil = PropUtil.getPropUtil();
                    for (Object addedItem : MethodElementAddCommand.this.addList) {
                        MethodPackage pkg;
                        Boolean b;
                        if (!(addedItem instanceof MethodPackage) || (b = propUtil.getBooleanValue((MethodElement)(pkg = (MethodPackage)addedItem), "pkg_loadCheck")) != null && b.booleanValue()) continue;
                        propUtil.setBooleanValue((MethodElement)pkg, "pkg_loadCheck", true);
                    }
                    MethodElementAddCommand.this.executeNestedCommands();
                    if (MethodElementAddCommand.this.willSaveModifiedResources()) {
                        IStatus result = MethodElementAddCommand.this.saveNewElementsWithOwnResource();
                        if (result.isOK()) {
                            monitor.subTask(LibraryEditResources.savingModifiedFilesTask_name);
                            MethodElementAddCommand.this.saveModifiedResources();
                        } else {
                            MethodElementAddCommand.this.status.add(result);
                        }
                    }
                    if (!MethodElementAddCommand.this.status.isOK()) {
                        MethodElementAddCommand.this.undo();
                        if (CommandStatusChecker.hasRollbackError((IStatus)MethodElementAddCommand.this.status)) {
                            Collection createdElements = MethodElementAddCommand.this.command.getResult();
                            ILibraryPersister persister = Services.getDefaultLibraryPersister();
                            for (Object object : createdElements) {
                                if (!(object instanceof MethodElement)) continue;
                                try {
                                    persister.delete((MethodElement)object);
                                }
                                catch (Exception e) {
                                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                                }
                            }
                        }
                    }
                }
            };
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress(operation, "");
            } else {
                try {
                    operation.run((IProgressMonitor)defaultMonitor);
                }
                catch (RuntimeException e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw e;
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw new RuntimeException(e.toString());
                }
            }
            if (!this.status.isOK()) {
                Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.error_msgWithDetails, (IStatus)this.status);
                return;
            }
        }
        catch (RuntimeException e) {
            Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.error_msg, null, e);
        }
    }

    private boolean addFeatureIsContainment() {
        return this.addCommand.getFeature() instanceof EReference && ((EReference)this.addCommand.getFeature()).isContainment();
    }

    protected IStatus saveNewElementsWithOwnResource() {
        if (this.addFeatureIsContainment()) {
            ILibraryPersister persister = Services.getDefaultLibraryPersister();
            for (Object element : this.addList) {
                IStatus is;
                if (!(element instanceof MethodElement)) continue;
                MethodElement me = (MethodElement)element;
                if ((me instanceof ContentElement || me instanceof MethodPlugin || me instanceof MethodConfiguration) && (is = this.checkFilePathLengthBeforeSave(me)) != null) {
                    return is;
                }
                if (!persister.hasOwnResourceWithoutReferrer((Object)me)) continue;
                try {
                    persister.save(me);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                    String msg = e.getMessage();
                    if (StrUtil.isBlank((String)msg)) {
                        msg = e.toString();
                    }
                    return new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFilePathLengthBeforeSave(MethodElement element) {
        Object parentElementWithResource = null;
        parentElementWithResource = element instanceof MethodPlugin || element instanceof MethodConfiguration ? UmaUtil.getMethodLibrary((EObject)element) : UmaUtil.getMethodPlugin((EObject)element);
        if (!NameChecker.checkFilePathLength((MethodElement)parentElementWithResource, element, element.getName(), 255, null)) {
            String msg = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{new Integer(255)});
            return new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, null);
        }
        return null;
    }

    protected void executeNestedCommands() {
        List<INestedCommandProvider> nestedCommandProviders = ExtensionManager.getNestedCommandProviders();
        if (!nestedCommandProviders.isEmpty() && !this.addList.isEmpty()) {
            this.nestedCommands = new ArrayList();
            for (INestedCommandProvider cmdProvider : nestedCommandProviders) {
                try {
                    Command cmd = cmdProvider.createRelatedObjects(this.addList, this);
                    if (cmd == null || !cmd.canExecute()) continue;
                    cmd.execute();
                    this.nestedCommands.add(cmd);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    public static void setResourceManager(ResourceManager resMgr) {
        MethodElementAddCommand.resMgr = resMgr;
    }

    protected static StringValidator getStringValidator() {
        if (stringValidator == null) {
            stringValidator = new StringValidator();
        }
        return stringValidator;
    }

    static /* synthetic */ ResourceManager access$2() {
        return resMgr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicResourceManager
    implements ResourceManager {
        @Override
        public Collection<Resource> copyReferencedContents(Collection<MethodElement> elements, Map<MethodElement, MethodPlugin> elementToOldPluginMap) {
            return null;
        }
    }

    private static class ContainmentInfo {
        EObject container;
        int index;

        ContainmentInfo(EObject container, int index) {
            this.container = container;
            this.index = index;
        }
    }

    private static class IllegalReferenceRemover {
        private MethodPlugin targetPlugin;
        private Collection elementsToMove;
        private List illegalReferences;
        private Set affectedResources;
        private ArrayList removedReferences;
        private boolean searchOutgoingRefs;
        private boolean searchIncomingRefs;

        public IllegalReferenceRemover(MethodPlugin targetPlugin, Collection elementsToMove, boolean searchOutgoingRefs, boolean searchIncomingRefs) {
            this.targetPlugin = targetPlugin;
            this.elementsToMove = elementsToMove;
            this.searchOutgoingRefs = searchOutgoingRefs;
            this.searchIncomingRefs = searchIncomingRefs;
        }

        public Set getAffectedResources() {
            if (this.affectedResources == null) {
                this.illegalReferences = new ArrayList();
                for (Object obj : this.elementsToMove) {
                    if (!(obj instanceof MethodElement)) continue;
                    MethodElement e = (MethodElement)obj;
                    if (this.searchOutgoingRefs && !MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(obj)) {
                        MethodElementAddCommand.getIllegalOutgoingReferences(this.targetPlugin, (EObject)e, this.illegalReferences);
                    }
                    if (!this.searchIncomingRefs) continue;
                    this.getIllegalIncomingReferences(e);
                }
                this.affectedResources = new HashSet();
                for (Reference ref : this.illegalReferences) {
                    if (ref.owner.eResource() == null) continue;
                    this.affectedResources.add(ref.owner.eResource());
                }
            }
            return this.affectedResources;
        }

        private void getIllegalIncomingReferences(MethodElement e) {
            Collection references = AssociationHelper.getReferences((MethodElement)e);
            for (MethodElement element : references) {
                MethodPlugin plugin;
                if (this.elementsToMove.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == this.targetPlugin || Misc.isBaseOf(this.targetPlugin, plugin, new HashMap<String, Boolean>())) continue;
                Collection xRefs = MethodElementAddCommand.getXReferences((EObject)element, (EObject)e, null);
                for (EStructuralFeature f : xRefs) {
                    this.illegalReferences.add(new Reference((EObject)element, f, e));
                }
            }
        }

        public void removeIllegalReferences() {
            this.removedReferences = new ArrayList();
            for (Reference ref : this.illegalReferences) {
                if (ref.feature.isMany()) {
                    List list = (List)ref.owner.eGet(ref.feature);
                    list.remove(ref.value);
                } else if (ref.feature == UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType()) {
                    ref.owner.eSet(ref.feature, (Object)VariabilityType.NA);
                } else {
                    ref.owner.eSet(ref.feature, null);
                    if (ref.feature == UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement()) {
                        ref.owner.eSet((EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)VariabilityType.NA);
                    }
                }
                this.removedReferences.add(ref);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void restoreRemovedReferences() {
            if (this.removedReferences == null) {
                return;
            }
            i = this.removedReferences.size() - 1;
            while (i > -1) {
                ref = (Reference)this.removedReferences.get(i);
                if (ref.feature.isMany()) {
                    list = (List)ref.owner.eGet(ref.feature);
                    if (ref.index != -1) {
                        if (list.contains(ref.value)) ** GOTO lbl23
                        if (ref.index < list.size()) {
                            list.add(ref.index, ref.value);
                        }
                        list.add(ref.value);
                    } else {
                        list.add(ref.value);
                    }
                } else {
                    ref.owner.eSet(ref.feature, ref.value);
                }
lbl23:
                // 5 sources

                --i;
            }
        }
    }

    public static class MoveOperation
    extends CommandWrapper {
        private static final int STATE_START = 0;
        private static final int STATE_SAVED_FILES = 80;
        private static final int STATE_MOVED_FILES = 70;
        private static final int STATE_COPIED_RESOURCES = 90;
        private static final int STATE_END = 100;
        private AddCommand addCommand;
        private Collection moveList;
        private boolean removeXRefRequired = false;
        private boolean isRefenrecedIllegally = false;
        private MethodPlugin ownerPlugin;
        private Map elementToOldPluginMap;
        private Map elementToNewNameMap;
        private IProgressMonitor monitor;
        private Object shell;
        private HashSet movedResources;
        protected MultiStatus status;
        private int state;
        protected Set modifiedResources;
        private IllegalReferenceRemover illegalReferenceRemover;
        private HashMap elementToOldContainerMap;
        private RefPluginsInfo refPluginsInfo;
        private MethodPlugin pluginForAddingTagetAsBase;
        private Set<MethodPackage> pkgsMarkedByLoadCheck;

        public MoveOperation(Command command, IProgressMonitor monitor, Object shell) {
            super(command);
            this.addCommand = (AddCommand)TngUtil.unwrap(command);
            this.monitor = monitor;
            this.shell = shell;
        }

        public Map getElementToOldPluginMap() {
            return this.elementToOldPluginMap;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean reloadNeeded() {
            return this.status != null && CommandStatusChecker.hasRollbackError((IStatus)this.status);
        }

        public void undo() {
            NamedElement e;
            if (this.elementToNewNameMap != null) {
                for (Map.Entry entry : this.elementToNewNameMap.entrySet()) {
                    e = (NamedElement)entry.getKey();
                    e.setName((String)entry.getValue());
                }
            }
            if (this.elementToOldContainerMap != null) {
                for (Map.Entry entry : this.elementToOldContainerMap.entrySet()) {
                    e = (EObject)entry.getKey();
                    ContainmentInfo containmentInfo = (ContainmentInfo)entry.getValue();
                    EStructuralFeature f = this.addCommand.getFeature();
                    if (f.isMany()) {
                        ((List)containmentInfo.container.eGet(f)).add(containmentInfo.index, e);
                        continue;
                    }
                    containmentInfo.container.eSet(f, (Object)e);
                }
            }
            if (this.illegalReferenceRemover != null) {
                this.illegalReferenceRemover.restoreRemovedReferences();
            }
            if (this.refPluginsInfo != null && !this.refPluginsInfo.refPluginsToAdd.isEmpty()) {
                this.ownerPlugin.getBases().removeAll(this.refPluginsInfo.refPluginsToAdd);
            }
            if (this.pluginForAddingTagetAsBase != null) {
                this.pluginForAddingTagetAsBase.getBases().remove(this.ownerPlugin);
            }
            if (this.pkgsMarkedByLoadCheck != null) {
                PropUtil propUtil = PropUtil.getPropUtil();
                for (MethodPackage pkg : this.pkgsMarkedByLoadCheck) {
                    propUtil.setBooleanValue((MethodElement)pkg, "pkg_loadCheck", false);
                }
            }
        }

        public void execute() {
            this.run();
        }

        public void run() {
            this.state = 0;
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
            if (this.checkName()) {
                IStatus execStatus;
                IStatus iStatus = execStatus = this.movingCC() ? Status.OK_STATUS : UserInteractionHelper.checkConfigurationsToUpdate(this.addCommand, this.shell);
                if (!execStatus.isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, execStatus);
                    return;
                }
                final StringBuffer msgBuffer = new StringBuffer();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.subTask(LibraryEditResources.checkingReferencesTask_name);
                        String msg = MoveOperation.this.checkForIllegalReferences();
                        if (msg != null) {
                            msgBuffer.append(msg);
                        }
                    }
                };
                IStatus stat = UserInteractionHelper.getUIHelper().runInModalContext(runnable, true, this.monitor, this.shell);
                if (!stat.isOK()) {
                    this.status.add(stat);
                    return;
                }
                if (msgBuffer.length() > 0 && !this.addRefPlugins()) {
                    return;
                }
                final HashMap<EObject, Resource> elementToOldResourceMap = new HashMap<EObject, Resource>();
                for (EObject eObject : this.moveList) {
                    if (!(eObject instanceof MethodElement)) continue;
                    elementToOldResourceMap.put(eObject, eObject.eResource());
                }
                this.modifiedResources = new HashSet();
                for (Map.Entry entry : this.elementToNewNameMap.entrySet()) {
                    ContentElement e;
                    NamedElement element = (NamedElement)entry.getKey();
                    element.setName((String)entry.getValue());
                    this.modifiedResources.add(element.eResource());
                    if (!(element instanceof MethodUnit)) continue;
                    this.movedResources.add(element.eResource());
                    if (!(element instanceof ContentElement) || !ContentDescriptionFactory.hasPresentation((MethodElement)(e = (ContentElement)element))) continue;
                    this.movedResources.add(e.getPresentation());
                }
                runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.setTaskName(LibraryEditResources.movingTask_name);
                        MoveOperation.this.doMove(monitor, elementToOldResourceMap, MoveOperation.this.modifiedResources);
                    }
                };
                stat = UserInteractionHelper.getUIHelper().runInModalContext(runnable, true, this.monitor, this.shell);
                if (!stat.isOK()) {
                    this.undo();
                    this.status.add(stat);
                    return;
                }
                ArrayList resources = new ArrayList(this.movedResources);
                resources.removeAll(this.modifiedResources);
                execStatus = UserInteractionHelper.checkModify(resources, this.shell);
                if (!execStatus.isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, execStatus);
                    this.undo();
                    return;
                }
                runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IStatus saveStatus = MoveOperation.this.save(monitor);
                            if (!saveStatus.isOK()) {
                                MoveOperation.this.status.add(saveStatus);
                            }
                        }
                        catch (RuntimeException e) {
                            LibraryEditPlugin.INSTANCE.log(e);
                            throw e;
                        }
                    }
                };
                stat = UserInteractionHelper.getUIHelper().runInModalContext(runnable, true, this.monitor, this.shell);
                if (!stat.isOK()) {
                    this.status.add(stat);
                    return;
                }
                NestedCommandExcecutor nestedCommandExcecutor = new NestedCommandExcecutor((Command)this);
                try {
                    nestedCommandExcecutor.executeNestedCommands();
                }
                finally {
                    nestedCommandExcecutor.dispose();
                }
            }
            this.state = 100;
        }

        @Deprecated
        private void removeReferences() {
            if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                IStatus execStatus;
                this.illegalReferenceRemover = new IllegalReferenceRemover(this.ownerPlugin, this.moveList, this.removeXRefRequired, this.isRefenrecedIllegally);
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.subTask(LibraryEditResources.checkAffectedResourcesTask_name);
                        MoveOperation.this.modifiedResources = MoveOperation.this.illegalReferenceRemover.getAffectedResources();
                    }
                };
                IStatus stat = UserInteractionHelper.getUIHelper().runInModalContext(runnable, true, this.monitor, this.shell);
                if (!stat.isOK()) {
                    this.status.add(stat);
                }
                if (!(execStatus = UserInteractionHelper.checkModify(this.modifiedResources, this.shell)).isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, execStatus);
                }
                try {
                    this.monitor.subTask(LibraryEditResources.removingReferencestask_name);
                    this.illegalReferenceRemover.removeIllegalReferences();
                }
                catch (Exception e) {
                    this.undo();
                    String msg = TngUtil.toStackTraceString(e);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, (Throwable)e));
                }
            } else {
                this.modifiedResources = new HashSet();
                this.monitor.subTask("");
            }
        }

        private boolean addRefPlugins() {
            int ret;
            String str;
            IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
            if (uiHandler == null) {
                return false;
            }
            this.refPluginsInfo = this.calRefPluginsInfo(this.ownerPlugin);
            ArrayList<String> pluginsToAdd = new ArrayList<String>();
            for (MethodPlugin p : this.refPluginsInfo.refPluginsToAdd) {
                pluginsToAdd.add(p.getName());
            }
            if (pluginsToAdd.size() > 1) {
                Collections.sort(pluginsToAdd);
            }
            if (!pluginsToAdd.isEmpty()) {
                str = " " + this.ownerPlugin.getName() + ":";
                for (String p : pluginsToAdd) {
                    str = String.valueOf(str) + "\n" + p;
                }
                int ret2 = uiHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.moveDialog_title, String.valueOf(LibraryEditResources.moveDialog_addRefPluginsWarningText) + "\n\n" + LibraryEditResources.moveDialog_addRefPluginsText + str, null);
                if (ret2 == 1) {
                    this.refPluginsInfo.refPluginsToAdd.clear();
                    return false;
                }
                if (ret2 == 5) {
                    this.refPluginsInfo.refPluginsToAdd.clear();
                } else {
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    for (MethodPlugin baseToAdd : this.refPluginsInfo.refPluginsToAdd) {
                        if (baseToAdd == this.ownerPlugin || Misc.isBaseOf(this.ownerPlugin, baseToAdd, map) || Misc.isBaseOf(baseToAdd, this.ownerPlugin, map)) continue;
                        this.ownerPlugin.getBases().add(baseToAdd);
                    }
                }
                return true;
            }
            this.pluginForAddingTagetAsBase = this.getPluginForAddingTagetAsBase(true);
            if (this.pluginForAddingTagetAsBase != null) {
                str = " " + this.pluginForAddingTagetAsBase.getName() + ":";
                str = String.valueOf(str) + "\n" + this.ownerPlugin.getName();
                int ret3 = uiHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.moveDialog_title, String.valueOf(LibraryEditResources.moveDialog_addRefPluginsWarningText) + "\n\n" + LibraryEditResources.moveDialog_addRefPluginsText + str, null);
                if (ret3 == 1) {
                    this.pluginForAddingTagetAsBase = null;
                    if (!this.refPluginsInfo.refPluginsToAdd.isEmpty()) {
                        this.ownerPlugin.getBases().removeAll(this.refPluginsInfo.refPluginsToAdd);
                        this.refPluginsInfo.refPluginsToAdd.clear();
                    }
                    return false;
                }
                if (ret3 == 5) {
                    this.pluginForAddingTagetAsBase = null;
                } else {
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    if (this.pluginForAddingTagetAsBase != this.ownerPlugin && !Misc.isBaseOf(this.ownerPlugin, this.pluginForAddingTagetAsBase, map) && !Misc.isBaseOf(this.pluginForAddingTagetAsBase, this.ownerPlugin, map)) {
                        this.pluginForAddingTagetAsBase.getBases().add(this.ownerPlugin);
                    }
                }
                return true;
            }
            return this.refPluginsInfo.refPluginsCircular.isEmpty() && this.getPluginForAddingTagetAsBase(false) == null || (ret = uiHandler.selectOne(new int[]{4, 1}, LibraryEditResources.moveDialog_title, LibraryEditResources.moveDialog_addRefPluginsWarningText1, null)) != 1;
        }

        private MethodPlugin getPluginForAddingTagetAsBase(boolean testCircular) {
            MethodPlugin srcPlugin = null;
            HashSet<MethodElement> moveSet = new HashSet<MethodElement>();
            for (Object obj : this.moveList) {
                if (!(obj instanceof MethodElement)) continue;
                if (srcPlugin == null) {
                    srcPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)obj));
                }
                moveSet.add((MethodElement)obj);
            }
            if (srcPlugin == null) {
                return null;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (Misc.isBaseOf(this.ownerPlugin, srcPlugin, map) || testCircular && Misc.isBaseOf(srcPlugin, this.ownerPlugin, map)) {
                return null;
            }
            CustomCategory srcRoot = TngUtil.getRootCustomCategory(srcPlugin);
            for (MethodElement element : moveSet) {
                for (MethodElement referencing : AssociationHelper.getReferences((MethodElement)element)) {
                    if (moveSet.contains(referencing) || srcPlugin != UmaUtil.getMethodPlugin((EObject)referencing) || referencing == srcRoot) continue;
                    return srcPlugin;
                }
            }
            return null;
        }

        private RefPluginsInfo calRefPluginsInfo(MethodPlugin ownerPlugin) {
            RefPluginsInfo info = new RefPluginsInfo();
            Set<MethodPlugin> refPluginsToAdd = info.refPluginsToAdd;
            Set<MethodPlugin> refPluginsCircular = info.refPluginsCircular;
            Set<MethodPlugin> refPluginsToAddBase = info.refPluginsToAddBase;
            ArrayList<MethodPlugin> referencedPlugnList = new ArrayList<MethodPlugin>();
            for (EObject element : this.moveList) {
                if (!(element instanceof MethodElement)) continue;
                Collection<Reference> iReferences = MethodElementAddCommand.getIllegalOutgoingReferences(ownerPlugin, element, null);
                for (Reference ref : iReferences) {
                    MethodPlugin p;
                    Object value = ref.getValue();
                    if (!(value instanceof MethodElement) || (p = UmaUtil.getMethodPlugin((EObject)((MethodElement)value))) == null || !refPluginsToAdd.add(p)) continue;
                    referencedPlugnList.add(p);
                }
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (MethodPlugin plugin : referencedPlugnList) {
                if (Misc.isBaseOf(ownerPlugin, plugin, map)) {
                    refPluginsCircular.add(plugin);
                    refPluginsToAdd.remove(plugin);
                    continue;
                }
                if (!refPluginsToAdd.contains(plugin)) continue;
                ArrayList<MethodPlugin> toRmoveList = new ArrayList<MethodPlugin>();
                for (MethodPlugin testBasePlugin : refPluginsToAdd) {
                    if (!Misc.isBaseOf(testBasePlugin, plugin, map)) continue;
                    refPluginsToAddBase.add(testBasePlugin);
                    toRmoveList.add(testBasePlugin);
                }
                refPluginsToAdd.removeAll(toRmoveList);
            }
            return info;
        }

        private boolean checkName() {
            this.elementToNewNameMap = MethodElementAddCommand.checkName(this.addCommand);
            return this.elementToNewNameMap != null;
        }

        private boolean movingCC() {
            return this instanceof MoveOperationExt;
        }

        private String checkForIllegalReferences() {
            this.elementToOldPluginMap = new HashMap();
            this.moveList = new ArrayList(this.addCommand.getCollection());
            this.movedResources = new HashSet();
            for (Object element : this.addCommand.getCollection()) {
                if (element instanceof MethodElement) {
                    this.elementToOldPluginMap.put(element, UmaUtil.getMethodPlugin((EObject)element));
                }
                TreeIterator iterator = element.eAllContents();
                while (iterator.hasNext()) {
                    this.moveList.add(iterator.next());
                }
            }
            this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
            for (Object element : this.addCommand.getCollection()) {
                if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || !(element instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)element, this.moveList)) continue;
                this.removeXRefRequired = true;
                break;
            }
            for (Object element : this.moveList) {
                if (!(element instanceof MethodElement) || !this.referencedIllegally(this.ownerPlugin, (MethodElement)element, this.moveList)) continue;
                this.isRefenrecedIllegally = true;
                break;
            }
            if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                return LibraryEditResources.invalidReferencesError_reason;
            }
            return null;
        }

        protected boolean referencedIllegally(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
            return MethodElementAddCommand.isReferencedIllegally(ownerPlugin, e, moveList);
        }

        protected void doMove(IProgressMonitor monitor, Map elementToOldResourceMap, Set modifiedResources) {
            monitor.subTask("");
            PropUtil propUtil = PropUtil.getPropUtil();
            this.elementToOldContainerMap = new HashMap();
            this.pkgsMarkedByLoadCheck = new HashSet<MethodPackage>();
            for (EObject element : this.addCommand.getCollection()) {
                MethodPackage pkg;
                Boolean b;
                if (!(element instanceof MethodElement)) continue;
                EObject container = element.eContainer();
                EStructuralFeature feature = element.eContainingFeature();
                int index = feature.isMany() ? ((List)container.eGet(feature)).indexOf(element) : -1;
                this.elementToOldContainerMap.put(element, new ContainmentInfo(container, index));
                if (!(element instanceof MethodPackage) || (b = propUtil.getBooleanValue((MethodElement)(pkg = (MethodPackage)element), "pkg_loadCheck")) != null && b.booleanValue()) continue;
                propUtil.setBooleanValue((MethodElement)pkg, "pkg_loadCheck", true);
                this.pkgsMarkedByLoadCheck.add(pkg);
            }
            this.addCommand.execute();
            Resource newResource = this.addCommand.getOwner().eResource();
            modifiedResources.add(newResource);
            Iterator iter = this.addCommand.getAffectedObjects().iterator();
            while (iter.hasNext()) {
                Object plugin;
                EObject element = (EObject)TngUtil.unwrap(iter.next());
                if (!(element instanceof MethodElement)) continue;
                EObject oldContainer = ((ContainmentInfo)this.elementToOldContainerMap.get((Object)element)).container;
                if (oldContainer.eResource() != newResource && !oldContainer.eResource().getContents().isEmpty()) {
                    modifiedResources.add(oldContainer.eResource());
                    Resource oldResource = (Resource)elementToOldResourceMap.get(element);
                    if (oldContainer.eResource() != oldResource) {
                        this.movedResources.add(oldResource);
                    }
                }
                if (this.ownerPlugin == (plugin = this.elementToOldPluginMap.get(element))) continue;
                TreeIterator iterator = element.eAllContents();
                while (iterator.hasNext()) {
                    EObject e = (EObject)iterator.next();
                    if (!UmaUtil.hasDirectResource((EObject)e)) continue;
                    this.movedResources.add(e.eResource());
                    this.elementToOldPluginMap.put(e, plugin);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IStatus save(IProgressMonitor monitor) {
            block28: {
                status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.MethodElementAddCommand_errorSavingFiles, null);
                monitor.subTask(LibraryEditResources.savingModifiedFilesTask_name);
                persister = Services.getDefaultLibraryPersister().getFailSafePersister();
                try {
                    if (!this.movedResources.isEmpty()) {
                        monitor.subTask(LibraryEditResources.movingFilesTask_name);
                        persister.adjustLocation((Collection)this.movedResources);
                    }
                    this.state = 70;
                    iter = this.modifiedResources.iterator();
                }
                catch (RuntimeException e) {
                    msg = new StringWriter();
                    e.printStackTrace(new PrintWriter(msg));
                    newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg.toString(), e);
                    status.add((IStatus)newStatus);
                    if (status.getSeverity() == 4) {
                        try {
                            persister.rollback();
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.INSTANCE.log(e);
                            msg = new StringWriter();
                            e.printStackTrace(new PrintWriter(msg));
                            newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                            status.add((IStatus)newStatus);
                        }
                    }
                    break block28;
                }
                catch (Throwable var11_29) {
                    if (status.getSeverity() != 4) throw var11_29;
                    try {
                        persister.rollback();
                        throw var11_29;
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log(e);
                        msg = new StringWriter();
                        e.printStackTrace(new PrintWriter(msg));
                        newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                        status.add((IStatus)newStatus);
                    }
                    throw var11_29;
                }
                {
                    while (true) {
                        block29: {
                            if (iter.hasNext()) break block29;
                            persister.commit();
                            this.state = 80;
                            if (MethodElementAddCommand.access$2() == null) ** GOTO lbl-1000
                            monitor.subTask(LibraryEditResources.copyingResourcesTask_name);
                            elementsToCopyRefContents = new ArrayList<MethodElement>();
                            iter = this.movedResources.iterator();
                            if (true) ** GOTO lbl72
                        }
                        resource = (Resource)iter.next();
                        try {
                            persister.save(resource);
                        }
                        catch (Exception e) {
                            msg = NLS.bind((String)LibraryEditResources.saveFileError_reason, (Object)(resource.getURI().isFile() != false ? resource.getURI().toFileString() : resource.toString()));
                            status.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, e));
                            if (status.getSeverity() == 4) {
                                try {
                                    persister.rollback();
                                }
                                catch (Exception e) {
                                    LibraryEditPlugin.INSTANCE.log(e);
                                    msg = new StringWriter();
                                    e.printStackTrace(new PrintWriter(msg));
                                    newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                                    status.add((IStatus)newStatus);
                                }
                            }
                            break block28;
                        }
                    }
                    do {
                        resource = (Resource)iter.next();
                        elementsToCopyRefContents.addAll((Collection<MethodElement>)resource.getContents());
lbl72:
                        // 2 sources

                    } while (iter.hasNext());
                    elementsToCopyRefContents.addAll(this.addCommand.getAffectedObjects());
                    modified = MethodElementAddCommand.access$2().copyReferencedContents(elementsToCopyRefContents, this.elementToOldPluginMap);
                    if (modified == null || modified.isEmpty()) ** GOTO lbl-1000
                    for (Resource resource : modified) {
                        pathArgs = new Object[]{resource.getURI().isFile() != false ? resource.getURI().toFileString() : resource.toString()};
                        try {
                            monitor.subTask(MessageFormat.format(LibraryEditResources.savingFileTask_name, pathArgs));
                            persister.save(resource);
                        }
                        catch (Exception e) {
                            msg = MessageFormat.format(LibraryEditResources.saveFileError_reason, pathArgs);
                            status.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, e));
                            if (status.getSeverity() == 4) {
                                try {
                                    persister.rollback();
                                }
                                catch (Exception e) {
                                    LibraryEditPlugin.INSTANCE.log(e);
                                    msg = new StringWriter();
                                    e.printStackTrace(new PrintWriter(msg));
                                    newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                                    status.add((IStatus)newStatus);
                                }
                            }
                            break block28;
                        }
                    }
                }
lbl-1000:
                // 3 sources

                {
                    persister.commit();
                    this.state = 90;
                }
                if (status.getSeverity() == 4) {
                    try {
                        persister.rollback();
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log(e);
                        msg = new StringWriter();
                        e.printStackTrace(new PrintWriter(msg));
                        newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                        status.add((IStatus)newStatus);
                    }
                }
            }
            monitor.subTask(LibraryEditResources.command_done);
            return status;
        }

        static class RefPluginsInfo {
            Set<MethodPlugin> refPluginsToAdd = new HashSet<MethodPlugin>();
            Set<MethodPlugin> refPluginsCircular = new HashSet<MethodPlugin>();
            Set<MethodPlugin> refPluginsToAddBase = new HashSet<MethodPlugin>();

            RefPluginsInfo() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveOperationExt
    extends MoveOperation {
        private List<CustomCategory> movingCCs;
        private List<CustomCategory> movingCCsrcParents;
        private CustomCategory tgtParent;
        private Map<CustomCategory, CustomCategory> movingCCtoParentsMap = new HashMap<CustomCategory, CustomCategory>();
        private boolean samePluginMove = false;
        private MethodPlugin srcPlugin;

        public MoveOperationExt(Command command, IProgressMonitor monitor, Object shell, List<CustomCategory> movingCCs, List<CustomCategory> movingCCsrcParents, CustomCategory tgtParent) {
            super(command, monitor, shell);
            this.movingCCs = movingCCs;
            this.movingCCsrcParents = movingCCsrcParents;
            this.tgtParent = tgtParent;
            int i = 0;
            while (i < movingCCs.size()) {
                this.movingCCtoParentsMap.put(movingCCs.get(i), movingCCsrcParents.get(i));
                ++i;
            }
            this.srcPlugin = UmaUtil.getMethodPlugin((EObject)((EObject)movingCCs.get(0)));
            this.samePluginMove = this.srcPlugin == UmaUtil.getMethodPlugin((EObject)tgtParent);
        }

        @Override
        public void run() {
            if (this.samePluginMove) {
                this.reassign();
                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)this.tgtParent);
                this.modifiedResources = new HashSet();
                this.modifiedResources.add(plugin.eResource());
                LibraryEditUtil.getInstance();
                LibraryEditUtil.save(this.modifiedResources);
                this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
                return;
            }
            super.run();
        }

        @Override
        protected void doMove(IProgressMonitor monitor, Map elementToOldResourceMap, Set modifiedResources) {
            super.doMove(monitor, elementToOldResourceMap, modifiedResources);
            this.reassign();
            LibraryEditUtil.getInstance().fixUpDanglingCustomCategories(this.srcPlugin);
        }

        private void reassign() {
            HashSet<CustomCategory> notToReassignSet = new HashSet<CustomCategory>();
            int i = 0;
            while (i < this.movingCCs.size()) {
                CustomCategory cc = this.movingCCs.get(i);
                boolean toReassign = true;
                if (!this.samePluginMove && this.movingCCs.size() > 1) {
                    HashSet ancestorSet = new HashSet();
                    Stack<List> stack = new Stack<List>();
                    List parents = AssociationHelper.getCustomCategories((DescribableElement)cc);
                    if (parents != null && !parents.isEmpty()) {
                        stack.push(parents);
                    }
                    while (!stack.isEmpty()) {
                        parents = (List)stack.pop();
                        for (CustomCategory p : parents) {
                            List moreParents;
                            if (ancestorSet.contains(p) || (moreParents = AssociationHelper.getCustomCategories((DescribableElement)p)) == null || moreParents.isEmpty()) continue;
                            stack.push(moreParents);
                        }
                        ancestorSet.addAll(parents);
                    }
                    for (CustomCategory cc1 : this.movingCCs) {
                        if (cc1 == cc || !ancestorSet.contains(cc1)) continue;
                        notToReassignSet.add(cc);
                        toReassign = false;
                        break;
                    }
                }
                if (toReassign) {
                    this.movingCCsrcParents.get(i).getCategorizedElements().remove(cc);
                }
                ++i;
            }
            HashSet<CustomCategory> set = new HashSet<CustomCategory>();
            set.addAll(this.tgtParent.getCategorizedElements());
            for (CustomCategory cc : this.movingCCs) {
                if (set.contains(cc) || notToReassignSet.contains(cc)) continue;
                set.add(cc);
                this.tgtParent.getCategorizedElements().add(cc);
            }
        }

        @Override
        protected boolean referencedIllegally(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
            if (e instanceof CustomCategory) {
                CustomCategory referencedCC = (CustomCategory)e;
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                Collection references = AssociationHelper.getReferences((MethodElement)referencedCC);
                for (MethodElement element : references) {
                    MethodPlugin plugin;
                    if (this.movingCCtoParentsMap.containsKey(element) || element instanceof CustomCategory && this.movingCCtoParentsMap.get(referencedCC) == element || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == ownerPlugin || Misc.isBaseOf(ownerPlugin, plugin, map)) continue;
                    return true;
                }
                return false;
            }
            return super.referencedIllegally(ownerPlugin, e, moveList);
        }

        @Override
        public void undo() {
            super.undo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceManager {
        public Collection<Resource> copyReferencedContents(Collection<MethodElement> var1, Map<MethodElement, MethodPlugin> var2);
    }

    protected static class StringValidator
    extends AbstractStringValidator {
        private Collection elements;
        private IValidator validator;
        private EStructuralFeature feature;

        private StringValidator() {
        }

        public StringValidator(Collection elements, EStructuralFeature feature) {
            this.elements = elements;
            this.feature = feature;
        }

        public void setElements(Collection elements) {
            this.elements = elements;
        }

        public void setFeature(EStructuralFeature feature) {
            this.feature = feature;
        }

        public void setValidator(IValidator validator) {
            this.validator = validator;
        }

        public String isValid(String newText) {
            if (this.validator instanceof UniquenessValidator) {
                EObject obj = ((UniquenessValidator)this.validator).getEObject();
                int classID = obj.eClass().getClassifierID();
                newText = newText.trim();
                for (EObject e : this.elements) {
                    String str = (String)e.eGet(this.feature);
                    if (obj == e || classID != e.eClass().getClassifierID() || !newText.equalsIgnoreCase(str)) continue;
                    return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)newText);
                }
            }
            return this.validator.isValid(newText);
        }
    }
}

