/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;

public class MethodElementCreateChildCommand
extends CreateChildCommand {
    private boolean executed = false;
    protected IValidator validator;

    public MethodElementCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object child, int index, Collection selection, CreateChildCommand.Helper helper) {
        super(domain, owner, feature, child, index, selection, helper);
    }

    private void superExecute() {
        super.execute();
    }

    protected IValidator getValidator() {
        if (this.validator == null) {
            this.validator = new AbstractStringValidator(){

                public String isValid(String newText) {
                    if (newText.trim().length() == 0) {
                        String elementText = LibraryEditResources.element_text;
                        return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)elementText);
                    }
                    List children = (List)MethodElementCreateChildCommand.this.owner.eGet(MethodElementCreateChildCommand.this.feature);
                    for (NamedElement child : children) {
                        if (!child.getName().equalsIgnoreCase(newText)) continue;
                        return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)newText);
                    }
                    return null;
                }
            };
        }
        return this.validator;
    }

    public void execute() {
        String name;
        UserInput userInput;
        String title = NLS.bind((String)LibraryEditResources.newElement_text, (Object)this.helper.getCreateChildText((Object)this.owner, (Object)this.feature, this.child, this.selection));
        IValidator validator = this.getValidator();
        IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
        if (uiHandler.requestInput(title, LibraryEditResources.SpecifyNameText, Collections.singletonList(userInput = new UserInput(LibraryEditResources.nameLabel_text, 0, false, null, null, validator, (Object)this))) && (name = (String)userInput.getInput()) != null) {
            ((NamedElement)this.child).setName(name);
            this.superExecute();
            this.executed = true;
        }
    }

    public Collection getAffectedObjects() {
        if (this.executed) {
            return super.getAffectedObjects();
        }
        return Collections.singletonList(this.owner);
    }

    public Collection getResult() {
        if (this.executed) {
            return super.getResult();
        }
        return Collections.EMPTY_LIST;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public Object getChild() {
        return this.child;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }
}

