/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.MethodElementPropertyMgr;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.UmaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementSetPropertyCommand
extends AbstractCommand
implements IResourceAwareCommand {
    protected MethodElement element;
    protected String key;
    protected String value;
    protected String oldValue;
    protected Collection<Resource> modifiedResources;

    public MethodElementSetPropertyCommand(MethodElement element, String key, String value) {
        this.element = element;
        this.key = key;
        this.value = value;
    }

    public MethodElementSetPropertyCommand(MethodElement element, String key) {
        this.element = element;
        this.key = key;
    }

    protected boolean prepare() {
        return UserInteractionHelper.checkModifyOpposite(this.element, (EStructuralFeature)UmaPackage.Literals.METHOD_ELEMENT__METHOD_ELEMENT_PROPERTY, this.element);
    }

    public Collection<Resource> getModifiedResources() {
        if (this.element != null && this.element.eResource() != null && this.modifiedResources == null) {
            this.modifiedResources = new HashSet<Resource>();
            this.modifiedResources.add(this.element.eResource());
        }
        if (this.modifiedResources == null) {
            return Collections.emptyList();
        }
        return this.modifiedResources;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        MethodElementProperty oldProperty = MethodElementPropertyMgr.getInstance().getProperty(this.element, this.key);
        this.oldValue = oldProperty != null ? oldProperty.getValue() : null;
        MethodElementPropertyMgr.getInstance().setProperty(this.element, this.key, this.value);
    }

    public void undo() {
        if (this.oldValue != null) {
            MethodElementPropertyHelper.setProperty(this.element, this.key, this.oldValue);
        } else {
            MethodElementPropertyHelper.removeProperty(this.element, this.key);
        }
    }

    public Collection<?> getAffectedObjects() {
        return Collections.singletonList(this.element);
    }
}

