/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.MethodConfiguration;

public class MoveInConfigurationCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodConfiguration config;
    private EStructuralFeature feature;
    private List elementsList;
    private Collection modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInConfigurationCommand(MethodConfiguration config, List elementsList, EStructuralFeature feature, int direction) {
        this.config = config;
        this.feature = feature;
        this.elementsList = elementsList;
        this.direction = direction;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        if (this.config == null) {
            return;
        }
        for (Object object : this.elementsList) {
            if (this.feature.isMany()) {
                EList list = (EList)this.config.eGet(this.feature);
                int index = list.indexOf(object);
                if (this.direction == UP) {
                    if (index > 0) {
                        list.move(index - 1, object);
                    }
                } else if (this.direction == Down && index < list.size()) {
                    list.move(index + this.elementsList.size(), object);
                }
                this.moved = true;
                continue;
            }
            this.config.eSet(this.feature, null);
        }
        if (this.config.eResource() != null) {
            this.modifiedResources.add(this.config.eResource());
        }
    }

    public void undo() {
        if (this.moved) {
            for (Object object : this.elementsList) {
                if (this.feature.isMany()) {
                    EList list = (EList)this.config.eGet(this.feature);
                    int index = list.indexOf(object);
                    if (this.direction == UP) {
                        if (index < list.size()) {
                            list.move(index + this.elementsList.size(), object);
                        }
                    } else if (this.direction == Down && index > 0) {
                        list.move(index - 1, object);
                    }
                    this.moved = true;
                    continue;
                }
                this.config.eSet(this.feature, object);
            }
            this.moved = false;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.config);
    }
}

