/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class RemoveFromCategoryCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentCategory category;
    private MethodElement element;
    private EStructuralFeature feature;
    private String[] contentPkgPath;
    private ContentCategory usedCategory;
    private int removedElementIndex = -1;
    private boolean removed = false;
    private List usedCategories;

    public RemoveFromCategoryCommand(ContentCategory category, MethodElement element, EStructuralFeature feature, String[] contentPkgPath, List usedCategories) {
        this.category = category;
        this.element = element;
        this.feature = feature;
        this.contentPkgPath = contentPkgPath;
        this.usedCategories = usedCategories;
    }

    public Collection getModifiedResources() {
        if (this.usedCategory != null && this.usedCategory.eResource() != null) {
            return Collections.singletonList(this.usedCategory.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        MethodPlugin elementPlugin;
        MethodPlugin categoryPlugin = UmaUtil.getMethodPlugin((EObject)this.category);
        this.usedCategory = categoryPlugin != (elementPlugin = UmaUtil.getMethodPlugin((EObject)this.element)) && Misc.isBaseOf(categoryPlugin, elementPlugin, new HashMap<String, Boolean>()) ? TngUtil.findContributor(UmaUtil.findContentPackage((MethodPlugin)elementPlugin, (String[])this.contentPkgPath), this.category) : this.category;
        this.redo();
    }

    public void redo() {
        if (this.usedCategory == null) {
            return;
        }
        if (this.feature.isMany()) {
            Collection collection = (Collection)this.usedCategory.eGet(this.feature);
            if (collection instanceof EList) {
                this.removedElementIndex = ((EList)collection).indexOf((Object)this.element);
            }
            this.removed = collection.remove(this.element);
        } else {
            this.usedCategory.eSet(this.feature, null);
            this.removed = true;
        }
        if (this.removed && !this.usedCategories.contains(this.category)) {
            this.usedCategories.add(this.category);
        }
    }

    public void undo() {
        if (this.removed) {
            if (this.feature.isMany()) {
                Collection collection = (Collection)this.usedCategory.eGet(this.feature);
                if (collection instanceof EList && this.removedElementIndex != -1) {
                    ((EList)collection).add(this.removedElementIndex, (Object)this.element);
                } else {
                    collection.add(this.element);
                }
            } else {
                this.usedCategory.eSet(this.feature, (Object)this.element);
            }
            this.removed = false;
        }
        if (this.usedCategories.contains(this.category)) {
            this.usedCategories.remove(this.category);
        }
    }

    public Collection getResult() {
        if (this.removed) {
            return Collections.singletonList(this.element);
        }
        return Collections.EMPTY_LIST;
    }
}

