/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReferencesCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodPlugin plugin;
    private MethodPlugin base;
    private Map<FeatureValuePair, Object> featureValuePairToObjectMap;
    private Collection<Resource> modifiedResources;

    public RemoveReferencesCommand(MethodPlugin plugin, MethodPlugin base) {
        this.plugin = plugin;
        this.base = base;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection<Resource> getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        this.featureValuePairToObjectMap = new HashMap<FeatureValuePair, Object>();
        this.modifiedResources = new HashSet<Resource>();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)this.plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject ref = (EObject)featureIterator.next();
            EStructuralFeature f = featureIterator.feature();
            if (f == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin((EObject)ref) != this.base) continue;
            this.featureValuePairToObjectMap.put(new FeatureValuePair(f, ref), this.plugin);
        }
        TreeIterator iter = this.plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            EContentsEList.FeatureIterator featureIterator2 = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (featureIterator2.hasNext()) {
                EObject ref = (EObject)featureIterator2.next();
                if (UmaUtil.getMethodPlugin((EObject)ref) != this.base) continue;
                EStructuralFeature f = featureIterator2.feature();
                this.featureValuePairToObjectMap.put(new FeatureValuePair(f, ref), element);
                if (f != UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) continue;
                EAttribute feature = UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE;
                this.featureValuePairToObjectMap.put(new FeatureValuePair((EStructuralFeature)feature, element.eGet((EStructuralFeature)feature)), element);
            }
        }
        this.redo();
    }

    public void redo() {
        for (Map.Entry<FeatureValuePair, Object> entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair fvPair = entry.getKey();
            EObject element = (EObject)entry.getValue();
            if (fvPair.feature.isMany()) {
                ((Collection)element.eGet(fvPair.feature)).remove(fvPair.value);
            } else {
                element.eSet(fvPair.feature, null);
            }
            if (element.eResource() == null) continue;
            this.modifiedResources.add(element.eResource());
        }
    }

    public void undo() {
        for (Map.Entry<FeatureValuePair, Object> entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair fvPair = entry.getKey();
            EObject element = (EObject)entry.getValue();
            if (fvPair.feature.isMany()) {
                ((Collection)element.eGet(fvPair.feature)).add(fvPair.value);
                continue;
            }
            element.eSet(fvPair.feature, fvPair.value);
        }
    }

    public void dispose() {
        this.plugin = null;
        this.base = null;
        if (this.featureValuePairToObjectMap != null) {
            this.featureValuePairToObjectMap.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        super.dispose();
    }

    private static class FeatureValuePair {
        EStructuralFeature feature;
        Object value;

        FeatureValuePair(EStructuralFeature f, Object v) {
            this.feature = f;
            this.value = v;
        }
    }
}

