/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.configuration.PracticeSubgroupItemProvider;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PracticeItemProvider
extends org.eclipse.epf.uma.provider.PracticeItemProvider
implements IConfigurable,
ILibraryItemProvider {
    private IFilter filter;
    private Object parent;
    private String label;
    private static String ROADMAP = "roadmap";
    private static String CATEGORIES = "categories";
    private static String KEY_CONCEPTS = "Key Concepts";
    private static String WORKPRODUCTS_GROUP = "Work Products";
    private static String TASKS_GROUP = "Tasks";
    private static String ROLES_GROUP = "Roles";
    private static String ACTIVITIES_GROUP = "Activities";
    private static String GUIDANCES_GROUP = "Guidance";
    private static String UNKNOWN = "unknown";
    private static String GUIDANCES_CHECKLISTS = "Checklists";
    private static String GUIDANCES_Example = "Examples";
    private static String GUIDANCES_PRACTICES = "Practices";
    private static String GUIDANCES_REPORTS = "Reports";
    private static String GUIDANCES_REUSABLEASSETS = "Reusable Assets";
    private static String GUIDANCES_SUPPORTINGMATERIALS = "Supporting Materials";
    private static String GUIDANCES_TEMPLATES = "Templates";
    private static String Guidances_TermDefinitions = "Term Definitions";
    private static String GUIDANCES_TOOLMENTORS = "Tool Mentors";
    private static String GUIDANCES_WORKPRODUCTGUIDELINES = "Guidelines";
    private static String GUIDANCES_ESTIMATIONCONSIDERATIONS = "Estimation Considerations";

    public PracticeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        return Collections.EMPTY_LIST;
    }

    public Collection<?> getModifiedChildren(Object parentObject, Collection children) {
        ArrayList ret = new ArrayList();
        GroupingHelper groupingHelper = new GroupingHelper(this);
        this.grouping(parentObject, ret, children, groupingHelper);
        return ret;
    }

    private void grouping(Object parentObject, List ret, Collection children, GroupingHelper groupingHelper) {
        MethodElement elem;
        Map<String, List> map = PracticeItemProvider.getSubGroupMap(children, groupingHelper);
        boolean toSort = true;
        if (parentObject instanceof MethodElement && (elem = (MethodElement)parentObject) != null) {
            toSort = !CategorySortHelper.isManualCategorySort(elem);
        }
        String[] keys = groupingHelper.getKeysInOrder();
        String[] prefixes = groupingHelper.getPrefixInOrder();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            String prefix = prefixes[i];
            List<?> subgroupChildren = map.get(key);
            if (subgroupChildren != null && !subgroupChildren.isEmpty()) {
                if (groupingHelper.toGroup(key, subgroupChildren)) {
                    if (toSort) {
                        PracticeItemProvider.sort(subgroupChildren);
                    }
                    subgroupChildren = groupingHelper.nestedGrouping(parentObject, key, subgroupChildren);
                    PracticeSubgroupItemProvider sub = new PracticeSubgroupItemProvider(this.getAdapterFactory(), key, prefix, this.getImageObject(key), subgroupChildren, parentObject);
                    ret.add(sub);
                } else {
                    if (toSort) {
                        PracticeItemProvider.sort(subgroupChildren);
                    }
                    ret.addAll(subgroupChildren);
                }
            }
            ++i;
        }
    }

    public static void sort(List subgroupChildren) {
        if (subgroupChildren.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(subgroupChildren, comparator);
        }
    }

    public static Map<String, List> getSubGroupMap(Collection children, GroupingHelper groupingHelper) {
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (Object child : children) {
            String key = groupingHelper.getSubGroupName(child);
            PracticeItemProvider.add(map, key, child);
        }
        return map;
    }

    private Object getImageObject(String subGroupName) {
        String imageStr = PracticeItemProvider.getImageStr(subGroupName);
        return imageStr == null ? null : LibraryEditPlugin.INSTANCE.getImage(imageStr);
    }

    public static String getImageStr(String subGroupName) {
        String imageStr = "full/obj16/Folder";
        if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Key_Concepts"))) {
            imageStr = "full/obj16/Concepts";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_WorkProducts_group"))) {
            imageStr = "full/obj16/WorkProducts";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Tasks_group"))) {
            imageStr = "full/obj16/Tasks";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Roles_group"))) {
            imageStr = "full/obj16/Roles";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Activities_group"))) {
            imageStr = "full/obj16/Processes";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_group"))) {
            imageStr = "full/obj16/GuidanceFolder";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_Checklists"))) {
            imageStr = "full/obj16/Checklists";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_Examples"))) {
            imageStr = "full/obj16/Examples";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_Practices"))) {
            imageStr = "full/obj16/Practices";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_Reports"))) {
            imageStr = "full/obj16/Reports";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_ReusableAssets"))) {
            imageStr = "full/obj16/ReusableAssets";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_SupportingMaterials"))) {
            imageStr = "full/obj16/SupportingMaterials";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_Templates"))) {
            imageStr = "full/obj16/Templates";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_TermDefinitions"))) {
            imageStr = "full/obj16/TermDefinitions";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_ToolMentors"))) {
            imageStr = "full/obj16/ToolMentors";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_WorkProductGuidelines"))) {
            imageStr = "full/obj16/WorkProductGuidelines";
        } else if (subGroupName.equals(PracticeItemProvider.getUIString("_UI_Guidances_EstimationConsiderations"))) {
            imageStr = "full/obj16/EstimationConsiderations";
        }
        return imageStr;
    }

    private static String getUIString(String key) {
        return LibraryEditPlugin.INSTANCE.getString(key);
    }

    private static void add(Map<String, List> map, String key, Object value) {
        ArrayList<Object> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(key, list);
        }
        list.add(value);
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.Literals.PRACTICE__CONTENT_REFERENCES);
            this.childrenFeatures.add(UmaPackage.Literals.PRACTICE__ACTIVITY_REFERENCES);
            this.childrenFeatures.add(UmaPackage.Literals.PRACTICE__SUB_PRACTICES);
        }
        return this.childrenFeatures;
    }

    public Object getParent(Object object) {
        Object parent = TngUtil.getNavigatorParentItemProvider((Guidance)object);
        if (parent == null) {
            return super.getParent(object);
        }
        return parent;
    }

    @Override
    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object, this.getString("_UI_Practice_type"));
    }

    public Object getImage(Object object) {
        URI imgUri;
        Object image;
        if (object instanceof DescribableElement && ((DescribableElement)object).getNodeicon() != null && (image = LibraryEditPlugin.INSTANCE.getSharedImage(imgUri = TngUtil.getFullPathofNodeorShapeIconURI((EObject)((DescribableElement)object), ((DescribableElement)object).getNodeicon()))) != null) {
            return image;
        }
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)object))) {
            ImageDescriptor img = TngUtil.getImageForUdt((Practice)object);
            if (img != null) {
                return img;
            }
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/UdtNode"));
        }
        return super.getImage(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupingHelper {
        private Object grouper;
        private List<String> udtTypeNameList = new ArrayList<String>();
        private Set<String> udtTypeNameSet = new HashSet<String>();

        public GroupingHelper(Object grouper) {
            this.grouper = grouper;
        }

        public GroupingHelper(Object grouper, boolean alwayGroup) {
            this.grouper = grouper;
        }

        protected Object getGrouper() {
            return this.grouper;
        }

        protected String getSubGroupName(Object obj) {
            if (obj instanceof Roadmap) {
                return ROADMAP;
            }
            if (obj instanceof Concept) {
                return PracticeItemProvider.getUIString("_UI_Key_Concepts");
            }
            if (obj instanceof WorkProduct) {
                return PracticeItemProvider.getUIString("_UI_WorkProducts_group");
            }
            if (obj instanceof Task) {
                return PracticeItemProvider.getUIString("_UI_Tasks_group");
            }
            if (obj instanceof Role) {
                return PracticeItemProvider.getUIString("_UI_Roles_group");
            }
            if (obj instanceof Activity) {
                return PracticeItemProvider.getUIString("_UI_Activities_group");
            }
            if (obj instanceof Guidance) {
                UserDefinedTypeMeta meta;
                if (obj instanceof Practice && (meta = PracticePropUtil.getPracticePropUtil().getUdtMeta((Practice)obj)) != null) {
                    String name = (String)meta.getRteNameMap().get("typeName");
                    if (this.udtTypeNameSet.add(name)) {
                        this.udtTypeNameList.add(name);
                    }
                    return name;
                }
                return PracticeItemProvider.getUIString("_UI_Guidances_group");
            }
            if (obj instanceof ContentCategory) {
                return CATEGORIES;
            }
            return UNKNOWN;
        }

        public String[] getPrefixInOrder() {
            String[] prefixes = new String[]{ROADMAP, KEY_CONCEPTS, WORKPRODUCTS_GROUP, TASKS_GROUP, ROLES_GROUP, ACTIVITIES_GROUP, GUIDANCES_GROUP, CATEGORIES, UNKNOWN};
            if (!this.udtTypeNameList.isEmpty()) {
                Collections.sort(this.udtTypeNameList);
                int sz = prefixes.length + this.udtTypeNameList.size();
                String[] modified = new String[sz];
                int i = 0;
                while (i < prefixes.length) {
                    modified[i] = prefixes[i];
                    ++i;
                }
                i = prefixes.length;
                while (i < sz) {
                    modified[i] = this.udtTypeNameList.get(i - prefixes.length);
                    ++i;
                }
                prefixes = modified;
            }
            return prefixes;
        }

        public String[] getKeysInOrder() {
            String[] keys = new String[]{ROADMAP, PracticeItemProvider.getUIString("_UI_Key_Concepts"), PracticeItemProvider.getUIString("_UI_WorkProducts_group"), PracticeItemProvider.getUIString("_UI_Tasks_group"), PracticeItemProvider.getUIString("_UI_Activities_group"), PracticeItemProvider.getUIString("_UI_Roles_group"), PracticeItemProvider.getUIString("_UI_Guidances_group"), CATEGORIES, UNKNOWN};
            if (!this.udtTypeNameList.isEmpty()) {
                Collections.sort(this.udtTypeNameList);
                int sz = keys.length + this.udtTypeNameList.size();
                String[] modifiedKesy = new String[sz];
                int i = 0;
                while (i < keys.length) {
                    modifiedKesy[i] = keys[i];
                    ++i;
                }
                i = keys.length;
                while (i < sz) {
                    modifiedKesy[i] = this.udtTypeNameList.get(i - keys.length);
                    ++i;
                }
                keys = modifiedKesy;
            }
            return keys;
        }

        public boolean toGroup(String key, List subgroupChildren) {
            if (this.udtTypeNameSet.contains(key)) {
                return true;
            }
            return !key.equals(ROADMAP) && !key.equals(CATEGORIES) && !key.equals(UNKNOWN) && subgroupChildren.size() >= 3;
        }

        public List<?> nestedGrouping(Object parentObject, String key, List<?> subgroupChildren) {
            if (!key.equals(PracticeItemProvider.getUIString("_UI_Guidances_group"))) {
                return subgroupChildren;
            }
            ArrayList ret = new ArrayList();
            GuidanceGroupingHelper groupingHelper = new GuidanceGroupingHelper(this.grouper);
            this.grouping(parentObject, ret, subgroupChildren, groupingHelper);
            return ret;
        }

        protected void grouping(Object parentObject, List ret, Collection children, GroupingHelper groupingHelper) {
            if (this.grouper instanceof PracticeItemProvider) {
                ((PracticeItemProvider)this.grouper).grouping(parentObject, ret, children, groupingHelper);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GuidanceGroupingHelper
    extends GroupingHelper {
        public GuidanceGroupingHelper(Object grouper) {
            super(grouper);
        }

        @Override
        protected String getSubGroupName(Object obj) {
            if (obj instanceof Checklist) {
                return PracticeItemProvider.getUIString("_UI_Guidances_Checklists");
            }
            if (obj instanceof Example) {
                return PracticeItemProvider.getUIString("_UI_Guidances_Examples");
            }
            if (obj instanceof Practice) {
                return PracticeItemProvider.getUIString("_UI_Guidances_Practices");
            }
            if (obj instanceof Report) {
                return PracticeItemProvider.getUIString("_UI_Guidances_Reports");
            }
            if (obj instanceof ReusableAsset) {
                return PracticeItemProvider.getUIString("_UI_Guidances_ReusableAssets");
            }
            if (obj instanceof SupportingMaterial) {
                return PracticeItemProvider.getUIString("_UI_Guidances_SupportingMaterials");
            }
            if (obj instanceof Template) {
                return PracticeItemProvider.getUIString("_UI_Guidances_Templates");
            }
            if (obj instanceof TermDefinition) {
                return PracticeItemProvider.getUIString("_UI_Guidances_TermDefinitions");
            }
            if (obj instanceof ToolMentor) {
                return PracticeItemProvider.getUIString("_UI_Guidances_ToolMentors");
            }
            if (obj instanceof Guideline) {
                return PracticeItemProvider.getUIString("_UI_Guidances_WorkProductGuidelines");
            }
            if (obj instanceof EstimationConsiderations) {
                return PracticeItemProvider.getUIString("_UI_Guidances_EstimationConsiderations");
            }
            return UNKNOWN;
        }

        @Override
        public String[] getPrefixInOrder() {
            String[] prefixes = new String[]{GUIDANCES_CHECKLISTS, GUIDANCES_Example, GUIDANCES_PRACTICES, GUIDANCES_REPORTS, GUIDANCES_REUSABLEASSETS, GUIDANCES_SUPPORTINGMATERIALS, GUIDANCES_TEMPLATES, Guidances_TermDefinitions, GUIDANCES_TOOLMENTORS, GUIDANCES_WORKPRODUCTGUIDELINES, GUIDANCES_ESTIMATIONCONSIDERATIONS, UNKNOWN};
            return prefixes;
        }

        @Override
        public String[] getKeysInOrder() {
            String[] keys = new String[]{PracticeItemProvider.getUIString("_UI_Guidances_Checklists"), PracticeItemProvider.getUIString("_UI_Guidances_Examples"), PracticeItemProvider.getUIString("_UI_Guidances_Practices"), PracticeItemProvider.getUIString("_UI_Guidances_Reports"), PracticeItemProvider.getUIString("_UI_Guidances_ReusableAssets"), PracticeItemProvider.getUIString("_UI_Guidances_SupportingMaterials"), PracticeItemProvider.getUIString("_UI_Guidances_Templates"), PracticeItemProvider.getUIString("_UI_Guidances_TermDefinitions"), PracticeItemProvider.getUIString("_UI_Guidances_ToolMentors"), PracticeItemProvider.getUIString("_UI_Guidances_WorkProductGuidelines"), PracticeItemProvider.getUIString("_UI_Guidances_EstimationConsiderations"), UNKNOWN};
            return keys;
        }

        @Override
        public boolean toGroup(String key, List subgroupChildren) {
            return !key.equals(UNKNOWN) && subgroupChildren.size() >= 3;
        }

        @Override
        public List<?> nestedGrouping(Object parentObject, String key, List<?> subgroupChildren) {
            return subgroupChildren;
        }
    }
}

