/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;

public class ProcessPackageItemProvider
extends org.eclipse.epf.library.edit.navigator.ProcessPackageItemProvider
implements IConfigurable {
    private IFilter filter;

    public ProcessPackageItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected boolean acceptAsChild(Process process) {
        return !TngUtil.isContributorOrReplacer((VariabilityElement)process) && process.getSuppressed() == false;
    }

    public static boolean collectChildren(Collection children, Object element, IFilter filter) {
        if (element instanceof ProcessComponent) {
            Process process = ((ProcessComponent)element).getProcess();
            if (process != null) {
                if (filter instanceof IConfigurator) {
                    Object child = ((IConfigurator)filter).resolve(process);
                    if (!children.contains(child) && filter.accept(child)) {
                        children.add(child);
                        return true;
                    }
                } else if (filter == null || filter.accept(process)) {
                    children.add(process);
                    return true;
                }
            }
        } else if (element instanceof ProcessPackage && (filter == null || filter.accept(element))) {
            children.add(element);
            return true;
        }
        return false;
    }

    private boolean collectChildren(Collection children, Object element) {
        return ProcessPackageItemProvider.collectChildren(children, element, this.filter);
    }

    public Collection getChildren(Object object) {
        ArrayList children = new ArrayList();
        Iterator iter = super.getChildren(object).iterator();
        while (iter.hasNext()) {
            this.collectChildren(children, iter.next());
        }
        for (Object child : children) {
            ProcessUtil.setParent(child, object, this.adapterFactory);
        }
        return children;
    }

    public boolean hasChildren(Object object) {
        ArrayList children = new ArrayList();
        Iterator iter = super.getChildren(object).iterator();
        while (iter.hasNext()) {
            if (!this.collectChildren(children, iter.next())) continue;
            return true;
        }
        return false;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
        if (filter instanceof IConfigurator) {
            ((IConfigurator)filter).getMethodConfiguration();
        }
    }
}

