/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.element;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.UmaUtil;

public class ArtifactItemProvider
extends org.eclipse.epf.uma.provider.ArtifactItemProvider
implements IDefaultNameSetter,
ILibraryItemProvider,
IConfigurable {
    private IFilter filter;

    public ArtifactItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getParent(Object object) {
        Artifact artifact = (Artifact)object;
        if (artifact != null && artifact.eContainer() instanceof Artifact) {
            return super.getParent(object);
        }
        return TngUtil.getNavigatorParentItemProvider((WorkProduct)artifact);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), UmaFactory.eINSTANCE.createArtifact()));
    }

    public void notifyChanged(Notification notification) {
        this.setDefaultName(notification);
        this.updateChildren(notification);
        TngUtil.refreshParentIfNameChanged(notification, (ItemProviderAdapter)this);
        switch (notification.getFeatureID(Discipline.class)) {
            case 0: {
                TngUtil.refreshContributors((IChangeNotifier)this, notification, false, true);
                break;
            }
            case 22: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                TngUtil.refreshWorkProductTypeUncategorized(UmaUtil.getMethodPlugin((EObject)((EObject)this.target)), notification);
                return;
            }
            case 28: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        }
        return this.childrenFeatures;
    }

    public void setDefaultName(Notification msg) {
        int featureId;
        ArtifactItemProvider defaultNameSetter = this;
        if (defaultNameSetter.getInterestedFeatureOwnerClass() != null && (featureId = msg.getFeatureID(defaultNameSetter.getInterestedFeatureOwnerClass())) == defaultNameSetter.getInterestedFeatureID()) {
            switch (msg.getEventType()) {
                case 3: {
                    this.setDefaultName(msg.getNewValue(), msg.getNotifier());
                    break;
                }
                case 5: {
                    Iterator iter = ((Collection)msg.getNewValue()).iterator();
                    while (iter.hasNext()) {
                        this.setDefaultName(iter.next(), msg.getNotifier());
                    }
                    break;
                }
            }
        }
    }

    private void setDefaultName(Object obj, Object parent) {
        String baseName = null;
        if (obj instanceof Artifact) {
            baseName = "new_artifact";
        }
        if (baseName != null) {
            TngUtil.setDefaultName(((Artifact)parent).getContainedArtifacts(), (MethodElement)obj, baseName);
        }
    }

    public void setDefaultName(Object obj) {
        String baseName = null;
        if (obj instanceof Artifact) {
            baseName = "new_artifact";
        }
        if (baseName != null) {
            TngUtil.setDefaultName(((Artifact)this.target).getContainedArtifacts(), (MethodElement)obj, baseName);
        }
    }

    public int getInterestedFeatureID() {
        return 28;
    }

    public Class getInterestedFeatureOwnerClass() {
        return Artifact.class;
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object, this.getString("_UI_Artifact_type"));
    }

    public Object getImage(Object object) {
        Object image;
        URI imgUri;
        if (object instanceof DescribableElement && ((DescribableElement)object).getNodeicon() != null && (imgUri = TngUtil.getFullPathofNodeorShapeIconURI((EObject)((DescribableElement)object), ((DescribableElement)object).getNodeicon())) != null && (image = LibraryEditPlugin.INSTANCE.getSharedImage(imgUri)) != null) {
            return image;
        }
        return super.getImage(object);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection, int index) {
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(domain, owner, feature, collection, index)));
    }

    public void setParent(Object parent) {
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void setLabel(String label) {
    }

    public Collection getChildren(Object object) {
        Collection col = super.getChildren(object);
        if (this.filter != null) {
            Iterator itor = col.iterator();
            while (itor.hasNext()) {
                Object child = itor.next();
                if (this.filter.accept(child)) continue;
                itor.remove();
            }
        }
        return col;
    }
}

