/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.itemsfilter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;

public class CategorizedProcessesItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IConfigurable {
    private String label;
    private IFilter filter;
    private Object image;
    private MethodPackage pkg;

    public CategorizedProcessesItemProvider(AdapterFactory adapterFactory, MethodPackage pkg, String name, Object image) {
        super(adapterFactory);
        this.label = name;
        this.image = image;
        this.pkg = pkg;
    }

    public Collection getChildren(Object object) {
        ArrayList children = new ArrayList();
        Iterator iterator = this.pkg.getChildPackages().iterator();
        while (iterator.hasNext()) {
            Object element;
            Object child = element = iterator.next();
            if (element instanceof ProcessComponent) {
                child = ((ProcessComponent)element).getProcess();
            }
            if (!this.filter.accept(child) || this.isEmptyPackage(child)) continue;
            children.add(child);
        }
        return children;
    }

    private Collection childPackages(Object object) {
        List children = ((ProcessPackage)object).getChildPackages();
        ArrayList newList = new ArrayList();
        newList.addAll(children);
        if (this.filter != null) {
            Iterator iter = newList.iterator();
            while (iter.hasNext()) {
                if (this.filter.accept(iter.next())) continue;
                iter.remove();
            }
        }
        return newList;
    }

    private boolean isEmptyPackage(Object object) {
        if (object instanceof ProcessComponent || object instanceof Process) {
            return false;
        }
        Collection children = this.childPackages(object);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            if (this.isEmptyPackage(iter.next())) continue;
            return false;
        }
        return true;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return super.getNewChildDescriptors((Object)this.target, editingDomain, sibling);
    }

    public Object getImage(Object object) {
        return this.image;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return super.getText(object);
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParent(Object parent) {
    }
}

