/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.itemsfilter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.VariabilityElement;

public class FilterUtil {
    public static void iterateCollection(Collection children, IFilter filter) {
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (filter.accept(child)) continue;
            iterator.remove();
        }
    }

    public static void getParentsInScope(AdapterFactory adapterFactory, BreakdownElement element, List activityList) {
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)element);
        if (parent instanceof Activity) {
            activityList.add(parent);
            FilterUtil.getParentsInScope(adapterFactory, (BreakdownElement)parent, activityList);
        }
    }

    public static void getChildActivitiesInScope(AdapterFactory adapterFactory, Activity parent, List activityList) {
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)parent, ITreeItemContentProvider.class);
        Collection o = adapter.getChildren((Object)parent);
        if (o instanceof List) {
            List children = (List)o;
            for (Object obj : children) {
                if (obj instanceof Activity) {
                    activityList.add(obj);
                    FilterUtil.getChildActivitiesInScope(adapterFactory, (Activity)obj, activityList);
                }
                if (!(obj instanceof ActivityWrapperItemProvider)) continue;
                Object o1 = ((WrapperItemProvider)obj).getValue();
                activityList.add(o1);
                FilterUtil.getChildActivitiesInScope(adapterFactory, (Activity)o1, activityList);
            }
        }
    }

    public static void getContributors(List list, List generalizers) {
        for (Object e : list) {
            if (!(e instanceof VariabilityElement)) continue;
            Iterator iter = TngUtil.getContributors((VariabilityElement)e);
            while (iter.hasNext()) {
                generalizers.add(iter.next());
            }
        }
    }

    public static void getGeneralizers(List list, List generalizers) {
        for (Object e : list) {
            if (!(e instanceof VariabilityElement)) continue;
            Iterator iter = TngUtil.getGeneralizers((VariabilityElement)e);
            while (iter.hasNext()) {
                generalizers.add(iter.next());
            }
        }
    }

    public static void getVariabilityBase(List list, List variabilitybases) {
        for (Object obj : list) {
            if (!(obj instanceof VariabilityElement)) continue;
            VariabilityElement e = (VariabilityElement)obj;
            while (e.getVariabilityBasedOnElement() != null) {
                e = e.getVariabilityBasedOnElement();
                variabilitybases.add(e);
            }
        }
    }

    public static Object getParentActivity(AdapterFactory adapterFactory, BreakdownElement brElement) {
        if (brElement != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
            Object parent = adapter.getParent((Object)brElement);
            while (!(parent instanceof Activity) && parent != null) {
                brElement = (BreakdownElement)parent;
                adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
                parent = adapter.getParent((Object)brElement);
            }
            return parent;
        }
        return null;
    }

    public static void getSubTree(AdapterFactory adapter, Activity activity, List treeList) {
        FilterUtil.getParentsInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)activity, treeList);
        FilterUtil.getChildActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), activity, treeList);
    }

    public static void getSubTree(AdapterFactory adapter, List list, List treeList) {
        for (Object obj : list) {
            if (!(obj instanceof Activity)) continue;
            FilterUtil.getSubTree(adapter, (Activity)obj, treeList);
        }
    }
}

