/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.meta.IMetaDef;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefParser;
import org.eclipse.epf.library.edit.meta.internal.ExtendedReferenceImpl;
import org.eclipse.epf.library.edit.meta.internal.ExtendedSectionImpl;
import org.eclipse.epf.library.edit.meta.internal.ModifiedTypeMetaImpl;
import org.eclipse.epf.library.edit.meta.internal.TypeDefParserImpl;
import org.eclipse.epf.library.edit.uma.DescriptorExt;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.uma.MethodPluginExt;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedOpposite;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefUtil {
    private static TypeDefUtil instance;
    private static String indent0;

    static {
        Object obj = ExtensionHelper.create(TypeDefUtil.class, null);
        instance = obj instanceof TypeDefUtil ? (TypeDefUtil)obj : new TypeDefUtil();
        indent0 = "     ";
    }

    public static TypeDefUtil getInstance() {
        return instance;
    }

    protected TypeDefUtil() {
    }

    public TypeDefParser getTypeDefParser() {
        return new TypeDefParserImpl();
    }

    public IMetaDef createMetaDef(Class cls) {
        if (cls == ModifiedTypeMeta.class) {
            return (ModifiedTypeMetaImpl)this.newModifiedTypeMeta();
        }
        return null;
    }

    public void associate(ExtendedReference eRef, EReference ref) {
        this.associate_((MetaElement)eRef, (EStructuralFeature)ref);
    }

    public void associate(ExtendedAttribute eAtt, EAttribute att) {
        this.associate_((MetaElement)eAtt, (EStructuralFeature)att);
    }

    private void associate_(MetaElement metaElement, EStructuralFeature feature) {
        if (!(metaElement instanceof Adapter)) {
            return;
        }
        int sz = feature.eAdapters().size();
        int i = sz - 1;
        while (i >= 0) {
            Object adapter = feature.eAdapters().get(i);
            if (adapter instanceof MetaElement) {
                feature.eAdapters().remove(i);
            }
            --i;
        }
        feature.eAdapters().add((Object)((Adapter)metaElement));
    }

    public ExtendedReference getAssociatedExtendedReference(EStructuralFeature feature) {
        MetaElement element = this.getAssociatedMetaElement(feature);
        if (element instanceof ExtendedReference) {
            return (ExtendedReference)element;
        }
        return null;
    }

    public ExtendedAttribute getAssociatedExtendedAttribute(EStructuralFeature feature) {
        MetaElement element = this.getAssociatedMetaElement(feature);
        if (element instanceof ExtendedAttribute) {
            return (ExtendedAttribute)element;
        }
        return null;
    }

    private MetaElement getAssociatedMetaElement(EStructuralFeature feature) {
        if (feature == null) {
            return null;
        }
        for (Object adapter : feature.eAdapters()) {
            if (!(adapter instanceof MetaElement)) continue;
            return (MetaElement)adapter;
        }
        return null;
    }

    public Object eGet(EObject obj, EStructuralFeature feature) {
        return this.eGet(obj, feature, false);
    }

    public Object eGet(EObject obj, EStructuralFeature feature, boolean toModify) {
        try {
            return this.eGet_(obj, feature, toModify);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
            if (DebugUtil.udtDebug || DebugUtil.uiDebug) {
                e.printStackTrace();
            }
            boolean isMany = false;
            if (feature instanceof EReference) {
                isMany = ((EReference)feature).isMany();
            }
            return isMany ? new ArrayList() : null;
        }
    }

    private Object eGet_(EObject obj, EStructuralFeature feature, boolean toModify) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof MethodElement) {
            EAttribute att;
            ExtendedAttribute eAtt;
            PropUtil propUtil = PropUtil.getPropUtil();
            MethodElement element = (MethodElement)obj;
            if (feature instanceof EReference) {
                Practice practice;
                PracticePropUtil practicePropUtil;
                UserDefinedTypeMeta meta;
                EReference ref = (EReference)feature;
                if (element instanceof Practice && (meta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta(practice = (Practice)element)) != null && meta.isQualifiedRefernce((EReference)feature)) {
                    List<MethodElement> list = practicePropUtil.getQReferenceListById(element, feature.getName(), false);
                    return list;
                }
                if (ref == UmaUtil.MethodElement_UdtList) {
                    return propUtil.getUdtList(element, toModify);
                }
                ExtendedReference eRef = this.getAssociatedExtendedReference((EStructuralFeature)ref);
                if (eRef != null) {
                    return propUtil.getExtendedReferenceList(element, eRef, toModify);
                }
            } else if (feature instanceof EAttribute && element instanceof ContentDescription && (eAtt = this.getAssociatedExtendedAttribute((EStructuralFeature)(att = (EAttribute)feature))) != null) {
                return propUtil.getExtendedAttribute((ContentDescription)element, eAtt);
            }
        }
        return obj.eGet(feature);
    }

    public void eSet(EObject obj, EStructuralFeature feature, Object newValue) {
        block2: {
            try {
                this.eSet_(obj, feature, newValue);
            }
            catch (Throwable e) {
                LibraryEditPlugin.getDefault().getLogger().logError(e);
                if (!DebugUtil.udtDebug && !DebugUtil.uiDebug) break block2;
                e.printStackTrace();
            }
        }
    }

    private void eSet_(EObject obj, EStructuralFeature feature, Object newValue) {
        ExtendedAttribute eAtt;
        if (obj instanceof ContentDescription && (eAtt = this.getAssociatedExtendedAttribute(feature)) != null && (newValue == null || newValue instanceof String)) {
            PropUtil.getPropUtil().setExtendedAttribute((ContentDescription)obj, eAtt, (String)newValue);
            return;
        }
        obj.eSet(feature, newValue);
    }

    public void eBasicSet(EObject obj, EStructuralFeature feature, Object newValue) {
        boolean oldB = obj.eDeliver();
        try {
            if (oldB) {
                obj.eSetDeliver(false);
            }
            this.eSet(obj, feature, newValue);
        }
        finally {
            if (oldB) {
                obj.eSetDeliver(true);
            }
        }
    }

    public List<EReference> getEAllReferences(MethodElement element) {
        Practice practice;
        PracticePropUtil practicePropUtil;
        UserDefinedTypeMeta meta;
        ArrayList<EReference> list = new ArrayList<EReference>((Collection<EReference>)element.eClass().getEAllReferences());
        if (element instanceof Practice && (meta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta(practice = (Practice)element)) != null && !meta.getQualifiedReferences().isEmpty()) {
            list.addAll(meta.getQualifiedReferences());
        }
        PropUtil propUtil = PropUtil.getPropUtil();
        list.add(UmaUtil.MethodElement_UdtList);
        ModifiedTypeMeta meta2 = propUtil.getGlobalMdtMeta(element);
        if (meta2 != null) {
            list = new ArrayList<EReference>(list);
            for (ExtendedReference eRef : meta2.getReferences()) {
                list.add(eRef.getReference());
                for (QualifiedReference qRef : eRef.getQualifiedReferences()) {
                    list.add(qRef.getReference());
                }
            }
        }
        return list;
    }

    public List<EAttribute> getEAllAttributes(MethodElement element) {
        ArrayList<EAttribute> list = new ArrayList<EAttribute>((Collection<EAttribute>)element.eClass().getEAllAttributes());
        if (!(element instanceof ContentDescription)) {
            return list;
        }
        EObject owner = element.eContainer();
        if (!(owner instanceof MethodElement)) {
            return list;
        }
        PropUtil propUtil = PropUtil.getPropUtil();
        ModifiedTypeMeta meta = propUtil.getGlobalMdtMeta((MethodElement)owner);
        if (meta == null) {
            return list;
        }
        for (ExtendedAttribute eAtt : meta.getRtes()) {
            list.add(eAtt.getAttribute());
        }
        for (ExtendedAttribute eAtt : meta.getAttributes()) {
            list.add(eAtt.getAttribute());
        }
        return list;
    }

    public MethodElementExt createExtendObject(MethodElement element) {
        PropUtil propUtil = PropUtil.getPropUtil();
        if (propUtil.isWorkProductState(element)) {
            return new MethodElementExt.WorkProductStateExt((Constraint)element);
        }
        if (element instanceof Descriptor) {
            return new DescriptorExt((Descriptor)element);
        }
        if (element instanceof MethodPlugin) {
            return new MethodPluginExt((MethodPlugin)element);
        }
        if (element instanceof MethodConfiguration) {
            return new MethodElementExt.MethodConfigurationExt((MethodConfiguration)element);
        }
        return new MethodElementExt(element);
    }

    public static Class getSuperClass(Class cls) {
        Class<ContentElement> cls1 = ContentElement.class;
        Class<BreakdownElement> cls2 = BreakdownElement.class;
        Class<?>[] ins = cls.getInterfaces();
        if (ins == null || ins.length == 0) {
            return null;
        }
        Class<?>[] classArray = ins;
        int n = ins.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> in = classArray[n2];
            if (cls1.isAssignableFrom(in) || cls2.isAssignableFrom(in)) {
                return in;
            }
            ++n2;
        }
        return null;
    }

    public static ModifiedTypeMeta getMdtMeta(EClass cls) {
        try {
            MethodElement element = (MethodElement)UmaFactory.eINSTANCE.create(cls);
            return TypeDefUtil.getMdtMeta(element);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ModifiedTypeMeta getMdtMeta(MethodElement element) {
        return PropUtil.getPropUtil().getGlobalMdtMeta(element);
    }

    public static ModifiedTypeMeta getLinkedMdtMeta(MethodElement element) {
        ModifiedTypeMeta meta = TypeDefUtil.getMdtMeta(element);
        if (meta == null) {
            return null;
        }
        Collection<ModifiedTypeMeta> allTypes = LibraryEditUtil.getInstance().getModifiedTypes();
        if (allTypes == null) {
            return null;
        }
        for (ModifiedTypeMeta oMeta : allTypes) {
            if (oMeta.getLinkTypes().isEmpty() || !meta.getId().equals(oMeta.getLinkTypes().get(0))) continue;
            return oMeta;
        }
        return null;
    }

    public static boolean hasLinkTypes(MethodElement element) {
        ModifiedTypeMeta meta = TypeDefUtil.getMdtMeta(element);
        if (meta == null) {
            return false;
        }
        return meta.getLinkTypes() != null && !meta.getLinkTypes().isEmpty();
    }

    public static String getTypeId(MethodElement element) {
        UserDefinedTypeMeta meta;
        if (element instanceof Practice && (meta = PracticePropUtil.getPracticePropUtil().getUdtMeta((Practice)element)) != null) {
            return (String)meta.getRteNameMap().get("typeId");
        }
        return element.eClass().getInstanceClass().getName();
    }

    public static boolean isTypeOf(MethodElement element, String typeId) {
        String elementTypeId = TypeDefUtil.getTypeId(element);
        if (elementTypeId.equals(typeId)) {
            return true;
        }
        for (EClass cls : element.eClass().getEAllSuperTypes()) {
            Class c = cls.getInstanceClass();
            if (!c.getName().equals(typeId)) continue;
            return true;
        }
        return false;
    }

    public void validateId(String context, String id) throws TypeDefException {
        String errorMsg = this.checkIdValue(context, id);
        if (errorMsg != null) {
            throw new TypeDefException(errorMsg);
        }
    }

    public String checkIdValue(String context, String id) {
        if (id == null || id.trim().length() == 0) {
            return "Invalid id string for " + context + ": id cannot be null or empty!";
        }
        char c = id.charAt(0);
        if (!(c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return "Invalid id string for " + context + ": " + id + "\nid must start with an letter or underscore";
        }
        char lastC = c;
        int i = 1;
        while (i < id.length()) {
            boolean valid;
            c = id.charAt(i);
            boolean bl = valid = c == '_' || c == '-' || c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
            if (c == '.' && lastC == c) {
                valid = false;
            }
            if (!valid) {
                return "Invalid id string for " + context + ": " + id + "\nid can only contain letters, digits, underscores, hyphens, and single periods";
            }
            lastC = c;
            ++i;
        }
        return null;
    }

    public ModifiedTypeMeta newModifiedTypeMeta() {
        return new ModifiedTypeMetaImpl();
    }

    public ExtendedReference newExtendedReference(MetaElement parent) {
        return new ExtendedReferenceImpl(parent);
    }

    public ExtendedSection newExtendedSection(MetaElement parent) {
        return new ExtendedSectionImpl(parent);
    }

    public static String getMTypesDebugString(Collection<ModifiedTypeMeta> mtypes, String label) {
        ArrayList<ModifiedTypeMeta> list = new ArrayList<ModifiedTypeMeta>();
        if (mtypes != null) {
            list.addAll(mtypes);
        }
        Collections.sort(list);
        StringBuffer sb = new StringBuffer();
        if (label == null) {
            label = "";
        }
        sb.append(String.valueOf(label) + "\n");
        sb.append("size: " + list.size() + "\n");
        if (list.isEmpty()) {
            return sb.toString();
        }
        int i = 0;
        while (i < list.size()) {
            ModifiedTypeMeta meta = (ModifiedTypeMeta)list.get(i);
            sb.append(meta.getDebugString(i, indent0));
            ++i;
        }
        return sb.toString();
    }

    public ExtendedOpposite getAssociatedExtendedOpposite(OppositeFeature oFeature) {
        if (oFeature == null) {
            return null;
        }
        ExtendedReference extendedReference = this.getAssociatedExtendedReference(oFeature.getTargetFeature());
        return extendedReference == null ? null : extendedReference.getOpposite();
    }

    public MethodElement getLinkedElement(MethodElement element) {
        if (element instanceof Descriptor) {
            return ProcessUtil.getAssociatedElement((Descriptor)element);
        }
        return PropUtil.getPropUtil().getLinkedElement(element);
    }
}

