/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.MetaElementImpl;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedAttributeImpl
extends MetaElementImpl
implements ExtendedAttribute {
    private EAttribute att;
    private String valueType;
    private List<MetaElement> choiceValues;

    public ExtendedAttributeImpl(MetaElement parent) {
        super(parent);
    }

    public EAttribute getAttribute() {
        return this.att;
    }

    public String getValueType() {
        return this.valueType;
    }

    @Override
    public void parseElement(Element element) throws TypeDefException {
        super.parseElement(element);
        this.att = UmaUtil.createAttribute((String)this.getId());
        TypeDefUtil.getInstance().associate(this, this.att);
        this.valueType = element.getAttribute("valueType");
        if (this.valueType == null || this.valueType.length() == 0) {
            this.valueType = "richText";
        }
        if ("choice".equalsIgnoreCase(this.valueType)) {
            this.choiceValues = new ArrayList<MetaElement>();
            List valueElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"value");
            if (valueElements == null || valueElements.isEmpty()) {
                return;
            }
            for (Element valueElement : valueElements) {
                MetaElementImpl value = new MetaElementImpl(this);
                value.parseElement(valueElement);
                this.choiceValues.add(value);
            }
        }
    }

    public List<MetaElement> getChoiceValues() {
        return this.choiceValues;
    }
}

