/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.ExtendedOppositeImpl;
import org.eclipse.epf.library.edit.meta.internal.MetaElementImpl;
import org.eclipse.epf.library.edit.meta.internal.QualifiedReferenceImpl;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ExtendedOpposite;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.eclipse.epf.uma.util.UmaUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedReferenceImpl
extends MetaElementImpl
implements ExtendedReference {
    private EReference ref;
    private List<QualifiedReference> qualifiedReferences;
    private List<String> valueTypes;
    private String contributeTo;
    private boolean createUDTChild;
    private boolean generateTreebrowserFolder;
    private ExtendedOppositeImpl opposite;

    public ExtendedReferenceImpl(MetaElement parent) {
        super(parent);
    }

    public EReference getReference() {
        return this.ref;
    }

    protected void setReference(EReference ref) {
        this.ref = ref;
    }

    public List<QualifiedReference> getQualifiedReferences() {
        return this.qualifiedReferences;
    }

    @Override
    public void parseElement(Element element) throws TypeDefException {
        super.parseElement(element);
        if (element == null) {
            return;
        }
        this.ref = UmaUtil.createReference((String)this.getId());
        TypeDefUtil.getInstance().associate(this, this.ref);
        this.valueTypes = XMLUtil.getChildTextsByTagName((Element)element, (String)"valueType");
        this.contributeTo = element.getAttribute("contributeTo");
        if (this.contributeTo != null) {
            this.contributeTo = this.contributeTo.toLowerCase();
        }
        if ("roles".equals(this.contributeTo)) {
            this.valueTypes = Collections.singletonList(UmaPackage.eINSTANCE.getRole().getInstanceClass().getName());
        } else if ("workproducts".equals(this.contributeTo)) {
            this.valueTypes = Collections.singletonList(UmaPackage.eINSTANCE.getWorkProduct().getInstanceClass().getName());
        } else {
            this.contributeTo = null;
        }
        Element childElement = XMLUtil.getFirstChild((Element)element, (String)"oppositeReference");
        if (childElement != null) {
            this.opposite = new ExtendedOppositeImpl(this);
            this.opposite.parseElement(childElement);
        }
        this.createUDTChild = new Boolean(element.getAttribute("treeBrowser"));
        this.generateTreebrowserFolder = new Boolean(element.getAttribute("generateTreebrowserFolder"));
        this.qualifiedReferences = new ArrayList<QualifiedReference>();
        List rqElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"reference_qualifiers");
        if (rqElements == null || rqElements.isEmpty()) {
            return;
        }
        for (Element rqElement : rqElements) {
            List qElements = XMLUtil.getChildElementsByTagName((Element)rqElement, (String)"qualifier");
            for (Element qElement : qElements) {
                QualifiedReferenceImpl q = new QualifiedReferenceImpl(this);
                q.parseElement(qElement);
                this.qualifiedReferences.add(q);
            }
        }
    }

    public boolean isCreateUDTChild() {
        return this.createUDTChild;
    }

    public boolean isGenerateTreebrowserFolder() {
        return this.generateTreebrowserFolder;
    }

    public List<String> getValueTypes() {
        return this.valueTypes;
    }

    public String getContributeTo() {
        return this.contributeTo;
    }

    @Override
    public boolean processInheritance() {
        if (!super.processInheritance()) {
            return false;
        }
        if (this.getSuperMeta() == null) {
            this.qualifiedReferences = ExtendedReferenceImpl.processSuppress(this.getQualifiedReferences());
            return true;
        }
        if (this.getSuperMeta() instanceof ExtendedReferenceImpl) {
            ExtendedReferenceImpl sMeta = (ExtendedReferenceImpl)this.getSuperMeta();
            sMeta.processInheritance();
            this.qualifiedReferences = ExtendedReferenceImpl.processInherentList(this.getQualifiedReferences(), sMeta.getQualifiedReferences());
            for (QualifiedReference qref : this.getQualifiedReferences()) {
                qref.processInheritance();
            }
            return true;
        }
        return true;
    }

    public ExtendedOpposite getOpposite() {
        return this.opposite;
    }
}

