/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.ExtendedAttributeImpl;
import org.eclipse.epf.library.edit.meta.internal.ExtendedReferenceImpl;
import org.eclipse.epf.library.edit.meta.internal.ExtendedTableImpl;
import org.eclipse.epf.library.edit.meta.internal.MetaElementImpl;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MetaElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSectionImpl
extends MetaElementImpl
implements ExtendedSection {
    private String type;
    private List<ExtendedReference> references;
    private List<ExtendedAttribute> rtes;
    private List<ExtendedAttribute> attributes;
    private List<ExtendedTable> tables;

    public ExtendedSectionImpl(MetaElement parent) {
        super(parent);
    }

    public String getType() {
        return this.type;
    }

    public List<ExtendedReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<ExtendedReference>();
        }
        return this.references;
    }

    @Deprecated
    public List<ExtendedAttribute> getRtes() {
        if (this.rtes == null) {
            this.rtes = new ArrayList<ExtendedAttribute>();
        }
        return this.rtes;
    }

    public List<ExtendedAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ExtendedAttribute>();
        }
        return this.attributes;
    }

    public List<ExtendedTable> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<ExtendedTable>();
        }
        return this.tables;
    }

    @Override
    public void parseElement(Element element) throws TypeDefException {
        List attributeElements;
        super.parseElement(element);
        this.type = element.getAttribute("type");
        if ("rte".equals(this.type)) {
            this.type = "attribute";
        }
        this.getReferences().clear();
        List referenceElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"reference");
        if (referenceElements != null) {
            for (Element rElement : referenceElements) {
                ExtendedReferenceImpl ref = (ExtendedReferenceImpl)TypeDefUtil.getInstance().newExtendedReference(this);
                ref.parseElement(rElement);
                this.getReferences().add(ref);
            }
        }
        this.getAttributes().clear();
        List rteElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"rte");
        if (rteElements != null) {
            for (Element rElement : rteElements) {
                ExtendedAttributeImpl rte = new ExtendedAttributeImpl(this);
                rte.parseElement(rElement);
                this.getAttributes().add(rte);
            }
        }
        if ((attributeElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"attribute")) != null) {
            for (Element aElement : attributeElements) {
                ExtendedAttributeImpl att = new ExtendedAttributeImpl(this);
                att.parseElement(aElement);
                this.getAttributes().add(att);
            }
        }
        this.getTables().clear();
        List tableElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"table");
        if (tableElements != null) {
            for (Element tElement : tableElements) {
                ExtendedTableImpl table = new ExtendedTableImpl(this);
                table.parseElement(tElement);
                this.getTables().add(table);
            }
        }
    }

    @Override
    public boolean processInheritance() {
        if (!super.processInheritance()) {
            return false;
        }
        if (this.getSuperMeta() == null) {
            this.references = ExtendedSectionImpl.processSuppress(this.getReferences());
            this.rtes = ExtendedSectionImpl.processSuppress(this.getRtes());
            return true;
        }
        if (this.getSuperMeta() instanceof ExtendedSectionImpl) {
            ExtendedSectionImpl sMeta = (ExtendedSectionImpl)this.getSuperMeta();
            sMeta.processInheritance();
            this.references = ExtendedSectionImpl.processInherentList(this.getReferences(), sMeta.getReferences());
            for (ExtendedReference ref : this.getReferences()) {
                ref.processInheritance();
            }
            this.rtes = ExtendedSectionImpl.processInherentList(this.getRtes(), sMeta.getRtes());
            for (ExtendedAttribute att : this.getRtes()) {
                att.processInheritance();
            }
            return true;
        }
        return true;
    }
}

