/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.List;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.internal.MetaElementImpl;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MetaElement;
import org.w3c.dom.Element;

public class ExtendedTableImpl
extends MetaElementImpl
implements ExtendedTable {
    private ExtendedReference columnReference;
    private ExtendedReference rowReference;
    private ExtendedReference cellReference;
    private String columnSplit;

    public ExtendedTableImpl(MetaElement parent) {
        super(parent);
    }

    public ExtendedReference getColumnReference() {
        return this.columnReference;
    }

    public ExtendedReference getRowReference() {
        return this.rowReference;
    }

    public ExtendedReference getCellReference() {
        return this.cellReference;
    }

    public String getColumnSplit() {
        return this.columnSplit;
    }

    public void parseElement(Element element) throws TypeDefException {
        super.parseElement(element);
        if (!(this.getParent() instanceof ExtendedSection)) {
            return;
        }
        List references = ((ExtendedSection)this.getParent()).getReferences();
        if (references.isEmpty()) {
            return;
        }
        String colStr = element.getAttribute("columnReference");
        String rowStr = element.getAttribute("rowReference");
        String celStr = element.getAttribute("cellReference");
        this.columnSplit = element.getAttribute("columnSplit");
        if (colStr == null || rowStr == null || celStr == null) {
            return;
        }
        colStr = colStr.trim();
        rowStr = rowStr.trim();
        celStr = celStr.trim();
        for (ExtendedReference ref : references) {
            if (colStr.equals(ref.getId())) {
                this.columnReference = ref;
            }
            if (rowStr.equals(ref.getId())) {
                this.rowReference = ref;
            }
            if (celStr.equals(ref.getId())) {
                this.cellReference = ref;
            }
            if (this.columnReference != null && this.rowReference != null && this.cellReference != null) break;
        }
    }
}

