/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.meta.IMetaDef;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedOpposite;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaElementImpl
implements MetaElement,
IMetaDef,
Adapter {
    private String id;
    private String name;
    private String textContent;
    private String globalId;
    private boolean suppressed = false;
    private MetaElement parent;
    private boolean inheritanceProcessed = false;
    private MetaElement superMeta;
    private boolean publish = true;
    private String layout;

    public MetaElementImpl(MetaElement parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public String getGlobalId() {
        if (this.globalId == null) {
            this.globalId = this.getGlobalId_();
        }
        return this.globalId;
    }

    private String getGlobalId_() {
        if (this.getParent() != null) {
            return String.valueOf(this.getParent().getGlobalId()) + ".." + this.getId();
        }
        return this.getId();
    }

    public MetaElement getParent() {
        return this.parent;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public int compareTo(MetaElement o) {
        return this.getName().compareTo(o.getName());
    }

    private void validateId(String id) throws TypeDefException {
        String context = "";
        if (this instanceof ModifiedTypeMeta) {
            context = "Modified type";
        } else if (this instanceof ExtendedSection) {
            context = "Section";
        } else if (this instanceof ExtendedAttribute) {
            context = "Rte";
        } else if (this instanceof QualifiedReference) {
            context = "Qualified reference";
        } else if (this instanceof ExtendedReference) {
            context = "Reference";
        } else if (this instanceof ExtendedTable) {
            context = "Table";
        } else if (this instanceof ExtendedOpposite) {
            if (id == null || id.length() == 0) {
                return;
            }
            context = "Opposite feature";
        }
        TypeDefUtil.getInstance().validateId(context, id);
    }

    @Override
    public void parseElement(Element element) throws TypeDefException {
        String str;
        if (element == null) {
            return;
        }
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.layout = element.getAttribute("layout");
        if (this.id != null) {
            this.id = this.id.trim();
        }
        if (this.name != null) {
            this.name = this.name.trim();
        }
        if (this.layout != null && this.layout.length() > 0) {
            this.layout = this.layout.trim();
        }
        this.suppressed = (str = element.getAttribute("suppressed")) == null ? false : Boolean.parseBoolean(str.trim());
        str = element.getAttribute("publish");
        this.publish = str == null || str.trim().length() == 0 ? true : Boolean.parseBoolean(str.trim());
        Element nameElement = XMLUtil.getFirstChildElementByTagName((Node)element, (String)"name");
        if (nameElement != null) {
            this.name = nameElement.getTextContent();
        }
        this.name = this.name.trim();
        this.textContent = element.getTextContent().trim();
        this.validateId(this.id);
    }

    public boolean processInheritance() {
        if (this.inheritanceProcessed) {
            return false;
        }
        this.inheritanceProcessed = true;
        return true;
    }

    protected static List<? extends MetaElement> processInherentList(List<? extends MetaElement> myList, List<? extends MetaElement> superList) {
        HashMap<String, MetaElement> map = new HashMap<String, MetaElement>();
        for (MetaElement metaElement : myList) {
            map.put(metaElement.getId(), metaElement);
        }
        ArrayList<MetaElement> arrayList = new ArrayList<MetaElement>();
        for (MetaElement metaElement : superList) {
            MetaElement childMeta = (MetaElement)map.remove(metaElement.getId());
            if (childMeta == null) {
                childMeta = metaElement;
            } else {
                childMeta.setSuperMeta(metaElement);
            }
            if (childMeta.isSuppressed()) continue;
            arrayList.add(childMeta);
        }
        for (MetaElement metaElement : myList) {
            if (metaElement.isSuppressed() || !map.containsKey(metaElement.getId())) continue;
            arrayList.add(metaElement);
        }
        return arrayList;
    }

    protected static List<? extends MetaElement> processSuppress(List<? extends MetaElement> myList) {
        ArrayList<MetaElement> newList = new ArrayList<MetaElement>();
        for (MetaElement metaElement : myList) {
            if (metaElement.isSuppressed()) continue;
            newList.add(metaElement);
        }
        return newList;
    }

    public boolean publish() {
        return this.publish;
    }

    public String getLayout() {
        return this.layout;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public MetaElement getSuperMeta() {
        return this.superMeta;
    }

    public void setSuperMeta(MetaElement superMeta) {
        this.superMeta = superMeta;
    }

    public String getDebugString(int ix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "[" + ix + "] " + this.getReferenceString(this) + "\n");
        this.getDebugStringImpl(sb, indent);
        return sb.toString();
    }

    protected String getReferenceString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(this.getClass().getSimpleName()) + ": " + obj.hashCode();
    }

    protected void getDebugStringImpl(StringBuffer sb, String indent) {
        sb.append(String.valueOf(indent) + "id:          " + this.id + "\n");
        sb.append(String.valueOf(indent) + "name:        " + this.name + "\n");
        sb.append(String.valueOf(indent) + "globalId:    " + this.getGlobalId() + "\n");
        sb.append(String.valueOf(indent) + "suppressed:  " + this.suppressed + "\n");
        sb.append(String.valueOf(indent) + "parent:      " + this.getReferenceString(this.parent) + "\n");
        sb.append(String.valueOf(indent) + "superMeta:   " + this.getReferenceString(this.superMeta) + "\n");
        sb.append(String.valueOf(indent) + "publish:     " + this.publish + "\n");
        sb.append("\n");
    }

    public boolean isAncestorOf(MetaElement element) {
        MetaElement parent = element == null ? null : element.getParent();
        while (parent != null) {
            if (parent == this) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public ModifiedTypeMeta getModifiedTypeMeta() {
        MetaElementImpl e = this;
        while (e != null) {
            if (e instanceof ModifiedTypeMeta) {
                return (ModifiedTypeMeta)e;
            }
            e = e.getParent();
        }
        return null;
    }

    protected Boolean parseBoolean(Element element, String att) {
        String value = element.getAttribute(att);
        if (value == null) {
            return null;
        }
        if (value.trim().equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.trim().equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

