/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.ExtendedAttributeImpl;
import org.eclipse.epf.library.edit.meta.internal.ExtendedSectionImpl;
import org.eclipse.epf.library.edit.meta.internal.MetaElementImpl;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedFeature;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiedTypeMetaImpl
extends MetaElementImpl
implements ModifiedTypeMeta {
    private List<ExtendedReference> references;
    private List<ExtendedAttribute> rtes;
    private List<ExtendedAttribute> attributes;
    private List<ExtendedSection> sections;
    private List<ExtendedSection> referenceSections;
    private List<ExtendedSection> rteSections;
    private List<ExtendedSection> attributeSections;
    private List<ExtendedTable> tables;
    private List<String> linkTypes;
    private Set<MetaElement> linkedMetaElements;
    private static ExtendedAttribute nullExtendedAttributeValue = new ExtendedAttributeImpl(null);
    private Map<String, ExtendedAttribute> extendedAttributeMap = new HashMap<String, ExtendedAttribute>();

    public ModifiedTypeMetaImpl() {
        super(null);
    }

    public List<ExtendedReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<ExtendedReference>();
        }
        return this.references;
    }

    @Deprecated
    public List<ExtendedAttribute> getRtes() {
        if (this.rtes == null) {
            this.rtes = new ArrayList<ExtendedAttribute>();
        }
        return this.rtes;
    }

    public List<ExtendedAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ExtendedAttribute>();
        }
        return this.attributes;
    }

    @Override
    public boolean isSuppressed() {
        return false;
    }

    public List<ExtendedSection> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<ExtendedSection>();
        }
        return this.sections;
    }

    public List<ExtendedSection> getReferenceSections() {
        if (this.referenceSections == null) {
            this.referenceSections = new ArrayList<ExtendedSection>();
        }
        return this.referenceSections;
    }

    @Deprecated
    public List<ExtendedSection> getRteSections() {
        if (this.rteSections == null) {
            this.rteSections = new ArrayList<ExtendedSection>();
        }
        return this.rteSections;
    }

    public List<ExtendedSection> getAttributeSections() {
        if (this.attributeSections == null) {
            this.attributeSections = new ArrayList<ExtendedSection>();
        }
        return this.attributeSections;
    }

    public List<ExtendedTable> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<ExtendedTable>();
        }
        return this.tables;
    }

    public List<String> getLinkTypes() {
        if (this.linkTypes == null) {
            this.linkTypes = new ArrayList<String>();
        }
        return this.linkTypes;
    }

    @Override
    public void parseElement(Element element) throws TypeDefException {
        List sectionElements;
        super.parseElement(element);
        this.getSections().clear();
        this.getLinkTypes().clear();
        List linkTypeElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"linkType");
        if (linkTypeElements != null) {
            for (Element linkTypeElement : linkTypeElements) {
                String linkType = linkTypeElement.getAttribute("id");
                this.getLinkTypes().add(linkType);
            }
        }
        if ((sectionElements = XMLUtil.getChildElementsByTagName((Element)element, (String)"section")) != null) {
            for (Element sElement : sectionElements) {
                ExtendedSectionImpl ses = (ExtendedSectionImpl)TypeDefUtil.getInstance().newExtendedSection(this);
                ses.parseElement(sElement);
                this.getSections().add(ses);
            }
        }
        this.init();
    }

    @Override
    public boolean processInheritance() {
        if (!super.processInheritance()) {
            return false;
        }
        if (this.getSuperMeta() == null) {
            int sz = this.getSections().size();
            this.sections = ModifiedTypeMetaImpl.processSuppress(this.getSections());
            if (sz != this.sections.size()) {
                this.init();
            }
            return true;
        }
        if (this.getSuperMeta() instanceof ModifiedTypeMetaImpl) {
            ModifiedTypeMetaImpl sMeta = (ModifiedTypeMetaImpl)this.getSuperMeta();
            sMeta.processInheritance();
            this.sections = ModifiedTypeMetaImpl.processInherentList(this.getSections(), sMeta.getSections());
            for (ExtendedSection section : this.getSections()) {
                section.processInheritance();
            }
            this.init();
            return true;
        }
        return true;
    }

    private void init() {
        this.getReferences().clear();
        this.getRtes().clear();
        this.getAttributes().clear();
        this.getReferenceSections().clear();
        this.getRteSections().clear();
        this.getAttributeSections().clear();
        this.getTables().clear();
        for (ExtendedSection section : this.getSections()) {
            if ("reference".equals(section.getType())) {
                this.getReferenceSections().add(section);
                this.getReferences().addAll(section.getReferences());
                this.getTables().addAll(section.getTables());
                continue;
            }
            if ("rte".equals(section.getType())) {
                this.getRteSections().add(section);
                this.getRtes().addAll(section.getRtes());
                continue;
            }
            if (!"attribute".equals(section.getType())) continue;
            this.getAttributeSections().add(section);
            this.getAttributes().addAll(section.getAttributes());
        }
    }

    public boolean processLink(ModifiedTypeMeta linkedMeta) {
        if (linkedMeta == null) {
            return false;
        }
        this.getSections().addAll(linkedMeta.getSections());
        this.getReferences().addAll(linkedMeta.getReferences());
        this.getRtes().addAll(linkedMeta.getRtes());
        this.getAttributes().addAll(linkedMeta.getAttributes());
        this.getReferenceSections().addAll(linkedMeta.getReferenceSections());
        this.getRteSections().addAll(linkedMeta.getRteSections());
        this.getAttributeSections().addAll(linkedMeta.getAttributeSections());
        if (this.linkedMetaElements == null) {
            this.linkedMetaElements = new HashSet<MetaElement>();
        }
        this.linkedMetaElements.addAll(linkedMeta.getReferences());
        this.linkedMetaElements.addAll(linkedMeta.getRtes());
        this.linkedMetaElements.addAll(linkedMeta.getAttributes());
        this.linkedMetaElements.addAll(linkedMeta.getSections());
        return true;
    }

    public boolean isLinkedFeature(ExtendedFeature feature) {
        return this.linkedMetaElements == null ? false : this.linkedMetaElements.contains(feature);
    }

    public boolean isLinkedSection(ExtendedSection section) {
        return this.linkedMetaElements == null ? false : this.linkedMetaElements.contains(section);
    }

    @Override
    protected void getDebugStringImpl(StringBuffer sb, String indent) {
        super.getDebugStringImpl(sb, indent);
        sb.append(String.valueOf(indent) + "sections: " + this.sections.size() + "\n");
        int i = 0;
        while (i < this.sections.size()) {
            ExtendedSection meta = this.sections.get(i);
            sb.append(meta.getDebugString(i, String.valueOf(indent) + indent));
            ++i;
        }
        sb.append(String.valueOf(indent) + "linkTypes: " + this.linkTypes.size() + "\n");
        i = 0;
        while (i < this.linkTypes.size()) {
            sb.append(String.valueOf(indent) + indent + this.linkTypes.get(i) + "\n");
            ++i;
        }
        sb.append("\n");
    }

    public ExtendedAttribute getExtendedAttribute(String globalId) {
        if (globalId == null) {
            return null;
        }
        ExtendedAttribute value = this.extendedAttributeMap.get(globalId);
        if (value == nullExtendedAttributeValue) {
            return null;
        }
        if (value != null) {
            return value;
        }
        for (ExtendedAttribute att : this.getAttributes()) {
            if (!globalId.equals(att.getGlobalId())) continue;
            value = att;
            break;
        }
        if (value == null) {
            value = nullExtendedAttributeValue;
        }
        this.extendedAttributeMap.put(globalId, value);
        return value == nullExtendedAttributeValue ? null : value;
    }
}

