/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.meta.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.edit.meta.IMetaDef;
import org.eclipse.epf.library.edit.meta.TypeDefException;
import org.eclipse.epf.library.edit.meta.TypeDefParser;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.ModifiedTypeMetaImpl;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefParserImpl
implements TypeDefParser {
    @Override
    public List<IMetaDef> parse(Document doc) throws TypeDefException {
        ArrayList<IMetaDef> metaList = new ArrayList<IMetaDef>();
        NodeList list = doc.getElementsByTagName("modifiedType");
        int size = list.getLength();
        HashMap<String, ModifiedTypeMetaImpl> map = new HashMap<String, ModifiedTypeMetaImpl>();
        int i = 0;
        while (i < size) {
            Element element = (Element)list.item(i);
            ModifiedTypeMetaImpl meta = (ModifiedTypeMetaImpl)TypeDefUtil.getInstance().newModifiedTypeMeta();
            meta.parseElement(element);
            metaList.add(meta);
            if (map.put(meta.getId(), meta) != null) {
                throw new TypeDefException("Duplicate modified type id values are not allowed: " + meta.getId());
            }
            ++i;
        }
        HashMap<String, ModifiedTypeMetaImpl> linkTypeMap = new HashMap<String, ModifiedTypeMetaImpl>();
        block3: for (ModifiedTypeMetaImpl modifiedTypeMetaImpl : metaList) {
            for (String linkType : modifiedTypeMetaImpl.getLinkTypes()) {
                linkTypeMap.put(linkType, modifiedTypeMetaImpl);
            }
            try {
                Class cls = Class.forName(modifiedTypeMetaImpl.getId());
                if (cls == null) continue;
                cls = TypeDefUtil.getSuperClass(cls);
                while (cls != null) {
                    ModifiedTypeMetaImpl superMeta = (ModifiedTypeMetaImpl)map.get(cls.getName());
                    if (superMeta != null) {
                        modifiedTypeMetaImpl.setSuperMeta(superMeta);
                        continue block3;
                    }
                    cls = TypeDefUtil.getSuperClass(cls);
                }
            }
            catch (Exception exception) {}
        }
        for (ModifiedTypeMetaImpl modifiedTypeMetaImpl : metaList) {
            modifiedTypeMetaImpl.processInheritance();
        }
        for (ModifiedTypeMetaImpl modifiedTypeMetaImpl : metaList) {
            ModifiedTypeMeta linkedMeta = this.getLinkedMeta(modifiedTypeMetaImpl, map);
            if (linkedMeta == null && !linkTypeMap.isEmpty()) {
                linkedMeta = (ModifiedTypeMeta)linkTypeMap.get(modifiedTypeMetaImpl.getId());
            }
            modifiedTypeMetaImpl.processLink(linkedMeta);
        }
        return metaList;
    }

    private ModifiedTypeMeta getLinkedMeta(ModifiedTypeMeta meta, Map<String, ModifiedTypeMetaImpl> map) {
        if (meta.getId().equals("org.eclipse.epf.uma.TaskDescriptor")) {
            return map.get("org.eclipse.epf.uma.Task");
        }
        if (meta.getId().equals("org.eclipse.epf.uma.RoleDescriptor")) {
            return map.get("org.eclipse.epf.uma.Role");
        }
        if (meta.getId().equals("org.eclipse.epf.uma.WorkProductDescriptor")) {
            return map.get("org.eclipse.epf.uma.WorkProduct");
        }
        return null;
    }
}

