/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.PluginUIPackagesMap;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUIPackageBuilder {
    private AdapterFactory adapterFactory;
    private Map<String, PluginUIPackagesItemProvider> pluginPackagesItemProvidersMap = new HashMap<String, PluginUIPackagesItemProvider>();

    public PluginUIPackageBuilder(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public PluginUIPackagesItemProvider getPluginUIPackagesItemProvider(String pluginPkgName) {
        return this.pluginPackagesItemProvidersMap.get(pluginPkgName);
    }

    public Collection<Object> getChildren(Collection<MethodPlugin> plugins) {
        ArrayList<Object> children = new ArrayList<Object>();
        this.addChildren(children, plugins, null);
        Collections.sort(children, Comparators.PLUGINPACKAGE_COMPARATOR);
        return children;
    }

    private void retainPluginPackagesItemProviders(Collection<String> names) {
        Iterator<String> iter = this.pluginPackagesItemProvidersMap.keySet().iterator();
        while (iter.hasNext()) {
            String keyName = iter.next();
            if (names.contains(keyName)) continue;
            PluginUIPackagesItemProvider provider = this.pluginPackagesItemProvidersMap.get(keyName);
            if (provider != null) {
                provider.dispose();
            }
            iter.remove();
        }
    }

    protected void addChildren(Collection<Object> children, Collection<MethodPlugin> plugins, Object parent) {
        PluginUIPackagesMap map = new PluginUIPackagesMap();
        for (MethodPlugin plugin : plugins) {
            String pluginName = plugin.getName();
            int dotIdx = pluginName.indexOf(".");
            if (dotIdx != -1) {
                map.add(pluginName.substring(0, dotIdx), plugin);
                continue;
            }
            children.add(plugin);
            Adapter adapter = this.adapterFactory.adapt((Notifier)plugin, ITreeItemContentProvider.class);
            if (!(adapter instanceof ILibraryItemProvider)) continue;
            ((ILibraryItemProvider)adapter).setParent(parent);
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Set plugSet = (Set)entry.getValue();
            PluginUIPackagesItemProvider provider = this.pluginPackagesItemProvidersMap.get(name);
            if (provider == null) {
                provider = new PluginUIPackagesItemProvider(this.adapterFactory, name, plugSet);
                this.pluginPackagesItemProvidersMap.put(name, provider);
            } else {
                provider.setPlugins(plugSet);
            }
            existingNames.add(name);
            provider.setParent(parent);
            children.add(provider);
        }
        this.retainPluginPackagesItemProviders(existingNames);
    }

    public void dispose() {
        if (this.pluginPackagesItemProvidersMap != null) {
            this.pluginPackagesItemProvidersMap.clear();
            this.pluginPackagesItemProvidersMap = null;
        }
    }
}

