/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.navigator.AbstractProcessesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessPackageItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class ProcessesItemProvider
extends AbstractProcessesItemProvider {
    private static final String PROCESS_CONTRIBUTIONS_LABEL = LibraryEditPlugin.INSTANCE.getString("_UI_ProcessContributions_text");
    private MethodPlugin plugin;
    private ProcessPackage processContributionsPackage;
    private ProcessPackage capabilityPatternPackage;
    private ProcessPackage deliveryProcessPackage;

    public ProcessesItemProvider(AdapterFactory adapterFactory, MethodPlugin plugin, ModelStructure modelStruct) {
        super(adapterFactory, modelStruct);
        this.plugin = plugin;
    }

    public Collection getChildren(Object object) {
        if (this.children == null) {
            ProcessPackageItemProvider adapter;
            ProcessPackage pkg;
            this.children = new ArrayList();
            this.capabilityPatternPackage = pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)this.plugin, (String[])this.modelStruct.capabilityPatternPath);
            if (pkg != null) {
                adapter = (ProcessPackageItemProvider)TngUtil.getBestAdapterFactory(this.adapterFactory).adapt((Notifier)pkg, ITreeItemContentProvider.class);
                adapter.setProcessType(UmaPackage.eINSTANCE.getCapabilityPattern());
                adapter.setLabel(LibraryEditPlugin.INSTANCE.getString("_UI_CapabilityPatterns_text"));
                adapter.setParent(this);
                this.children.add(pkg);
            }
            pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)this.plugin, (String[])this.modelStruct.deliveryProcessPath);
            this.deliveryProcessPackage = this.deliveryProcessPackage;
            if (pkg != null) {
                adapter = (ProcessPackageItemProvider)TngUtil.getBestAdapterFactory(this.adapterFactory).adapt((Notifier)pkg, ITreeItemContentProvider.class);
                adapter.setProcessType(UmaPackage.eINSTANCE.getDeliveryProcess());
                adapter.setLabel(LibraryEditPlugin.INSTANCE.getString("_UI_DeliveryProcesses_text"));
                adapter.setParent(this);
                this.children.add(pkg);
            }
        } else {
            ProcessPackage pkg = this.getProcessContributionsPackage();
            this.children.remove(pkg);
        }
        return this.children;
    }

    private ProcessPackage getProcessContributionsPackage() {
        if (this.processContributionsPackage == null) {
            this.processContributionsPackage = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)this.plugin, (String[])this.modelStruct.processContributionPath);
            if (this.processContributionsPackage == null) {
                this.processContributionsPackage = ModelStructure.createProcessContributionPackage(this.plugin);
            }
            ProcessPackageItemProvider adapter = (ProcessPackageItemProvider)this.getRootAdapterFactory().adapt((Notifier)this.processContributionsPackage, ITreeItemContentProvider.class);
            adapter.setLabel(PROCESS_CONTRIBUTIONS_LABEL);
            adapter.setParent(this);
        }
        return this.processContributionsPackage;
    }

    public Object getParent(Object object) {
        return this.plugin;
    }

    public ProcessPackage getCapabilityPatternPackage() {
        return this.capabilityPatternPackage;
    }

    public ProcessPackage getDeliveryProcessPackage() {
        return this.deliveryProcessPackage;
    }
}

