/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.IWrapperItemProviderFactoryProvider;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IBreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.library.edit.process.IProcessItemProvider;
import org.eclipse.epf.library.edit.process.TeamProfileWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityAddCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.GraphicalData;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.WbePropUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.provider.ActivityItemProvider;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BSActivityItemProvider
extends ActivityItemProvider
implements IProcessItemProvider,
IBSItemProvider,
ITableItemLabelProvider,
IConfigurable,
ICachedChildrenItemProvider {
    private static final Set<VariabilityType> localVariabilityTypes = new HashSet<VariabilityType>(Arrays.asList(VariabilityType.LOCAL_CONTRIBUTION, VariabilityType.LOCAL_REPLACEMENT));
    private Object parent;
    private int id;
    protected Object topItem = null;
    private boolean rolledUp;
    private GraphicalData graphicalData;
    private PredecessorList predecessors;
    private Boolean expanded;
    protected Adapter baseListener;
    private IFilter childFilter = new IFilter(){

        public boolean accept(Object obj) {
            return BSActivityItemProvider.this.acceptAsChild(obj);
        }
    };
    private boolean refreshAllIDsRequired;
    private IFilter filter;
    protected List cachedChildren;
    protected List cachedRollupChildren;
    private IConfigurator configurator;
    private Disposable contributedWrappers;
    private VariabilityInfo variabilityInfo;
    private boolean enableVariabilityInfo = true;
    private Disposable rolledUpWrappers;

    public BSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void dispose() {
        if (this.baseListener != null) {
            Activity act;
            VariabilityElement base;
            EObject currentBase = (EObject)this.baseListener.getTarget();
            if (currentBase != null) {
                currentBase.eAdapters().remove((Object)this.baseListener);
            }
            if (this.getTarget() instanceof Activity && (base = (act = (Activity)this.getTarget()).getVariabilityBasedOnElement()) != null) {
                base.eAdapters().remove((Object)this.baseListener);
            }
        }
        if (this.predecessors != null) {
            this.predecessors.dispose();
        }
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        if (this.cachedRollupChildren != null) {
            this.cachedRollupChildren.clear();
            this.cachedRollupChildren = null;
        }
        if (this.contributedWrappers != null) {
            this.contributedWrappers.dispose();
            this.contributedWrappers = null;
        }
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
            this.rolledUpWrappers = null;
        }
        super.dispose();
    }

    protected boolean acceptAsChild(Object child) {
        if (this.filter != null) {
            return this.filter.accept(child);
        }
        return true;
    }

    protected boolean acceptAsChild(Object parent, Object child) {
        return this.acceptAsChild(child);
    }

    protected boolean acceptAsRolledUpChild(Object child) {
        child = TngUtil.unwrap(child);
        if (this.filter != null && !(child instanceof Activity) && !(child instanceof TeamProfile)) {
            return this.filter.accept(child);
        }
        return true;
    }

    protected abstract Object getObject(Descriptor var1);

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        if (this.isRolledUp()) {
            return Collections.EMPTY_LIST;
        }
        return super.getNewChildDescriptors(object, editingDomain, sibling);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
    }

    @Override
    public Boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(Boolean b) {
        this.expanded = b;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Object getTopItem() {
        if (this.topItem == null) {
            IBSItemProvider adapter;
            Object ip;
            if (ProcessUtil.isTopProcess(this.target)) {
                return this.target;
            }
            Object parent = this.getParent(this.target);
            if (parent != null && (ip = this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class)) instanceof IBSItemProvider && (adapter = (IBSItemProvider)ip) != null) {
                Object top = adapter.getTopItem();
                if (top == null && parent instanceof Process && ((Process)parent).getSuperActivities() == null) {
                    top = parent;
                    adapter.setTopItem(top);
                }
                return top;
            }
        }
        return this.topItem;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    private static boolean isTopActivity(Object object) {
        EObject eObj = (EObject)object;
        EObject parent = eObj.eContainer();
        if (parent instanceof ProcessComponent) {
            ProcessComponent pc = (ProcessComponent)parent;
            return object == pc.getProcess();
        }
        return false;
    }

    protected static boolean hasChildDescriptor(Activity act) {
        for (Object element : act.getBreakdownElements()) {
            if (!(element instanceof Descriptor)) continue;
            return true;
        }
        return false;
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getActivity_BreakdownElements());
        }
        return this.childrenFeatures;
    }

    protected void setParentFor(Object child, Object parent) {
        ProcessUtil.setParent(child, parent, this.getRootAdapterFactory());
    }

    private Collection getImmediateChildren(Object object) {
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        boolean isSynFree = ProcessUtil.isSynFree();
        Collection children = new ArrayList();
        for (Object child : super.getChildren(object)) {
            Descriptor des;
            Descriptor greenParent;
            Object unwrapped;
            if (!this.acceptAsChild(object, child) || isSynFree && (unwrapped = TngUtil.unwrap(child)) instanceof Descriptor && (greenParent = propUtil.getGreenParentDescriptor(des = (Descriptor)unwrapped)) != null) continue;
            if (this.configurator != null) {
                child = this.configurator.resolve(child);
            }
            if (child == null || children.contains(child)) continue;
            this.setParentFor(child, object);
            children.add(child);
        }
        children = this.addInherited(object, (List)children);
        return children;
    }

    private Collection getRolledUpChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        ArrayList<Object> children = new ArrayList<Object>();
        AbstractTreeIterator iter = new AbstractTreeIterator(object, false){
            private static final long serialVersionUID = -3159537629619737368L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    Iterator iterator;
                    BSActivityItemProvider adapter = (BSActivityItemProvider)BSActivityItemProvider.this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
                    boolean b = adapter.isRolledUp();
                    try {
                        adapter.basicSetRolledUp(false);
                        iterator = adapter.getChildren(object).iterator();
                    }
                    finally {
                        adapter.basicSetRolledUp(b);
                    }
                    return iterator;
                }
                if (object instanceof BreakdownElementWrapperItemProvider && !(object instanceof TeamProfileWrapperItemProvider)) {
                    return ((BreakdownElementWrapperItemProvider)object).getChildren(object).iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        ArrayList<Object> descriptors = new ArrayList<Object>();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!this.acceptAsRolledUpChild(child)) continue;
            Object e = TngUtil.unwrap(child);
            if (e instanceof Descriptor) {
                ComposedBreakdownElementWrapperItemProvider composedWrapper;
                Object desc = this.findDescriptor(descriptors, e);
                if (desc == null) {
                    if (this.isWrappingRollupNeeded(child)) {
                        child = this.createRollupWrapper(child, object, this.adapterFactory);
                    }
                    children.add(child);
                    descriptors.add(child);
                    continue;
                }
                if (!this.isWrappingRollupNeeded(child) || (composedWrapper = ProcessUtil.getComposedWrapper(desc)) == null) continue;
                composedWrapper.addElement(child);
                continue;
            }
            children.add(child);
        }
        descriptors.clear();
        descriptors = null;
        return children;
    }

    protected boolean isWrappingRollupNeeded(Object object) {
        return false;
    }

    protected ComposedBreakdownElementWrapperItemProvider createComposedWrapper(Object object, Object owner, AdapterFactory adapterFactory) {
        return new ComposedBreakdownElementWrapperItemProvider(object, owner, adapterFactory);
    }

    protected Object createRollupWrapper(Object object, Object owner, AdapterFactory adapterFactory) {
        ComposedBreakdownElementWrapperItemProvider wrapper = this.createComposedWrapper(object, owner, adapterFactory);
        wrapper.readOnly = true;
        wrapper.isRollupChild = true;
        if (this.rolledUpWrappers == null) {
            this.rolledUpWrappers = new Disposable();
        }
        this.rolledUpWrappers.add((Object)wrapper);
        return wrapper;
    }

    private Collection doGetChildren(Object object) {
        if (this.isRolledUp()) {
            return this.getRolledUpChildren(object);
        }
        return this.getImmediateChildren(object);
    }

    public Collection getChildren(Object object) {
        Collection children = this.getChildren_(object);
        if (!(children instanceof List)) {
            return children;
        }
        Activity activity = (Activity)object;
        VariabilityType extendType = activity.getVariabilityType();
        if (extendType != VariabilityType.LOCAL_CONTRIBUTION && extendType != VariabilityType.EXTENDS) {
            return children;
        }
        List childList = this.handleGlobalOrdering(activity, (List)children);
        return childList;
    }

    private List handleGlobalOrdering(Activity activity, List childList) {
        WbePropUtil propUtil = WbePropUtil.getWbePropUtil();
        WorkBreakdownElement globalPresentedAfter = null;
        LinkedChildList linkedChildList = null;
        HashMap<WorkBreakdownElement, LinkedChildListNode> map = null;
        ArrayList<LinkedChildListNode> toMoveList = new ArrayList<LinkedChildListNode>();
        int i = 0;
        while (i < childList.size()) {
            WorkBreakdownElement wbe;
            Object item = childList.get(i);
            if (item instanceof WorkBreakdownElement && (globalPresentedAfter = propUtil.getGlobalPresentedAfter(wbe = (WorkBreakdownElement)item)) != null && linkedChildList == null) {
                map = new HashMap<WorkBreakdownElement, LinkedChildListNode>();
                linkedChildList = this.getLinkedChildList(activity, childList, i, map);
            }
            if (linkedChildList != null) {
                this.addItemToLinkedChildList(map, linkedChildList, item, globalPresentedAfter);
                if (globalPresentedAfter != null) {
                    toMoveList.add(linkedChildList.last);
                }
            }
            ++i;
        }
        boolean orderModified = false;
        for (LinkedChildListNode node : toMoveList) {
            LinkedChildListNode newPrevNode;
            WorkBreakdownElement key = node.globalPresentedAfter;
            LinkedChildListNode linkedChildListNode = newPrevNode = key == activity ? linkedChildList.head : (LinkedChildListNode)map.get(key);
            if (newPrevNode == null || node.prevNode == newPrevNode) continue;
            node.prevNode.nextNode = node.nextNode;
            if (node.nextNode != null) {
                node.nextNode.prevNode = node.prevNode;
            }
            node.prevNode = newPrevNode;
            node.nextNode = newPrevNode.nextNode;
            if (newPrevNode.nextNode != null) {
                newPrevNode.nextNode.prevNode = node;
            }
            newPrevNode.nextNode = node;
            orderModified = true;
        }
        if (orderModified) {
            ArrayList<Object> oldChildList = childList;
            childList = new ArrayList<Object>();
            LinkedChildListNode node = linkedChildList.head.nextNode;
            while (node != null) {
                childList.add(node.thisItem);
                node = node.nextNode;
            }
            if (oldChildList.size() != childList.size()) {
                childList = oldChildList;
            }
        }
        return childList;
    }

    private LinkedChildList getLinkedChildList(Activity activity, List childList, int index, Map<WorkBreakdownElement, LinkedChildListNode> map) {
        LinkedChildList linkedChildList = new LinkedChildList(activity);
        int i = 0;
        while (i < index) {
            Object item = childList.get(i);
            this.addItemToLinkedChildList(map, linkedChildList, item, null);
            ++i;
        }
        return linkedChildList;
    }

    private void addItemToLinkedChildList(Map<WorkBreakdownElement, LinkedChildListNode> map, LinkedChildList linkedChildList, Object item, WorkBreakdownElement globalPresentedAfter) {
        LinkedChildListNode node = new LinkedChildListNode(item, globalPresentedAfter);
        node.prevNode = linkedChildList.last;
        linkedChildList.last.nextNode = node;
        linkedChildList.last = node;
        if (!(item instanceof WorkBreakdownElement)) {
            item = TngUtil.unwrap(item);
        }
        if (item instanceof WorkBreakdownElement) {
            map.put((WorkBreakdownElement)item, node);
        }
    }

    private Collection getChildren_(Object object) {
        Activity activity = (Activity)object;
        this.variabilityInfo = this.configurator != null ? (this.enableVariabilityInfo ? this.configurator.getVariabilityInfo((VariabilityElement)activity) : null) : null;
        if (this.variabilityInfo != null) {
            Collection children;
            Object resolved = this.variabilityInfo.getInheritanceList().get(0);
            BSActivityItemProvider ip = (BSActivityItemProvider)this.adapterFactory.adapt(resolved, ITreeItemContentProvider.class);
            boolean b = ip.isRolledUp();
            try {
                ip.basicSetRolledUp(this.isRolledUp());
                children = ip.doGetChildren(resolved);
            }
            finally {
                ip.basicSetRolledUp(b);
            }
            if (!this.variabilityInfo.getContributors().isEmpty()) {
                ArrayList contributedChildren = new ArrayList();
                for (Object e2 : this.variabilityInfo.getContributors()) {
                    Object adapter = this.adapterFactory.adapt(e2, ITreeItemContentProvider.class);
                    if (!(adapter instanceof BSActivityItemProvider)) continue;
                    ip = (BSActivityItemProvider)adapter;
                    b = ip.isRolledUp();
                    try {
                        ip.basicSetRolledUp(this.isRolledUp());
                        for (Object e2 : ip.getImmediateChildren(e2)) {
                            e2 = Providers.getConfigurationApplicator().resolve(e2, this.configurator.getMethodConfiguration());
                            if (e2 == null || TngUtil.contains(children, e2)) continue;
                            contributedChildren.add(e2);
                        }
                    }
                    finally {
                        ip.basicSetRolledUp(b);
                    }
                }
                if (!contributedChildren.isEmpty()) {
                    children.addAll(this.wrapContributed(activity, contributedChildren));
                }
            }
            return children;
        }
        return this.doGetChildren(object);
    }

    protected void updateCachedChildren(Collection children) {
    }

    @Override
    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    @Override
    public Collection getRollupChildrenFromCache() {
        if (this.cachedRollupChildren == null) {
            boolean oldRolledUp = this.rolledUp;
            try {
                this.rolledUp = true;
                this.getChildren(this.target);
            }
            finally {
                this.rolledUp = oldRolledUp;
            }
        }
        return this.cachedRollupChildren;
    }

    private BreakdownElementWrapperItemProvider findWrapper(Object owner, Object value) {
        List listeners;
        Object adapter = this.adapterFactory.adapt(value, ITreeItemContentProvider.class);
        BreakdownElementWrapperItemProvider wrapper = null;
        if (adapter instanceof IBSItemProvider && (listeners = ((IBSItemProvider)adapter).getListeners()) != null) {
            for (Object element : listeners) {
                if (!(element instanceof BreakdownElementWrapperItemProvider)) continue;
                wrapper = (BreakdownElementWrapperItemProvider)element;
                if (wrapper.getValue() == value && wrapper.getParent(value) == owner) break;
                wrapper = null;
            }
        }
        return wrapper;
    }

    private List wrapInherited(Activity owner, Collection breakdownElements) {
        if (this.wrappers == null) {
            this.wrappers = new Disposable();
        }
        return this.wrap(owner, breakdownElements, true, false, this.wrappers);
    }

    private List wrapContributed(Activity owner, Collection breakdownElements) {
        if (this.contributedWrappers == null) {
            this.contributedWrappers = new Disposable();
        }
        return this.wrap(owner, breakdownElements, false, true, this.contributedWrappers);
    }

    private IWrapperItemProviderFactory getWrapperItemProviderFactory() {
        IWrapperItemProviderFactory factory = null;
        if (this.adapterFactory instanceof IWrapperItemProviderFactoryProvider) {
            factory = ((IWrapperItemProviderFactoryProvider)this.adapterFactory).getWrapperItemProviderFactory();
        }
        if (factory == null) {
            factory = IBreakdownElementWrapperItemProviderFactory.INSTANCE;
        }
        return factory;
    }

    private List<?> wrap(Activity owner, Collection<?> breakdownElements, boolean inherited, boolean contributed, Disposable wrappers) {
        ArrayList<Object> wrapperList = new ArrayList<Object>();
        IWrapperItemProviderFactory wrapperFactory = this.getWrapperItemProviderFactory();
        for (Object object : breakdownElements) {
            Object unWrapped = TngUtil.unwrap(object);
            if (!(unWrapped instanceof BreakdownElement)) continue;
            BreakdownElement e = (BreakdownElement)unWrapped;
            if (TngUtil.isBase(owner.getBreakdownElements(), e, localVariabilityTypes)) continue;
            Object child = BSActivityItemProvider.getWrapper(owner, e, (Collection)wrappers);
            if (child == null) {
                child = wrapperFactory.createWrapper(e, owner, this.adapterFactory);
                if (child instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider beWrapper = (BreakdownElementWrapperItemProvider)child;
                    if (inherited) {
                        beWrapper.isInherited = true;
                    } else if (contributed) {
                        beWrapper.contributed = true;
                        if (object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isInherited()) {
                            beWrapper.isInherited = true;
                        }
                    }
                }
            } else {
                wrappers.remove(child);
            }
            wrapperList.add(child);
        }
        wrappers.dispose();
        wrappers.addAll(wrapperList);
        return wrapperList;
    }

    private static Object getWrapper(Activity owner, BreakdownElement e, Collection wrappers) {
        for (IWrapperItemProvider wrapper : wrappers) {
            if (wrapper.getOwner() != owner || wrapper.getValue() != e) continue;
            return wrapper;
        }
        return null;
    }

    protected Adapter createBaseListener() {
        if (this.baseListener == null) {
            this.baseListener = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Activity act = (Activity)BSActivityItemProvider.this.getTarget();
                    switch (notification.getFeatureID(Activity.class)) {
                        case 2: {
                            if (!ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act)) break;
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, false, true));
                            break;
                        }
                        case 0: {
                            if (act.getVariabilityBasedOnElement() == null) break;
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, false, true));
                            break;
                        }
                        case 7: {
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, true, false));
                            break;
                        }
                        case 37: {
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, true, true));
                            BSActivityItemProvider.this.refreshAffectedViewers();
                            break;
                        }
                        case 40: {
                            List list;
                            if (BSActivityItemProvider.this.handleReplaceBreakdownElement(notification) || (list = BSActivityItemProvider.this.getAffectedChildren(notification)).isEmpty()) break;
                            boolean updateLabel = BSActivityItemProvider.this.refreshChildrenData(notification, list);
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, true, updateLabel));
                            BSActivityItemProvider.this.refreshAffectedViewers();
                        }
                    }
                }
            };
        }
        return this.baseListener;
    }

    protected Activity listenToBaseActivity() {
        Adapter ip;
        Activity act = (Activity)this.target;
        if (!ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act)) {
            return null;
        }
        Activity baseAct = this.variabilityInfo != null ? (this.variabilityInfo.getInheritanceList().size() > 1 ? (Activity)this.variabilityInfo.getInheritanceList().get(1) : (Activity)this.configurator.resolve(act.getVariabilityBasedOnElement())) : (Activity)act.getVariabilityBasedOnElement();
        if (baseAct == null) {
            return null;
        }
        this.createBaseListener();
        EObject oldBase = (EObject)this.baseListener.getTarget();
        if (oldBase != null) {
            oldBase.eAdapters().remove((Object)this.baseListener);
        }
        if (!baseAct.eAdapters().contains((Object)this.baseListener)) {
            baseAct.eAdapters().add((Object)this.baseListener);
        }
        if ((ip = this.adapterFactory.adapt((Notifier)baseAct, ITreeItemContentProvider.class)) instanceof BSActivityItemProvider) {
            BSActivityItemProvider adapter = (BSActivityItemProvider)ip;
            adapter.listenToBaseActivity();
        } else {
            System.out.println();
        }
        return baseAct;
    }

    protected Collection addInherited(Object object, List myChildren) {
        if (object instanceof Activity) {
            Activity act = (Activity)object;
            Activity baseAct = this.listenToBaseActivity();
            if (baseAct != null) {
                VariabilityType extendType = act.getVariabilityType();
                if (extendType == VariabilityType.LOCAL_REPLACEMENT) {
                    return myChildren;
                }
                if (extendType == VariabilityType.LOCAL_CONTRIBUTION || extendType == VariabilityType.EXTENDS) {
                    List allChildren;
                    BSActivityItemProvider adapter = (BSActivityItemProvider)this.getRootAdapterFactory().adapt((Notifier)baseAct, ITreeItemContentProvider.class);
                    boolean oldRolledUp = adapter.isRolledUp();
                    try {
                        if (oldRolledUp) {
                            adapter.basicSetRolledUp(false);
                        }
                        allChildren = this.wrapInherited(act, adapter.getChildren(baseAct));
                        this.handleCustomizingGreenDescriptors(act, allChildren);
                    }
                    finally {
                        if (oldRolledUp) {
                            adapter.basicSetRolledUp(true);
                        }
                    }
                    if (allChildren.isEmpty()) {
                        return myChildren;
                    }
                    TngUtil.addAllTo(allChildren, myChildren);
                    return allChildren;
                }
            }
        }
        return myChildren;
    }

    private void handleCustomizingGreenDescriptors(Activity act, List allChildren) {
        if (allChildren == null || allChildren.isEmpty() || !ProcessUtil.isSynFree()) {
            return;
        }
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        List beList = act.getBreakdownElements();
        int i = 0;
        while (i < beList.size()) {
            Descriptor des;
            String greenParent;
            BreakdownElement be = (BreakdownElement)beList.get(i);
            if (be instanceof Descriptor && (greenParent = propUtil.getGreenParent(des = (Descriptor)be)) != null) {
                map.put(greenParent, des);
            }
            ++i;
        }
        int sz = map.size();
        if (sz == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < allChildren.size()) {
            Descriptor greenDes;
            Descriptor des;
            Object child = TngUtil.unwrap(allChildren.get(i2));
            if (child instanceof Descriptor && (des = (Descriptor)map.get((greenDes = (Descriptor)child).getGuid())) != null) {
                allChildren.set(i2, des);
                if (--sz == 0) {
                    return;
                }
            }
            ++i2;
        }
    }

    protected boolean isNewDescriptor(List children, Object child) {
        return this.findDescriptor(children, child) == null;
    }

    protected Object findDescriptor(List children, Object child) {
        Object obj = this.getObject((Descriptor)TngUtil.unwrap(child));
        if (obj == null) {
            return null;
        }
        int i = children.size() - 1;
        while (i > -1) {
            Object o = children.get(i);
            if (obj == this.getObject((Descriptor)TngUtil.unwrap(o))) {
                return o;
            }
            --i;
        }
        return null;
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        return this.getImage(child);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection) {
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    public IBSItemProvider getItemProvider(EObject eObj) {
        return (IBSItemProvider)TngUtil.getAdapter(eObj, IBSItemProvider.class);
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent(Object object) {
        if (this.parent == null && this.target instanceof Activity) {
            return ((Activity)this.target).getSuperActivities();
        }
        return this.parent;
    }

    protected List getAffectedChildren(Notification notification) {
        return ProcessUtil.getAffectedElements(notification, this.childFilter);
    }

    protected boolean refreshChildrenData(Notification notification, List affectedChildren) {
        return false;
    }

    protected void doRefreshChildren(Notification notification, List affectedChildren) {
        this.refreshChildrenData(notification, affectedChildren);
        Process topAct = (Process)this.getTopItem();
        AdapterFactory rootAdapterFactory = this.getRootAdapterFactory();
        ProcessUtil.refreshViewer(rootAdapterFactory, topAct);
    }

    protected void refreshChildren(final Notification notification, final List newOrOldChildren) {
        if (!newOrOldChildren.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    BSActivityItemProvider.this.doRefreshChildren(notification, newOrOldChildren);
                }
            };
            UserInteractionHelper.getUIHelper().runSafely(runnable, false);
        }
    }

    protected void refreshAffectedViewers() {
        Runnable runnable = new Runnable(){

            public void run() {
                BSActivityItemProvider.this.doRefreshAffectedViewers();
            }
        };
        UserInteractionHelper.getUIHelper().runSafely(runnable, false);
    }

    protected void doRefreshAffectedViewers() {
    }

    protected boolean handlePredecessorListChange(Notification notification) {
        return TngUtil.handlePredecessorListChange((ItemProviderAdapter)this, notification);
    }

    protected boolean handleReplaceBreakdownElement(Notification notification) {
        if (notification.getEventType() == 1 && notification.getNewValue() != notification.getOldValue()) {
            WorkBreakdownElement e;
            if (notification.getNewValue() instanceof WorkBreakdownElement && !AssociationHelper.getLinkToSuccessor((BreakdownElement)(e = (WorkBreakdownElement)notification.getNewValue())).isEmpty()) {
                ProcessUtil.refreshPredeccessorLists(this.adapterFactory, (Process)this.getTopItem());
            }
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this.getTarget(), true, false));
            this.refreshAffectedViewers();
            return true;
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (this.handlePredecessorListChange(notification)) {
            return;
        }
        switch (notification.getFeatureID(Activity.class)) {
            case 40: {
                if (this.handleReplaceBreakdownElement(notification)) {
                    return;
                }
                List newOrOldChildren = this.getAffectedChildren(notification);
                if (!newOrOldChildren.isEmpty()) {
                    switch (notification.getEventType()) {
                        case 3: 
                        case 5: {
                            this.createOrMovePackageFor(newOrOldChildren);
                        }
                    }
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                    this.refreshAffectedViewers();
                }
                return;
            }
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
            case 36: 
            case 37: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                this.refreshAffectedViewers();
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void createOrMovePackageFor(List<?> newChildren) {
        ProcessPackage pkg = (ProcessPackage)((EObject)this.target).eContainer();
        if (pkg == null) {
            return;
        }
        for (Object element : newChildren) {
            if (element instanceof Activity) {
                Activity act = (Activity)element;
                if (act.eContainer() == null) {
                    ProcessPackage newPkg = UmaFactory.eINSTANCE.createProcessPackage();
                    newPkg.setName(act.getName());
                    pkg.getChildPackages().add(newPkg);
                    newPkg.getProcessElements().add(act);
                    continue;
                }
                ProcessPackage oldPkg = (ProcessPackage)act.eContainer();
                if (oldPkg.eContainer() == pkg) continue;
                pkg.getChildPackages().add(oldPkg);
                continue;
            }
            if (!(element instanceof ProcessElement)) continue;
            pkg.getProcessElements().add((ProcessElement)element);
        }
    }

    private static void getAllBreakdownElements(Set set, BreakdownElement e) {
        boolean ret = set.add(e);
        if (ret && e instanceof Activity) {
            for (BreakdownElement element : ((Activity)e).getBreakdownElements()) {
                BSActivityItemProvider.getAllBreakdownElements(set, element);
            }
        }
    }

    private void refreshPredecessors(Notification msg, List affectedBreakdownElements) {
        HashSet<WorkBreakdownElement> refreshList = new HashSet<WorkBreakdownElement>();
        HashSet allBreakdownElements = new HashSet();
        for (BreakdownElement breakdownElement : affectedBreakdownElements) {
            if (msg.getEventType() == 4 || msg.getEventType() == 6) {
                this.setParentFor(breakdownElement, null);
            }
            BSActivityItemProvider.getAllBreakdownElements(allBreakdownElements, breakdownElement);
        }
        for (BreakdownElement breakdownElement : allBreakdownElements) {
            for (WorkOrder workOrder : AssociationHelper.getLinkToSuccessor((BreakdownElement)breakdownElement)) {
                WorkBreakdownElement succ = AssociationHelper.getSuccessor((WorkOrder)workOrder);
                if (allBreakdownElements.contains(succ)) continue;
                refreshList.add(succ);
            }
        }
        for (Object e : refreshList) {
            this.fireNotifyChanged((Notification)new ViewerNotification(msg, e, false, true));
        }
    }

    private void createPackageFor(Activity activity, EObject parentActivity) {
        ProcessPackage parent = (ProcessPackage)parentActivity.eContainer();
        ProcessPackage newPkg = UmaFactory.eINSTANCE.createProcessPackage();
        newPkg.setName(activity.getName());
        parent.getChildPackages().add(newPkg);
        ArrayList<Activity> breakdownElements = new ArrayList<Activity>();
        breakdownElements.add(activity);
        breakdownElements.addAll(activity.getBreakdownElements());
        newPkg.getProcessElements().addAll(breakdownElements);
    }

    protected String getColumnName(int columnIndex) {
        Map columnIndexToNameMap;
        AdapterFactory rootAdapterFactory = this.getRootAdapterFactory();
        if (rootAdapterFactory instanceof IColumnAware && (columnIndexToNameMap = ((IColumnAware)rootAdapterFactory).getColumnIndexToNameMap()) != null) {
            return (String)columnIndexToNameMap.get(new Integer(columnIndex));
        }
        return null;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        String colName = this.getColumnName(columnIndex);
        return TngUtil.getColumnImage(object, colName);
    }

    public String getColumnText(Object object, int columnIndex) {
        String colName = this.getColumnName(columnIndex);
        return this.getAttribute(object, colName);
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object);
    }

    @Override
    public void setTopItem(Object top) {
        this.topItem = top;
    }

    @Override
    public boolean isRolledUp() {
        return this.rolledUp;
    }

    @Override
    public void setRolledUp(boolean b) {
        this.rolledUp = b;
        if (!this.rolledUp) {
            AbstractTreeIterator iter = new AbstractTreeIterator(this.target, false){
                private static final long serialVersionUID = -7840687264753640250L;

                protected Iterator getChildren(Object object) {
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)BSActivityItemProvider.this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
                    return adapter.getChildren(object).iterator();
                }
            };
            while (iter.hasNext()) {
                Object child = iter.next();
                Object adapter = this.adapterFactory.adapt(child, ITreeItemContentProvider.class);
                if (!(adapter instanceof IBSItemProvider)) continue;
                ((IBSItemProvider)adapter).setRolledUp(false);
            }
        }
    }

    public GraphicalData getGraphicalData() {
        return this.graphicalData;
    }

    public void setGraphicalData(GraphicalData data) {
        this.graphicalData = data;
    }

    @Override
    public String getAttribute(Object object, String property) {
        return ProcessUtil.getAttribute(object, property, this);
    }

    @Override
    public void setAttribute(Object object, String prop, String txt) {
        Activity e = (Activity)object;
        ProcessUtil.setAttribute((WorkBreakdownElement)e, prop, txt);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection collection) {
        if (value instanceof Iteration) {
            ((Iteration)value).setIsRepeatable(Boolean.TRUE);
        }
        return super.createCreateChildCommand(domain, owner, feature, value, index, collection);
    }

    @Override
    public List getListeners() {
        if (this.changeNotifier == null) {
            return null;
        }
        return Collections.unmodifiableList((List)this.changeNotifier);
    }

    @Override
    public PredecessorList getPredecessors() {
        if (this.predecessors == null) {
            this.predecessors = new PredecessorList(TngUtil.getBestAdapterFactory(this.adapterFactory), this.target);
        }
        return this.predecessors;
    }

    @Override
    public boolean isFirstElement(Object obj) {
        return ProcessUtil.isFirstElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, obj);
    }

    @Override
    public boolean isLastElement(Object obj) {
        return ProcessUtil.isLastElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, obj);
    }

    @Override
    public void moveUp(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveUp((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
    }

    @Override
    public void moveDown(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveDown((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection, int index) {
        return new ActivityAddCommand((Command)((AddCommand)super.createAddCommand(domain, owner, feature, collection, index)));
    }

    public Object getImage(Object object) {
        Object img = TngUtil.getImage(object);
        return img != null ? img : super.getImage(object);
    }

    public IFilter getChildFilter() {
        return this.childFilter;
    }

    public void setRefreshAllIDsRequired(boolean b) {
        this.refreshAllIDsRequired = b;
    }

    public boolean isRefreshAllIDsRequired() {
        return this.refreshAllIDsRequired;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IFilter filter) {
        this.filter = filter;
        this.configurator = filter instanceof IConfigurator ? (IConfigurator)filter : null;
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public IResourceAwareCommand createDropCommand(Object owner, List dropElements) {
        return null;
    }

    public void basicSetRolledUp(boolean b) {
        this.rolledUp = b;
    }

    public boolean isEnableVariabilityInfo() {
        return this.enableVariabilityInfo;
    }

    public void setEnableVariabilityInfo(boolean enableVariabilityInfo) {
        this.enableVariabilityInfo = enableVariabilityInfo;
    }

    protected Command createMoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        return new MoveCommandEx(domain, owner, feature, value, index);
    }

    protected IConfigurator getConfigurator() {
        return this.configurator;
    }

    static class LinkedChildList {
        LinkedChildListNode head;
        LinkedChildListNode last;

        public LinkedChildList(Activity act) {
            this.last = this.head = new LinkedChildListNode(act, null);
        }
    }

    static class LinkedChildListNode {
        LinkedChildListNode prevNode;
        LinkedChildListNode nextNode;
        Object thisItem;
        WorkBreakdownElement globalPresentedAfter;

        LinkedChildListNode(Object item, WorkBreakdownElement globalPresentedAfter) {
            this.thisItem = item;
            this.globalPresentedAfter = globalPresentedAfter;
        }
    }

    private class MoveCommandEx
    extends MoveCommand
    implements IResourceAwareCommand {
        private Set<Resource> modifiedResources;

        public MoveCommandEx(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
            super(domain, owner, feature, value, index);
        }

        public void doExecute() {
            List children = (List)BSActivityItemProvider.this.getChildren(BSActivityItemProvider.this.getTarget());
            Object child = children.get(this.index);
            this.index = this.ownerList.indexOf(child);
            if (this.index != -1) {
                super.doExecute();
            }
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                Resource resource = this.owner.eResource();
                this.modifiedResources = resource != null ? Collections.singleton(resource) : Collections.EMPTY_SET;
            }
            return this.modifiedResources;
        }
    }
}

