/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class ComposedWPDescriptorWrapperItemProvider
extends WorkProductDescriptorWrapperItemProvider {
    private List notifiers;

    public ComposedWPDescriptorWrapperItemProvider(Object value, Object owner, AdapterFactory adapterFactory) {
        super(value, owner, adapterFactory);
        if (value instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)value;
            this.readOnly = wrapper.isReadOnly();
            this.isInherited = wrapper.isInherited;
        }
        this.isRollupChild = true;
    }

    public void addWorkProductDescriptor(Object object) {
        Adapter itemProvider;
        WorkProductDescriptor wpd = (WorkProductDescriptor)TngUtil.unwrap(object);
        WorkProductDescriptor delegateWpd = (WorkProductDescriptor)TngUtil.unwrap(this.getDelegateValue());
        if (delegateWpd == wpd) {
            return;
        }
        MethodElement wp = ProcessUtil.getAssociatedElement((Descriptor)delegateWpd);
        if ((wp == null || wp == wpd.getWorkProduct()) && (itemProvider = this.getRootAdapterFactory().adapt((Notifier)wpd, IStructuredItemContentProvider.class)) instanceof IChangeNotifier) {
            ((IChangeNotifier)itemProvider).addListener((INotifyChangedListener)this);
            if (this.notifiers == null) {
                this.notifiers = new UniqueEList();
            }
            this.notifiers.add(itemProvider);
        }
        if (this.isInherited && object instanceof BreakdownElementWrapperItemProvider && !((BreakdownElementWrapperItemProvider)object).isInherited) {
            this.isInherited = false;
        }
    }

    public void dispose() {
        if (this.notifiers != null) {
            for (IChangeNotifier notifier : this.notifiers) {
                notifier.removeListener((INotifyChangedListener)this);
            }
            this.notifiers.clear();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        if (this.notifiers != null && this.notifiers.contains(notification.getNotifier())) {
            switch (notification.getEventType()) {
                case 8: {
                    if (notification.getOldValue() != this) break;
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this, false, true));
                    return;
                }
                case 1: {
                    switch (notification.getFeatureID(WorkProductDescriptor.class)) {
                        case 34: 
                        case 35: {
                            this.fireNotifyChanged(this.wrapNotification(notification));
                            return;
                        }
                    }
                }
            }
        }
        super.notifyChanged(notification);
    }

    public String getAttribute(Object object, String property) {
        if (property == "model_info" && this.getValue() instanceof ComposedBreakdownElementWrapperItemProvider) {
            String info = ((ComposedBreakdownElementWrapperItemProvider)this.getValue()).getAttribute(object, property);
            if (!StrUtil.isBlank((String)info)) {
                StringTokenizer tokens = new StringTokenizer(info, ",");
                HashSet<String> infoSet = new HashSet<String>();
                StringBuffer infos = new StringBuffer();
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (!infoSet.add(token)) continue;
                    infos.append(token).append(',');
                }
                infos.deleteCharAt(infos.length() - 1);
                info = infos.toString();
            }
            return info;
        }
        if (!(this.notifiers == null || this.notifiers.isEmpty() || property != "entry_state" && property != "exit_state")) {
            StringBuffer strbuf = new StringBuffer();
            String str = super.getAttribute(object, property);
            if (!StrUtil.isBlank((String)str)) {
                strbuf.append(str);
            }
            for (WorkProductDescriptorItemProvider itemProvider : this.notifiers) {
                str = itemProvider.getAttribute(itemProvider.getTarget(), property);
                if (StrUtil.isBlank((String)str)) continue;
                if (strbuf.length() > 0) {
                    strbuf.append(',');
                }
                strbuf.append(str);
            }
            return strbuf.toString();
        }
        return super.getAttribute(object, property);
    }
}

