/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.command.GenericDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDragAndDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;

public class TeamProfileItemProvider
extends BreakdownElementItemProvider {
    private GenericDropCommand.ElementAdapter dropAdapter;

    public TeamProfileItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTeamProfile_SubTeam(), UmaFactory.eINSTANCE.createTeamProfile()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTeamProfile_SubTeam());
        }
        return this.childrenFeatures;
    }

    public IResourceAwareCommand createDropCommand(Object owner, List dropElements) {
        return new GenericDropCommand((EObject)((TeamProfile)owner), (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), dropElements, this.getDropAdapter(owner));
    }

    private GenericDropCommand.ElementAdapter getDropAdapter(Object owner) {
        BreakdownElementItemProvider adapter = (BreakdownElementItemProvider)this.adapterFactory.adapt(owner, IEditingDomainItemProvider.class);
        return adapter.createDropAdapter();
    }

    public Collection getChildren(Object object) {
        Collection children = super.getChildren(object);
        IFilter filter = ProcessUtil.getFilter(this.adapterFactory);
        boolean nullFilter = filter == null;
        TeamProfile teamProfile = (TeamProfile)object;
        for (RoleDescriptor desc : teamProfile.getTeamRoles()) {
            if (desc.getSuperActivities() != null || !nullFilter && !filter.accept(desc)) continue;
            children.add(desc);
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            ProcessUtil.setParent(iter.next(), object, this.getRootAdapterFactory());
        }
        return children;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TeamProfile.class)) {
            case 33: {
                int eventType = notification.getEventType();
                if (eventType == 3 || eventType == 5) {
                    List subTeams = ProcessUtil.getAffectedElements(notification, null);
                    for (TeamProfile subTeam : subTeams) {
                        ProcessUtil.addToContainer((BreakdownElement)subTeam, (ItemProviderAdapter)this);
                    }
                }
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
            case 31: {
                List elements = ProcessUtil.getAffectedElements(notification, null);
                int eventType = notification.getEventType();
                boolean refreshTeam = false;
                for (BreakdownElement e : elements) {
                    if (eventType == 3 || eventType == 5) {
                        ProcessUtil.addToContainer(e, (ItemProviderAdapter)this, false);
                    }
                    if (e.getSuperActivities() == null) {
                        refreshTeam = true;
                        continue;
                    }
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)e, false, true));
                }
                if (refreshTeam) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                }
                return;
            }
            case 2: {
                TeamProfile teamProfile = (TeamProfile)notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)teamProfile, false, true));
                for (RoleDescriptor roleDescriptor : teamProfile.getTeamRoles()) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)roleDescriptor, false, true));
                }
                return;
            }
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection getEClasses() {
        return ProcessUtil.getOBSEclasses();
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        return new OBSDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    private boolean descriptorExists(Object role) {
        TeamProfile teamProfile = (TeamProfile)this.getTarget();
        for (RoleDescriptor desc : teamProfile.getTeamRoles()) {
            if (desc.getRole() != role) continue;
            return true;
        }
        return false;
    }

    public GenericDropCommand.ElementAdapter createDropAdapter() {
        if (this.dropAdapter == null) {
            this.dropAdapter = new GenericDropCommand.ElementAdapter(){

                public Object adapt(Object dropElement) {
                    if (dropElement instanceof Role && !TeamProfileItemProvider.this.descriptorExists(dropElement)) {
                        return ProcessUtil.createRoleDescriptor((Role)dropElement);
                    }
                    return null;
                }
            };
        }
        return this.dropAdapter;
    }

    public String getAttribute(Object object, String property) {
        if (property == "teams") {
            return TngUtil.getPresentationName(((TeamProfile)object).getSuperTeam());
        }
        return super.getAttribute(object, property);
    }

    public void moveUp(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveUp((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof TeamProfile) {
            TeamProfile team = (TeamProfile)parent;
            List list = team.getSubTeam();
            int location = 0;
            int i = 0;
            while (i < list.size()) {
                if (obj.equals(list.get(i))) {
                    location = i;
                    break;
                }
                ++i;
            }
            ((EList)team.getSubTeam()).move(location, location - 1);
            Activity activity = this.getActivity(obj);
            TngUtil.moveUp(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    public void moveDown(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveDown((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof TeamProfile) {
            TeamProfile team = (TeamProfile)parent;
            List list = team.getSubTeam();
            int location = 0;
            int i = 0;
            while (i < list.size()) {
                if (obj.equals(list.get(i))) {
                    location = i;
                    break;
                }
                ++i;
            }
            ((EList)team.getSubTeam()).move(location, location + 1);
            Activity activity = this.getActivity(obj);
            TngUtil.moveDown(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    public Activity getActivity(Object object) {
        Object parent = this.getParent(object);
        while (parent != null) {
            if (parent instanceof Activity) {
                return (Activity)parent;
            }
            AdapterFactory aFactory = TngUtil.getBestAdapterFactory(this.adapterFactory);
            ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt(parent, ITreeItemContentProvider.class);
            parent = adapter.getParent(parent);
        }
        return null;
    }
}

