/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.DescriptorItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.WorkProductDescriptorCreateCopyCommand;
import org.eclipse.epf.library.edit.process.consolidated.ActivityItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

public class WorkProductDescriptorItemProvider
extends DescriptorItemProvider
implements ICachedChildrenItemProvider {
    protected Collection cachedChildren;

    public WorkProductDescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    public Activity getActivity(Object object) {
        Object parent = this.getParent(object);
        while (parent != null) {
            if (parent instanceof Activity) {
                return (Activity)parent;
            }
            AdapterFactory aFactory = this.getRootAdapterFactory();
            ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt(parent, ITreeItemContentProvider.class);
            parent = adapter.getParent(parent);
        }
        return null;
    }

    private Object getDescriptor(Activity activity, Artifact artifact) {
        if (activity == null) {
            return null;
        }
        List list = activity.getBreakdownElements();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof WorkProductDescriptor && artifact == ((WorkProductDescriptor)obj).getWorkProduct()) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public Collection getChildrenFeatures(Object object) {
        return Collections.EMPTY_LIST;
    }

    private void updateCachedChildren(Collection children) {
    }

    protected void addContainedArtifactDescriptors(WorkProductDescriptor wpDesc, Collection children, MethodConfiguration config) {
        Activity activity = UmaUtil.getParentActivity((BreakdownElement)wpDesc);
        if (activity != null) {
            int size;
            List list;
            Artifact artifact = (Artifact)wpDesc.getWorkProduct();
            List list2 = list = config == null ? null : LibraryEditUtil.getInstance().calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), config);
            if (list == null) {
                list = artifact.getContainedArtifacts();
            }
            if ((size = list.size()) > 0) {
                ArrayList<Object> artifactDescriptors = new ArrayList<Object>();
                int i = 0;
                while (i < size) {
                    Object descriptor = this.getDescriptor(activity, (Artifact)list.get(i));
                    if (descriptor != null) {
                        artifactDescriptors.add(descriptor);
                    }
                    ++i;
                }
                if (!artifactDescriptors.isEmpty()) {
                    Collections.sort(artifactDescriptors, Comparators.PRESENTATION_NAME_COMPARATOR);
                    children.addAll(artifactDescriptors);
                }
            }
        }
    }

    private IFilter getFilter(Object obj) {
        IFilter filter = null;
        Object parent = this.getParent(obj);
        IBSItemProvider adapter = (IBSItemProvider)this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class);
        if (adapter instanceof ActivityItemProvider) {
            filter = ((ActivityItemProvider)adapter).getFilter();
        }
        return filter;
    }

    public Collection getChildren(Object object) {
        Object parent;
        WorkProductDescriptor wpDesc = (WorkProductDescriptor)object;
        if (!(wpDesc.getWorkProduct() instanceof Deliverable) && (parent = TngUtil.unwrap(this.getParent(object))) instanceof WorkProductDescriptor && ((WorkProductDescriptor)parent).getWorkProduct() instanceof Deliverable) {
            this.updateCachedChildren(Collections.EMPTY_LIST);
            return Collections.EMPTY_LIST;
        }
        Collection children = super.getChildren(object);
        if (!wpDesc.getDeliverableParts().isEmpty()) {
            for (WorkProductDescriptor desc : wpDesc.getDeliverableParts()) {
                if (desc.getSuperActivities() != null && !ProcessUtil.isSynFree()) continue;
                children.add(desc);
            }
        }
        IFilter filter = this.getFilter(object);
        MethodConfiguration config = null;
        if (filter == null) {
            filter = ProcessUtil.getFilter(this.adapterFactory);
        }
        if (filter instanceof IConfigurator) {
            config = ((IConfigurator)filter).getMethodConfiguration();
        }
        if (wpDesc.getWorkProduct() instanceof Artifact) {
            this.addContainedArtifactDescriptors(wpDesc, children, config);
        }
        AdapterFactory aFactory = this.getRootAdapterFactory();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IBSItemProvider adapter = (IBSItemProvider)aFactory.adapt(iter.next(), ITreeItemContentProvider.class);
            adapter.setParent(object);
        }
        this.updateCachedChildren(children);
        return children;
    }

    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    public Collection getRollupChildrenFromCache() {
        return Collections.EMPTY_LIST;
    }

    public void dispose() {
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(WorkProductDescriptor.class)) {
            case 34: 
            case 35: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 39: {
                List elements = ProcessUtil.getAffectedElements(notification, null);
                int eventType = notification.getEventType();
                boolean refresh = false;
                for (BreakdownElement e : elements) {
                    if (eventType == 3 || eventType == 5) {
                        ProcessUtil.addToContainer(e, (ItemProviderAdapter)this, false);
                    }
                    if (e.getSuperActivities() != null) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)e, false, true));
                        continue;
                    }
                    refresh = true;
                }
                if (refresh) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                }
                return;
            }
            case 2: {
                WorkProductDescriptor wpd = (WorkProductDescriptor)notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)wpd, false, true));
                if (wpd.getWorkProduct() instanceof Deliverable) {
                    for (Object descriptor : wpd.getDeliverableParts()) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, descriptor, false, true));
                    }
                }
                return;
            }
            case 7: {
                WorkProduct wp;
                Object notifier = notification.getNotifier();
                boolean contentRefresh = notifier instanceof WorkProductDescriptor && ((wp = ((WorkProductDescriptor)notifier).getWorkProduct()) instanceof Artifact || wp instanceof Deliverable);
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), contentRefresh, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void setAttribute(Object object, String prop, String txt) {
        WorkProductDescriptor wpd = (WorkProductDescriptor)object;
        if (prop == "entry_state") {
            wpd.setActivityEntryState(txt);
        } else if (prop == "exit_state") {
            wpd.setActivityExitState(txt);
        } else {
            super.setAttribute(object, prop, txt);
        }
    }

    public Collection getEClasses() {
        return ProcessUtil.getPBSEclasses();
    }

    public void moveUp(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveUp((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof WorkProductDescriptor) {
            WorkProduct wp = ((WorkProductDescriptor)parent).getWorkProduct();
            if (wp instanceof Artifact) {
                Artifact artifact = (Artifact)wp;
                List list = artifact.getContainedArtifacts();
                WorkProduct objWP = ((WorkProductDescriptor)obj).getWorkProduct();
                int location = 0;
                int i = 0;
                while (i < list.size()) {
                    if (objWP.equals(list.get(i))) {
                        location = i;
                        break;
                    }
                    ++i;
                }
                ((EList)artifact.getContainedArtifacts()).move(location, location - 1);
            }
            Activity activity = this.getActivity(obj);
            TngUtil.moveUp(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    public void moveDown(Object obj, IActionManager actionMgr) {
        Object parent = this.getParent(obj);
        if (parent != null && parent instanceof Activity) {
            TngUtil.moveDown((Activity)parent, obj, this.getEClasses(), actionMgr);
        }
        if (parent != null && parent instanceof WorkProductDescriptor) {
            WorkProduct wp = ((WorkProductDescriptor)parent).getWorkProduct();
            if (wp instanceof Artifact) {
                Artifact artifact = (Artifact)wp;
                List list = artifact.getContainedArtifacts();
                WorkProduct objWP = ((WorkProductDescriptor)obj).getWorkProduct();
                int location = 0;
                int i = 0;
                while (i < list.size()) {
                    if (objWP.equals(list.get(i))) {
                        location = i;
                        break;
                    }
                    ++i;
                }
                ((EList)artifact.getContainedArtifacts()).move(location, location + 1);
            }
            Activity activity = this.getActivity(obj);
            TngUtil.moveDown(activity, obj, this.getEClasses(), actionMgr);
        }
    }

    protected Command createCreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new WorkProductDescriptorCreateCopyCommand(domain, owner, helper);
    }

    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        Activity act;
        if (!(commandParameter.getOwner() instanceof Activity) && (act = this.getActivity(this.target)) != null) {
            IEditingDomainItemProvider adapter = (IEditingDomainItemProvider)this.adapterFactory.adapt((Notifier)act, IEditingDomainItemProvider.class);
            commandParameter.setOwner((Object)act);
            return adapter.createCommand((Object)act, domain, RemoveCommand.class, commandParameter);
        }
        return super.factorRemoveCommand(domain, commandParameter);
    }

    public String getAttribute(Object object, String property) {
        if (property == "model_info") {
            StringBuffer modelInfo = new StringBuffer();
            if (object instanceof WorkProductDescriptor) {
                ProcessUtil.getWPDModelInfo(modelInfo, object, this);
            }
            return modelInfo.toString();
        }
        return super.getAttribute(object, property);
    }

    protected boolean hasChildren(Object object, boolean optimized) {
        boolean b = super.hasChildren(object, optimized);
        return b;
    }
}

