/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGuidanceToBreakdownElementCommand
extends AddMethodElementCommand {
    private List<Guidance> guidances;
    private BreakdownElement brElement;
    private Collection modifiedResources;
    private boolean calledForExculded = false;
    private Set<Practice> affectedSet = new HashSet<Practice>();
    private DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();

    public AddGuidanceToBreakdownElementCommand(BreakdownElement brElement, List<Guidance> guidances) {
        this(brElement, guidances, false);
    }

    public AddGuidanceToBreakdownElementCommand(BreakdownElement brElement, List<Guidance> guidances, boolean calledForExculded) {
        super(TngUtil.getOwningProcess(brElement));
        this.guidances = guidances;
        this.brElement = brElement;
        this.calledForExculded = calledForExculded;
        this.modifiedResources = new HashSet();
    }

    @Override
    public void execute() {
        if (!super.addToDefaultConfiguration(this.guidances)) {
            return;
        }
        this.redo();
    }

    @Override
    public void redo() {
        block21: {
            block22: {
                TaskDescriptor greenParent;
                ArrayList<Practice> utdItems = new ArrayList<Practice>();
                if (this.guidances.isEmpty()) break block21;
                for (Guidance obj : this.guidances) {
                    if (!(obj instanceof Guidance)) continue;
                    Guidance item = obj;
                    if (item instanceof Checklist) {
                        this.brElement.getChecklists().add((Checklist)item);
                        continue;
                    }
                    if (item instanceof Concept) {
                        this.brElement.getConcepts().add((Concept)item);
                        continue;
                    }
                    if (item instanceof Example) {
                        this.brElement.getExamples().add((Example)item);
                        continue;
                    }
                    if (item instanceof SupportingMaterial) {
                        this.brElement.getSupportingMaterials().add((SupportingMaterial)item);
                        continue;
                    }
                    if (item instanceof Guideline) {
                        this.brElement.getGuidelines().add((Guideline)item);
                        continue;
                    }
                    if (item instanceof ReusableAsset) {
                        this.brElement.getReusableAssets().add((ReusableAsset)item);
                        continue;
                    }
                    if (item instanceof Template) {
                        this.brElement.getTemplates().add((Template)item);
                        continue;
                    }
                    if (item instanceof Report) {
                        this.brElement.getReports().add((Report)item);
                        continue;
                    }
                    if (item instanceof EstimationConsiderations) {
                        this.brElement.getEstimationconsiderations().add((EstimationConsiderations)item);
                        continue;
                    }
                    if (item instanceof ToolMentor) {
                        this.brElement.getToolmentor().add((ToolMentor)item);
                        continue;
                    }
                    if (item instanceof Roadmap) {
                        if (!(this.brElement instanceof Activity)) continue;
                        ((Activity)this.brElement).getRoadmaps().add((Roadmap)item);
                        continue;
                    }
                    if (item instanceof Practice) {
                        if (!PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)item))) continue;
                        utdItems.add((Practice)item);
                        continue;
                    }
                    LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
                }
                List<Practice> listValue = this.propUtil.getUdtList((MethodElement)this.brElement, true);
                if (listValue != null && !utdItems.isEmpty()) {
                    for (Practice p : utdItems) {
                        if (listValue.contains(p) || !listValue.add(p)) continue;
                        this.affectedSet.add(p);
                        this.propUtil.addOpposite(ExtendReferenceMap.UdtList, (MethodElement)this.brElement, (MethodElement)p);
                    }
                    try {
                        this.propUtil.storeReferences((MethodElement)this.brElement, false);
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
                if (!this.propUtil.isDescriptor(this.brElement) || !ProcessUtil.isSynFree()) break block21;
                if (!this.calledForExculded) break block22;
                ((Descriptor)this.brElement).getGuidanceExclude().removeAll(this.guidances);
                if (!(this.brElement instanceof TaskDescriptor) || (greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)((TaskDescriptor)this.brElement))) == null) break block21;
                EReference eRef = UmaPackage.eINSTANCE.getDescriptor_GuidanceExclude();
                List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                for (Guidance guidance : this.guidances) {
                    this.propUtil.getGuidanceEReference(guidance);
                    this.propUtil.removeGreenRefDelta((Descriptor)((TaskDescriptor)this.brElement), (MethodElement)guidance, eRef, true);
                    if (parentExecludeList == null || !parentExecludeList.contains(guidance)) continue;
                    this.propUtil.addGreenRefDelta((Descriptor)((TaskDescriptor)this.brElement), (MethodElement)guidance, eRef, false);
                }
                break block21;
            }
            if (ProcessUtil.isSynFree()) {
                Descriptor des = (Descriptor)this.brElement;
                des.getGuidanceAdditional().addAll(this.guidances);
                Descriptor greenParent = this.propUtil.getGreenParentDescriptor(des);
                if (greenParent != null) {
                    EReference aRef = UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional();
                    List parentAdditionalList = (List)greenParent.eGet((EStructuralFeature)aRef);
                    for (Guidance guidance : this.guidances) {
                        this.propUtil.removeGreenRefDelta(des, (MethodElement)guidance, aRef, false);
                        if (parentAdditionalList != null && parentAdditionalList.contains(guidance)) continue;
                        this.propUtil.addGreenRefDelta(des, (MethodElement)guidance, aRef, true);
                    }
                }
            }
        }
    }

    @Override
    public void undo() {
        if (!this.guidances.isEmpty()) {
            super.undo();
            for (Guidance obj : this.guidances) {
                if (!(obj instanceof Guidance)) continue;
                Guidance item = obj;
                if (item instanceof Checklist) {
                    this.brElement.getChecklists().remove(item);
                    continue;
                }
                if (item instanceof Concept) {
                    this.brElement.getConcepts().remove(item);
                    continue;
                }
                if (item instanceof Example) {
                    this.brElement.getExamples().remove(item);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.brElement.getSupportingMaterials().remove(item);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.brElement.getGuidelines().remove(item);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.brElement.getReusableAssets().remove(item);
                    continue;
                }
                if (item instanceof Template) {
                    this.brElement.getTemplates().remove((Template)item);
                    continue;
                }
                if (item instanceof Report) {
                    this.brElement.getReports().remove((Report)item);
                    continue;
                }
                if (item instanceof EstimationConsiderations) {
                    this.brElement.getEstimationconsiderations().remove((EstimationConsiderations)item);
                    continue;
                }
                if (item instanceof ToolMentor) {
                    this.brElement.getToolmentor().remove((ToolMentor)item);
                    continue;
                }
                if (item instanceof Roadmap) {
                    if (!(this.brElement instanceof Activity)) continue;
                    ((Activity)this.brElement).getRoadmaps().remove((Roadmap)item);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
            if (this.propUtil.isDescriptor(this.brElement) && ProcessUtil.isSynFree()) {
                if (this.calledForExculded) {
                    TaskDescriptor greenParent;
                    ((Descriptor)this.brElement).getGuidanceExclude().addAll(this.guidances);
                    if (this.brElement instanceof TaskDescriptor && (greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)((TaskDescriptor)this.brElement))) != null) {
                        EReference eRef = UmaPackage.eINSTANCE.getDescriptor_GuidanceExclude();
                        List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                        for (Guidance guidance : this.guidances) {
                            this.propUtil.getGuidanceEReference(guidance);
                            this.propUtil.removeGreenRefDelta((Descriptor)((TaskDescriptor)this.brElement), (MethodElement)guidance, eRef, true);
                            if (parentExecludeList == null || !parentExecludeList.contains(guidance)) continue;
                            this.propUtil.addGreenRefDelta((Descriptor)((TaskDescriptor)this.brElement), (MethodElement)guidance, eRef, false);
                        }
                    }
                } else if (ProcessUtil.isSynFree()) {
                    Descriptor des = (Descriptor)this.brElement;
                    des.getGuidanceAdditional().removeAll(this.guidances);
                    Descriptor greenParent = this.propUtil.getGreenParentDescriptor(des);
                    if (greenParent != null) {
                        EReference aRef = UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional();
                        List parentAdditionalList = (List)greenParent.eGet((EStructuralFeature)aRef);
                        for (Guidance guidance : this.guidances) {
                            this.propUtil.removeGreenRefDelta(des, (MethodElement)guidance, aRef, true);
                            if (parentAdditionalList == null || !parentAdditionalList.contains(guidance)) continue;
                            this.propUtil.addGreenRefDelta(des, (MethodElement)guidance, aRef, false);
                        }
                    }
                }
            }
        }
        try {
            for (Practice p : this.affectedSet) {
                this.propUtil.removeOpposite(ExtendReferenceMap.UdtList, (MethodElement)this.brElement, (MethodElement)p);
            }
            this.propUtil.storeReferences((MethodElement)this.brElement, true);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected boolean prepare() {
        return true;
    }

    @Override
    public Collection getModifiedResources() {
        if (!this.guidances.isEmpty() && this.brElement.eResource() != null) {
            this.modifiedResources.add(this.brElement.eResource());
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.brElement != null) {
            return Arrays.asList(this.brElement);
        }
        return super.getAffectedObjects();
    }
}

