/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;

public class AddRoleToTeamCommand
extends AddMethodElementCommand {
    private List roles;
    private List roleDescList;
    private Activity activity;
    private TeamProfile team;
    private Collection modifiedResources;
    private List existingRoleDescList;

    public AddRoleToTeamCommand(TeamProfile team, List roles) {
        super(TngUtil.getOwningProcess((BreakdownElement)team));
        this.roles = roles;
        this.team = team;
        this.activity = (Activity)ProcessUtil.getParentActivityOfTeam((BreakdownElement)team);
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.roles)) {
            return;
        }
        this.roleDescList = new ArrayList();
        Iterator itor = this.roles.iterator();
        while (itor.hasNext()) {
            RoleDescriptor roleDesc = ProcessUtil.createRoleDescriptor((Role)itor.next());
            this.roleDescList.add(roleDesc);
        }
        this.existingRoleDescList = new ArrayList();
        ProcessUtil.getRoleDescriptor((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), this.activity, this.existingRoleDescList, this.roles);
        this.redo();
    }

    public void redo() {
        Iterator itor;
        if (!this.roleDescList.isEmpty()) {
            itor = this.roleDescList.iterator();
            while (itor.hasNext()) {
                this.team.getTeamRoles().add((RoleDescriptor)itor.next());
            }
        }
        if (!this.existingRoleDescList.isEmpty()) {
            itor = this.existingRoleDescList.iterator();
            while (itor.hasNext()) {
                this.team.getTeamRoles().add((RoleDescriptor)itor.next());
            }
        }
    }

    public void undo() {
        Iterator itor;
        if (!this.roleDescList.isEmpty()) {
            super.undo();
            itor = this.roleDescList.iterator();
            while (itor.hasNext()) {
                this.team.getTeamRoles().remove((RoleDescriptor)itor.next());
            }
        }
        if (!this.existingRoleDescList.isEmpty()) {
            itor = this.existingRoleDescList.iterator();
            while (itor.hasNext()) {
                this.team.getTeamRoles().remove((RoleDescriptor)itor.next());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.roles != null && !this.roles.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.team.eResource() != null) {
                this.modifiedResources.add(this.team.eResource());
            }
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.roleDescList != null) {
            return this.roleDescList;
        }
        return super.getAffectedObjects();
    }
}

