/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;

public class AssignRoleToTaskDescriptor
extends AddMethodElementCommand {
    private List roles;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private Collection affectedObjects;
    private int action;
    List existingRoleDescList = new ArrayList();
    List newRoleDescList = new ArrayList();
    private HashMap map = new HashMap();
    private MethodConfiguration config;
    private boolean isNewRoleDescriptor = false;
    private boolean calledForExculded = false;
    private DescriptorPropUtil propUtil;

    public AssignRoleToTaskDescriptor(TaskDescriptor taskDesc, List roles, int action, MethodConfiguration config) {
        this(taskDesc, roles, action, config, false);
    }

    public AssignRoleToTaskDescriptor(TaskDescriptor taskDesc, List roles, int action, MethodConfiguration config, boolean calledForExculded) {
        super(TngUtil.getOwningProcess((BreakdownElement)taskDesc));
        this.calledForExculded = calledForExculded;
        this.roles = roles;
        this.taskDesc = taskDesc;
        this.action = action;
        this.config = config;
        this.propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)taskDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)taskDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        this.affectedObjects = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.roles)) {
            return;
        }
        for (Role role : this.roles) {
            RoleDescriptor roleDesc = null;
            this.isNewRoleDescriptor = false;
            roleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, this.activity, this.config);
            if (roleDesc == null && (roleDesc = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, this.activity, this.config)) == null) {
                roleDesc = ProcessUtil.createRoleDescriptor(role);
                this.isNewRoleDescriptor = true;
            }
            if (this.isNewRoleDescriptor) {
                this.newRoleDescList.add(roleDesc);
            } else {
                this.existingRoleDescList.add(roleDesc);
            }
            TeamProfile team = UserInteractionHelper.getTeam(this.activity, role);
            if (team == null) continue;
            this.map.put(roleDesc, team);
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 0) {
            this.taskDesc.getPerformedPrimarilyBy().addAll(this.existingRoleDescList);
            this.taskDesc.getPerformedPrimarilyBy().addAll(this.newRoleDescList);
        } else if (this.action == 1) {
            this.taskDesc.getAdditionallyPerformedBy().addAll(this.existingRoleDescList);
            this.taskDesc.getAdditionallyPerformedBy().addAll(this.newRoleDescList);
        } else if (this.action == 2) {
            this.taskDesc.getAssistedBy().addAll(this.existingRoleDescList);
            this.taskDesc.getAssistedBy().addAll(this.newRoleDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                TaskDescriptor greenParent;
                List excludedList = null;
                Object ref = null;
                if (this.action == 0) {
                    excludedList = this.taskDesc.getPerformedPrimarilyByExcluded();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy();
                } else if (this.action == 1) {
                    excludedList = this.taskDesc.getAdditionallyPerformedByExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy();
                }
                if (excludedList != null) {
                    excludedList.removeAll(this.roles);
                }
                if ((greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)this.taskDesc)) != null) {
                    EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature((EReference)ref);
                    List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                    for (Role role : this.roles) {
                        this.propUtil.removeGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)role, eRef, true);
                        if (parentExecludeList == null || !parentExecludeList.contains(role)) continue;
                        this.propUtil.addGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)role, eRef, false);
                    }
                }
            } else {
                this.propUtil.addLocalUsingInfo(this.existingRoleDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
                this.propUtil.addLocalUsingInfo(this.newRoleDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
            }
            for (RoleDescriptor rd : this.newRoleDescList) {
                this.propUtil.setCreatedByReference((Descriptor)rd, true);
            }
        }
        this.activity.getBreakdownElements().addAll(this.newRoleDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                TeamProfile team = (TeamProfile)this.map.get(key);
                team.getTeamRoles().add((RoleDescriptor)key);
            }
        }
    }

    private EReference getFeature(int action) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (action == 0) {
            return up.getTaskDescriptor_PerformedPrimarilyBy();
        }
        if (action == 1) {
            return up.getTaskDescriptor_AdditionallyPerformedBy();
        }
        if (action == 2) {
            return up.getTaskDescriptor_AssistedBy();
        }
        return null;
    }

    public void undo() {
        super.undo();
        if (this.action == 1) {
            this.taskDesc.getPerformedPrimarilyBy().removeAll(this.existingRoleDescList);
            this.taskDesc.getPerformedPrimarilyBy().removeAll(this.newRoleDescList);
        } else if (this.action == 1) {
            this.taskDesc.getAdditionallyPerformedBy().removeAll(this.existingRoleDescList);
            this.taskDesc.getAdditionallyPerformedBy().removeAll(this.newRoleDescList);
        } else if (this.action == 2) {
            this.taskDesc.getAssistedBy().removeAll(this.existingRoleDescList);
            this.taskDesc.getAssistedBy().removeAll(this.newRoleDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                TaskDescriptor greenParent;
                List excludedList = null;
                EReference ref = null;
                if (this.action == 0) {
                    excludedList = this.taskDesc.getPerformedPrimarilyByExcluded();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy();
                } else if (this.action == 1) {
                    excludedList = this.taskDesc.getAdditionallyPerformedByExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy();
                }
                if (excludedList != null) {
                    excludedList.addAll(this.roles);
                }
                if ((greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)this.taskDesc)) != null) {
                    EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(ref);
                    List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                    for (Role role : this.roles) {
                        this.propUtil.addGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)role, eRef, true);
                        if (parentExecludeList == null || !parentExecludeList.contains(role)) continue;
                        this.propUtil.removeGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)role, eRef, false);
                    }
                }
            } else {
                this.propUtil.removeLocalUsingInfo(this.existingRoleDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
                this.propUtil.removeLocalUsingInfo(this.newRoleDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
            }
        }
        this.activity.getBreakdownElements().removeAll(this.newRoleDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                TeamProfile team = (TeamProfile)this.map.get(key);
                team.getTeamRoles().remove((RoleDescriptor)key);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.roles != null && !this.roles.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.taskDesc.eResource() != null) {
                this.modifiedResources.add(this.taskDesc.eResource());
            }
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.roles != null && !this.roles.isEmpty()) {
            this.affectedObjects.add(this.activity);
            this.affectedObjects.add(this.taskDesc);
            return this.affectedObjects;
        }
        return super.getAffectedObjects();
    }
}

