/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class AssignWPToMilestone
extends AddMethodElementCommand {
    private List workProducts;
    private Activity activity;
    private Milestone milestone;
    private Collection modifiedResources;
    private HashMap map = new HashMap();
    private int action;
    List existingWPDescList = new ArrayList();
    List newWPDescList = new ArrayList();
    private MethodConfiguration config;

    public AssignWPToMilestone(Milestone milestone, List workProducts, int action, MethodConfiguration config) {
        super(TngUtil.getOwningProcess((BreakdownElement)milestone));
        this.workProducts = workProducts;
        this.milestone = milestone;
        this.action = action;
        this.config = config;
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)milestone, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)milestone);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.workProducts)) {
            return;
        }
        for (WorkProduct wp : this.workProducts) {
            WorkProductDescriptor newWpDesc = null;
            boolean isNewDescriptor = false;
            newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, this.config);
            if (newWpDesc == null && (newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(wp, this.activity, this.config)) == null) {
                newWpDesc = ProcessUtil.createWorkProductDescriptor(wp);
                isNewDescriptor = true;
            }
            if (isNewDescriptor) {
                this.newWPDescList.add(newWpDesc);
            } else {
                this.existingWPDescList.add(newWpDesc);
            }
            WorkProductDescriptor deliverable = UserInteractionHelper.getDeliverable(this.activity, wp);
            if (deliverable == null) continue;
            this.map.put(newWpDesc, deliverable);
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 8) {
            this.milestone.getRequiredResults().addAll(this.existingWPDescList);
            this.milestone.getRequiredResults().addAll(this.newWPDescList);
        }
        this.activity.getBreakdownElements().addAll(this.newWPDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().add((WorkProductDescriptor)key);
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.action == 8) {
            this.milestone.getRequiredResults().removeAll(this.existingWPDescList);
            this.milestone.getRequiredResults().removeAll(this.newWPDescList);
        }
        this.activity.getBreakdownElements().removeAll(this.newWPDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().remove((WorkProductDescriptor)key);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.milestone.eResource() != null) {
                this.modifiedResources.add(this.milestone.eResource());
            }
        }
        return this.modifiedResources;
    }
}

