/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class AssignWPToRoleDescriptor
extends AddMethodElementCommand {
    private List workProducts;
    private Activity activity;
    private RoleDescriptor roleDesc;
    private Collection modifiedResources;
    private Collection affectedObjects;
    private HashMap map = new HashMap();
    private int action;
    List existingWPDescList = new ArrayList();
    List newWPDescList = new ArrayList();
    private MethodConfiguration config;
    private boolean calledForExculded = false;
    private DescriptorPropUtil propUtil;

    public AssignWPToRoleDescriptor(RoleDescriptor roleDesc, List workProducts, int action, MethodConfiguration config) {
        this(roleDesc, workProducts, action, config, false);
    }

    public AssignWPToRoleDescriptor(RoleDescriptor roleDesc, List workProducts, int action, MethodConfiguration config, boolean calledForExculded) {
        super(TngUtil.getOwningProcess((BreakdownElement)roleDesc));
        this.workProducts = workProducts;
        this.roleDesc = roleDesc;
        this.action = action;
        this.config = config;
        this.calledForExculded = calledForExculded;
        this.propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)roleDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)roleDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        this.affectedObjects = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.workProducts)) {
            return;
        }
        for (WorkProduct wp : this.workProducts) {
            WorkProductDescriptor newWpDesc = null;
            boolean isNewDescriptor = false;
            newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, this.config);
            if (newWpDesc == null && (newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(wp, this.activity, this.config)) == null) {
                newWpDesc = ProcessUtil.createWorkProductDescriptor(wp);
                isNewDescriptor = true;
            }
            if (isNewDescriptor) {
                this.newWPDescList.add(newWpDesc);
            } else {
                this.existingWPDescList.add(newWpDesc);
            }
            WorkProductDescriptor deliverable = UserInteractionHelper.getDeliverable(this.activity, wp);
            if (deliverable == null) continue;
            this.map.put(newWpDesc, deliverable);
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 7) {
            this.roleDesc.getResponsibleFor().addAll(this.existingWPDescList);
            this.roleDesc.getResponsibleFor().addAll(this.newWPDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                List excludedList = null;
                if (this.action == 7) {
                    excludedList = this.roleDesc.getResponsibleForExclude();
                }
                if (excludedList != null) {
                    excludedList.removeAll(this.workProducts);
                }
            } else {
                this.propUtil.addLocalUsingInfo(this.existingWPDescList, (Descriptor)this.roleDesc, this.getFeature(this.action));
                this.propUtil.addLocalUsingInfo(this.newWPDescList, (Descriptor)this.roleDesc, this.getFeature(this.action));
            }
            for (WorkProductDescriptor rd : this.newWPDescList) {
                this.propUtil.setCreatedByReference((Descriptor)rd, true);
            }
        }
        this.activity.getBreakdownElements().addAll(this.newWPDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().add((WorkProductDescriptor)key);
            }
        }
    }

    private EReference getFeature(int action) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (action == 7) {
            return up.getRoleDescriptor_ResponsibleFor();
        }
        return null;
    }

    public void undo() {
        super.undo();
        if (this.action == 7) {
            this.roleDesc.getResponsibleFor().removeAll(this.existingWPDescList);
            this.roleDesc.getResponsibleFor().removeAll(this.newWPDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                List excludedList = null;
                if (this.action == 7) {
                    excludedList = this.roleDesc.getResponsibleForExclude();
                }
                if (excludedList != null) {
                    excludedList.addAll(this.workProducts);
                }
            } else {
                this.propUtil.removeLocalUsingInfo(this.existingWPDescList, (Descriptor)this.roleDesc, this.getFeature(this.action));
                this.propUtil.removeLocalUsingInfo(this.newWPDescList, (Descriptor)this.roleDesc, this.getFeature(this.action));
            }
        }
        this.activity.getBreakdownElements().removeAll(this.newWPDescList);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().remove((WorkProductDescriptor)key);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.roleDesc.eResource() != null) {
                this.modifiedResources.add(this.roleDesc.eResource());
            }
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            this.affectedObjects.add(this.activity);
            this.affectedObjects.add(this.roleDesc);
            return this.affectedObjects;
        }
        return super.getAffectedObjects();
    }
}

