/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class AssignWPToTaskDescriptor
extends AddMethodElementCommand {
    private List workProducts;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private Collection affectedObjects;
    private int action;
    private HashMap map = new HashMap();
    List existingWPDescList = new ArrayList();
    List newWPDescList = new ArrayList();
    Collection<WorkProductDescriptor> subartifactDescriptors = new ArrayList<WorkProductDescriptor>();
    private MethodConfiguration config;
    private boolean calledForExculded = false;
    private DescriptorPropUtil propUtil;

    public AssignWPToTaskDescriptor(TaskDescriptor taskDesc, List workProducts, int action, MethodConfiguration config) {
        this(taskDesc, workProducts, action, config, false);
    }

    public AssignWPToTaskDescriptor(TaskDescriptor taskDesc, List workProducts, int action, MethodConfiguration config, boolean calledForExculded) {
        super(TngUtil.getOwningProcess((BreakdownElement)taskDesc));
        this.calledForExculded = calledForExculded;
        this.workProducts = workProducts;
        this.taskDesc = taskDesc;
        this.action = action;
        this.config = config;
        this.propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)taskDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)taskDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        this.affectedObjects = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.workProducts)) {
            return;
        }
        for (WorkProduct wp : this.workProducts) {
            WorkProductDescriptor newWpDesc = null;
            boolean isNewDescriptor = false;
            newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, this.config);
            if (newWpDesc == null && (newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(wp, this.activity, this.config)) == null) {
                newWpDesc = ProcessUtil.createWorkProductDescriptor(wp);
                isNewDescriptor = true;
            }
            if (isNewDescriptor) {
                this.newWPDescList.add(newWpDesc);
            } else {
                this.existingWPDescList.add(newWpDesc);
            }
            WorkProductDescriptor deliverable = UserInteractionHelper.getDeliverable(this.activity, wp);
            if (deliverable == null) continue;
            this.map.put(newWpDesc, deliverable);
        }
        for (Object element : this.workProducts) {
            if (!(element instanceof Artifact)) continue;
            AbstractTreeIterator<Object> iterator = new AbstractTreeIterator<Object>(element, false){
                private static final long serialVersionUID = -4820477887426087262L;

                protected Iterator<?> getChildren(Object object) {
                    Object subArtifacts = Providers.getConfigurationApplicator().getReference((VariabilityElement)object, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), AssignWPToTaskDescriptor.this.config);
                    return ((Collection)subArtifacts).iterator();
                }
            };
            while (iterator.hasNext()) {
                Artifact subArtifact = (Artifact)iterator.next();
                WorkProductDescriptor newWpDesc = null;
                boolean isNewDescriptor = false;
                newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)subArtifact, this.activity, this.config);
                if (newWpDesc == null && (newWpDesc = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(subArtifact, this.activity, this.config)) == null) {
                    newWpDesc = ProcessUtil.createWorkProductDescriptor((WorkProduct)subArtifact);
                    isNewDescriptor = true;
                }
                if (!isNewDescriptor || this.subartifactDescriptors.contains(newWpDesc)) continue;
                this.subartifactDescriptors.add(newWpDesc);
            }
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 3) {
            this.taskDesc.getExternalInput().addAll(this.existingWPDescList);
            this.taskDesc.getExternalInput().addAll(this.newWPDescList);
        } else if (this.action == 4) {
            this.taskDesc.getMandatoryInput().addAll(this.existingWPDescList);
            this.taskDesc.getMandatoryInput().addAll(this.newWPDescList);
        } else if (this.action == 5) {
            this.taskDesc.getOptionalInput().addAll(this.existingWPDescList);
            this.taskDesc.getOptionalInput().addAll(this.newWPDescList);
        } else if (this.action == 6) {
            this.taskDesc.getOutput().addAll(this.existingWPDescList);
            this.taskDesc.getOutput().addAll(this.newWPDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                TaskDescriptor greenParent;
                List excludedList = null;
                Object ref = null;
                if (this.action == 4) {
                    excludedList = this.taskDesc.getMandatoryInputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput();
                } else if (this.action == 5) {
                    excludedList = this.taskDesc.getOptionalInputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput();
                } else if (this.action == 6) {
                    excludedList = this.taskDesc.getOutputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
                }
                if (excludedList != null) {
                    excludedList.removeAll(this.workProducts);
                }
                if ((greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)this.taskDesc)) != null) {
                    EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature((EReference)ref);
                    List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                    for (WorkProduct wp : this.workProducts) {
                        this.propUtil.removeGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)wp, eRef, true);
                        if (parentExecludeList == null || !parentExecludeList.contains(wp)) continue;
                        this.propUtil.addGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)wp, eRef, false);
                    }
                }
            } else {
                this.propUtil.addLocalUsingInfo(this.existingWPDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
                this.propUtil.addLocalUsingInfo(this.newWPDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
            }
            for (WorkProductDescriptor rd : this.newWPDescList) {
                this.propUtil.setCreatedByReference((Descriptor)rd, true);
            }
        }
        this.activity.getBreakdownElements().addAll(this.newWPDescList);
        if (!this.subartifactDescriptors.isEmpty()) {
            this.activity.getBreakdownElements().addAll(this.subartifactDescriptors);
        }
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().add((WorkProductDescriptor)key);
            }
        }
    }

    private EReference getFeature(int action) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (action == 4) {
            return up.getTaskDescriptor_MandatoryInput();
        }
        if (action == 5) {
            return up.getTaskDescriptor_OptionalInput();
        }
        if (action == 6) {
            return up.getTaskDescriptor_Output();
        }
        if (action == 3) {
            return up.getTaskDescriptor_ExternalInput();
        }
        return null;
    }

    public void undo() {
        super.undo();
        if (this.action == 3) {
            this.taskDesc.getExternalInput().removeAll(this.existingWPDescList);
            this.taskDesc.getExternalInput().removeAll(this.newWPDescList);
        } else if (this.action == 4) {
            this.taskDesc.getMandatoryInput().removeAll(this.existingWPDescList);
            this.taskDesc.getMandatoryInput().removeAll(this.newWPDescList);
        } else if (this.action == 5) {
            this.taskDesc.getOptionalInput().removeAll(this.existingWPDescList);
            this.taskDesc.getOptionalInput().removeAll(this.newWPDescList);
        } else if (this.action == 6) {
            this.taskDesc.getOutput().removeAll(this.existingWPDescList);
            this.taskDesc.getOutput().removeAll(this.newWPDescList);
        }
        if (ProcessUtil.isSynFree()) {
            if (this.calledForExculded) {
                TaskDescriptor greenParent;
                List excludedList = null;
                EReference ref = null;
                if (this.action == 4) {
                    excludedList = this.taskDesc.getMandatoryInputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput();
                } else if (this.action == 5) {
                    excludedList = this.taskDesc.getOptionalInputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput();
                } else if (this.action == 6) {
                    excludedList = this.taskDesc.getOutputExclude();
                    ref = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
                }
                if (excludedList != null) {
                    excludedList.addAll(this.workProducts);
                }
                if ((greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)this.taskDesc)) != null) {
                    EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(ref);
                    List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                    for (WorkProduct wp : this.workProducts) {
                        this.propUtil.addGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)wp, eRef, true);
                        if (parentExecludeList == null || !parentExecludeList.contains(wp)) continue;
                        this.propUtil.removeGreenRefDelta((Descriptor)this.taskDesc, (MethodElement)wp, eRef, false);
                    }
                }
            } else {
                this.propUtil.removeLocalUsingInfo(this.existingWPDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
                this.propUtil.removeLocalUsingInfo(this.newWPDescList, (Descriptor)this.taskDesc, this.getFeature(this.action));
            }
        }
        this.activity.getBreakdownElements().removeAll(this.newWPDescList);
        this.activity.getBreakdownElements().removeAll(this.subartifactDescriptors);
        if (this.map != null) {
            Set keyset = this.map.keySet();
            for (Object key : keyset) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.map.get(key);
                wpDesc.getDeliverableParts().remove((WorkProductDescriptor)key);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.taskDesc.eResource() != null) {
                this.modifiedResources.add(this.taskDesc.eResource());
            }
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            this.affectedObjects.add(this.activity);
            this.affectedObjects.add(this.taskDesc);
            return this.affectedObjects;
        }
        return super.getAffectedObjects();
    }
}

