/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.util.UmaUtil;

public class CustomizeDescriptorCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Process proc;
    private BreakdownElementWrapperItemProvider wrapper;
    private Descriptor greenParent;
    private static boolean debug = false;

    public CustomizeDescriptorCommand(BreakdownElementWrapperItemProvider wrapper) {
        this.wrapper = wrapper;
        this.proc = (Process)wrapper.getTopItem();
        Object obj = TngUtil.unwrap(wrapper);
        if (obj instanceof Descriptor) {
            this.greenParent = (Descriptor)obj;
        }
    }

    public BreakdownElementWrapperItemProvider getWrapper() {
        return this.wrapper;
    }

    public Collection getModifiedResources() {
        if (this.proc.eResource() != null) {
            return Collections.singletonList(this.proc.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        Activity parentAct;
        if (this.greenParent == null || !(this.greenParent instanceof TaskDescriptor)) {
            return;
        }
        Object parentObj = this.wrapper.getParent(null);
        Activity activity = parentAct = parentObj instanceof Activity ? (Activity)parentObj : null;
        if (parentAct == null) {
            return;
        }
        if (this.proc != ProcessUtil.getProcess(parentAct)) {
            return;
        }
        TaskDescriptor des = UmaFactory.eINSTANCE.createTaskDescriptor();
        CustomizeDescriptorCommand.updateFromGreenParent(this.greenParent, (Descriptor)des, true);
        parentAct.getBreakdownElements().add(des);
    }

    private static boolean isAttToCopy(EAttribute attribute, boolean newChild) {
        if (!newChild) {
            return false;
        }
        if (!attribute.isChangeable()) {
            return false;
        }
        if (attribute.isDerived()) {
            return false;
        }
        if (attribute == UmaPackage.eINSTANCE.getMethodElement_Guid()) {
            return false;
        }
        return attribute != UmaPackage.eINSTANCE.getNamedElement_Name();
    }

    private static boolean isRefToCopy(EReference ref, boolean newChild) {
        if (!newChild) {
            return false;
        }
        if (!ref.isChangeable()) {
            return false;
        }
        if (ref.isDerived()) {
            return false;
        }
        if (ref == UmaPackage.eINSTANCE.getDescribableElement_Presentation()) {
            return false;
        }
        if (ref == UmaPackage.eINSTANCE.getBreakdownElement_SuperActivities()) {
            return false;
        }
        if (ref == UmaPackage.eINSTANCE.getBreakdownElement_SuperActivities()) {
            return false;
        }
        return ref != UmaPackage.eINSTANCE.getBreakdownElement_PlanningData();
    }

    private static void copyAttributes(MethodElement source, MethodElement target, boolean newChild) {
        if (source == null || target == null || source.eClass() != target.eClass()) {
            return;
        }
        if (debug) {
            System.out.println("\nLD> source: " + source);
        }
        EList attributes = source.eClass().getEAllAttributes();
        for (EAttribute attribute : attributes) {
            Object value;
            if (!CustomizeDescriptorCommand.isAttToCopy(attribute, newChild)) continue;
            if (debug) {
                System.out.println("LD> attribute: " + attribute.getName() + ", type : " + attribute.getEType());
            }
            if ((value = source.eGet((EStructuralFeature)attribute)) == null) continue;
            target.eSet((EStructuralFeature)attribute, value);
        }
    }

    private static void copyReferences(MethodElement source, MethodElement target, boolean newChild) {
        if (source == null || target == null || source.eClass() != target.eClass()) {
            return;
        }
        EList references = source.eClass().getEAllReferences();
        if (debug) {
            System.out.println("\nLD> source: " + source);
        }
        for (EReference reference : references) {
            Object value;
            if (debug) {
                if (reference.isContainment()) {
                    System.out.println("LD> reference: " + reference.getName() + ", type : " + reference.getEType());
                }
                if (reference == UmaPackage.eINSTANCE.getBreakdownElement_PlanningData()) {
                    value = source.eGet((EStructuralFeature)reference);
                    System.out.println("LD> planningData: " + value);
                }
            }
            if (!CustomizeDescriptorCommand.isRefToCopy(reference, newChild) || (value = source.eGet((EStructuralFeature)reference)) == null || reference.isContainment()) continue;
            if (reference.isMany()) {
                List valueList = (List)value;
                if (valueList.isEmpty()) continue;
                EList copyList = (EList)target.eGet((EStructuralFeature)reference);
                copyList.clear();
                copyList.addAll((Collection)valueList);
                continue;
            }
            target.eSet((EStructuralFeature)reference, value);
        }
    }

    public static void updateFromGreenParent(Descriptor greenParent, Descriptor child, boolean newChild) {
        if (!newChild) {
            return;
        }
        if (newChild) {
            child.setName(greenParent.getName());
        }
        CustomizeDescriptorCommand.copyAttributes((MethodElement)greenParent, (MethodElement)child, newChild);
        CustomizeDescriptorCommand.copyAttributes((MethodElement)greenParent.getPresentation(), (MethodElement)child.getPresentation(), newChild);
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        if (debug) {
            child.setName(String.valueOf(greenParent.getName()) + "_n-modified");
            child.setPresentationName(String.valueOf(greenParent.getPresentationName()) + "_p-modified");
            propUtil.setNameRepalce(child, true);
            propUtil.setPresentationNameRepalce(child, true);
        }
        CustomizeDescriptorCommand.copyReferences((MethodElement)greenParent, (MethodElement)child, newChild);
        CustomizeDescriptorCommand.copyWpStates((MethodElement)greenParent, (MethodElement)child, newChild);
        CustomizeDescriptorCommand.copyReferences((MethodElement)greenParent.getPresentation(), (MethodElement)child.getPresentation(), newChild);
        propUtil.setGreenParent(child, greenParent.getGuid());
        propUtil.addToCustomizingChildren(greenParent, child);
    }

    private static void copyWpStates(MethodElement source, MethodElement target, boolean newChild) {
        if (!newChild) {
            return;
        }
        if (source == null || target == null || source.eClass() != target.eClass()) {
            return;
        }
        if (source instanceof TaskDescriptor) {
            TaskDescriptor srcTd = (TaskDescriptor)source;
            TaskDescriptor tgtTd = (TaskDescriptor)target;
            for (Constraint c : ConstraintManager.getWpStates((WorkBreakdownElement)srcTd)) {
                Constraint copiedState = (Constraint)EcoreUtil.copy((EObject)c);
                copiedState.setGuid(UmaUtil.generateGUID());
                tgtTd.getOwnedRules().add(copiedState);
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
    }

    public Collection getResult() {
        return super.getResult();
    }
}

