/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.util.AssociationHelper;

public class DeleteRoleDescriptor
extends RemoveUnusedDescriptorsCommand {
    private Activity activity;
    private RoleDescriptor roleDesc;
    private Collection modifiedResources;
    private List notUsedReferences = new ArrayList();
    private boolean forceRemoveUnusedReferences;

    public DeleteRoleDescriptor(RoleDescriptor roleDesc) {
        this.roleDesc = roleDesc;
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)roleDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)roleDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (roleDesc.eResource() != null) {
            this.modifiedResources.add(roleDesc.eResource());
        }
    }

    public DeleteRoleDescriptor(RoleDescriptor roleDesc, boolean forceRemoveUnusedReferences) {
        this(roleDesc);
        this.forceRemoveUnusedReferences = forceRemoveUnusedReferences;
    }

    public void execute() {
        HashSet refList = new HashSet();
        List assistedTaskDescriptors = AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)this.roleDesc);
        List additionalTaskDescriptors = AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)this.roleDesc);
        List primaryTaskDescriptors = AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)this.roleDesc);
        refList.addAll(assistedTaskDescriptors);
        refList.addAll(additionalTaskDescriptors);
        refList.addAll(primaryTaskDescriptors);
        refList.addAll(this.roleDesc.getResponsibleFor());
        for (Object object : refList) {
            if (!(object instanceof Descriptor) || ProcessUtil.checkDescriptorReferences((Descriptor)this.roleDesc, (Descriptor)object) || !this.activity.getBreakdownElements().contains(object)) continue;
            this.notUsedReferences.add(object);
        }
        if (!this.notUsedReferences.isEmpty()) {
            try {
                Object[] refToBeDeleted = this.forceRemoveUnusedReferences ? this.notUsedReferences.toArray() : ReferenceSelection.getReferences(this.notUsedReferences, (Descriptor)this.roleDesc);
                this.delete(refToBeDeleted);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.aborted = true;
            }
        }
        for (TaskDescriptor td : assistedTaskDescriptors) {
            td.getAssistedBy().remove(this.roleDesc);
        }
        for (TaskDescriptor td : additionalTaskDescriptors) {
            td.getAdditionallyPerformedBy().remove(this.roleDesc);
        }
        for (TaskDescriptor td : primaryTaskDescriptors) {
            td.getPerformedPrimarilyBy().remove(this.roleDesc);
        }
        this.clear(this.roleDesc.getResponsibleFor());
        List teams = AssociationHelper.getTeamProfiles((RoleDescriptor)this.roleDesc);
        for (TeamProfile team : teams) {
            team.getTeamRoles().remove(this.roleDesc);
            Object teamRoleDesc = ProcessUtil.findRoleDescriptor(team, this.roleDesc);
            team.getTeamRoles().remove(teamRoleDesc);
        }
        this.redo();
    }

    private void clear(List list) {
        try {
            if (list != null && list.size() > 0) {
                list.clear();
            }
        }
        catch (Exception exception) {}
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

