/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.TaskDescriptor;

public class DeleteTaskDescriptor
extends RemoveUnusedDescriptorsCommand {
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private List notUsedReferences = new ArrayList();
    private boolean forceRemoveUnusedReferences;

    public DeleteTaskDescriptor(TaskDescriptor taskDesc) {
        this.taskDesc = taskDesc;
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)taskDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)taskDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (taskDesc.eResource() != null) {
            this.modifiedResources.add(taskDesc.eResource());
        }
    }

    public DeleteTaskDescriptor(TaskDescriptor taskDesc, boolean forceRemoveUnusedReferences) {
        this(taskDesc);
        this.forceRemoveUnusedReferences = forceRemoveUnusedReferences;
    }

    public void execute() {
        HashSet refList = new HashSet();
        refList.addAll(this.taskDesc.getAdditionallyPerformedBy());
        refList.addAll(this.taskDesc.getAssistedBy());
        refList.addAll(this.taskDesc.getPerformedPrimarilyBy());
        refList.addAll(this.taskDesc.getMandatoryInput());
        refList.addAll(this.taskDesc.getExternalInput());
        refList.addAll(this.taskDesc.getOptionalInput());
        refList.addAll(this.taskDesc.getOutput());
        for (Object object : refList) {
            if (!(object instanceof Descriptor) || ProcessUtil.checkDescriptorReferences((Descriptor)this.taskDesc, (Descriptor)object) || !this.activity.getBreakdownElements().contains(object)) continue;
            this.notUsedReferences.add(object);
        }
        if (!this.notUsedReferences.isEmpty()) {
            try {
                Object[] refToBeDeleted = this.forceRemoveUnusedReferences ? this.notUsedReferences.toArray() : ReferenceSelection.getReferences(this.notUsedReferences, (Descriptor)this.taskDesc);
                this.delete(refToBeDeleted);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.aborted = true;
            }
        }
        this.clear(this.taskDesc.getAdditionallyPerformedBy());
        this.clear(this.taskDesc.getAssistedBy());
        this.clear(this.taskDesc.getMandatoryInput());
        this.clear(this.taskDesc.getExternalInput());
        this.clear(this.taskDesc.getOptionalInput());
        this.clear(this.taskDesc.getOutput());
        this.clear(this.taskDesc.getPerformedPrimarilyBy());
        this.redo();
    }

    private void clear(List list) {
        try {
            if (list != null && list.size() > 0) {
                list.clear();
            }
        }
        catch (Exception exception) {}
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

