/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.TeamProfile;

public class DeleteTeamProfile
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private TeamProfile team;
    private Collection modifiedResources;

    public DeleteTeamProfile(TeamProfile team) {
        this.team = team;
        Object parent = this.getParentActivity((BreakdownElement)team);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (team.eResource() != null) {
            this.modifiedResources.add(team.eResource());
        }
    }

    public void execute() {
        ArrayList<TeamProfile> teamList = new ArrayList<TeamProfile>();
        this.getSubTeams(this.team, teamList);
        teamList.add(this.team);
        int i = 0;
        while (i < teamList.size()) {
            TeamProfile tt = (TeamProfile)teamList.get(i);
            tt.getTeamRoles().clear();
            ++i;
        }
        this.redo();
    }

    private void getSubTeams(TeamProfile team, List teamList) {
        List list = team.getSubTeam();
        if (list != null) {
            for (TeamProfile tt : list) {
                teamList.add(tt);
                this.getSubTeams(tt, teamList);
            }
        }
    }

    private Object getParentActivity(BreakdownElement brElement) {
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            brElement = (BreakdownElement)parent;
            adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
            parent = adapter.getParent((Object)brElement);
        }
        return parent;
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

