/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.process.command.BasicSynchronizeDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.RemoveDuplicateReferenceCommand;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;

public class DescriptorUpdateBatchCommand
extends BatchCommand {
    private Set descriptorsToRefresh;
    private CompoundCommand refreshDescriptorsCommand;
    private Set synchFeatures;
    private MethodConfiguration config;

    public DescriptorUpdateBatchCommand(boolean clear, Set synchFeatures, MethodConfiguration config) {
        super(clear);
        this.synchFeatures = synchFeatures;
        this.config = config;
    }

    public Set getDescriptorsToRefresh() {
        if (this.descriptorsToRefresh == null) {
            this.descriptorsToRefresh = new HashSet();
        }
        return this.descriptorsToRefresh;
    }

    void setDescriptorsToRefresh(Set descriptorsToRefresh) {
        this.descriptorsToRefresh = descriptorsToRefresh;
    }

    public void dispose() {
        if (this.descriptorsToRefresh != null) {
            this.descriptorsToRefresh.clear();
            this.descriptorsToRefresh = null;
        }
        if (this.refreshDescriptorsCommand != null) {
            this.refreshDescriptorsCommand.dispose();
        }
        super.dispose();
    }

    public boolean canExecute() {
        return super.canExecute() || this.descriptorsToRefresh != null && !this.descriptorsToRefresh.isEmpty();
    }

    public void execute() {
        super.execute();
        if (this.descriptorsToRefresh != null && !this.descriptorsToRefresh.isEmpty() && this.refreshDescriptorsCommand == null) {
            this.refreshDescriptorsCommand = new CompoundCommand();
            for (Descriptor desc : this.descriptorsToRefresh) {
                this.refreshDescriptorsCommand.append((Command)new BasicSynchronizeDescriptorCommand(desc, this.synchFeatures, this.config));
                this.refreshDescriptorsCommand.append((Command)new RemoveDuplicateReferenceCommand(desc, ProcessCommandUtil.CONTENT_ELEMENT_GUIDANCE_REFERENCES, this.config));
            }
        }
        if (this.refreshDescriptorsCommand != null) {
            this.refreshDescriptorsCommand.execute();
        }
    }

    public void undo() {
        if (this.refreshDescriptorsCommand != null) {
            this.refreshDescriptorsCommand.undo();
        }
        super.undo();
    }
}

