/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.WbePropUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveUpCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private Collection modifiedResources;
    private int elementLocation = 0;
    private int transferLocation = 0;
    private Object elementObj;
    private Collection eClasses;
    private boolean adjacent = false;
    private Map<WorkBreakdownElement, WorkBreakdownElement> globalPresentedAfterMap = new HashMap<WorkBreakdownElement, WorkBreakdownElement>();

    public MoveUpCommand(Activity activity, Object elementObj, Collection eClasses) {
        this.activity = activity;
        this.elementObj = elementObj;
        this.eClasses = eClasses;
        this.modifiedResources = new HashSet();
        if (activity.eResource() != null) {
            this.modifiedResources.add(activity.eResource());
        }
    }

    public void execute() {
        Object obj;
        boolean completelyDone;
        if (this.elementObj instanceof WorkBreakdownElement && (completelyDone = MoveUpCommand.handleWbeGlobalMove(this.activity, (WorkBreakdownElement)this.elementObj, true, this.globalPresentedAfterMap))) {
            return;
        }
        List allElements = this.activity.getBreakdownElements();
        int i = 0;
        while (i < allElements.size()) {
            obj = allElements.get(i);
            if (obj.equals(this.elementObj)) {
                this.elementLocation = i;
                break;
            }
            ++i;
        }
        i = this.elementLocation - 1;
        while (i >= 0) {
            obj = allElements.get(i);
            if (TngUtil.isEClassInstanceOf(this.eClasses, obj)) {
                this.transferLocation = i;
                break;
            }
            --i;
        }
        BreakdownElement prev = (BreakdownElement)allElements.get(this.transferLocation);
        if (prev.getPresentedAfter() == this.elementObj) {
            this.adjacent = true;
        }
        this.redo();
    }

    public void redo() {
        if (this.adjacent) {
            BreakdownElement prev = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement e = (BreakdownElement)this.elementObj;
            prev.setPresentedAfter(e.getPresentedAfter());
            e.setPresentedAfter(prev);
        }
        ((EList)this.activity.getBreakdownElements()).move(this.transferLocation, this.elementLocation);
    }

    public static boolean handleWbeGlobalMove(Activity act, WorkBreakdownElement wbe, boolean up, Map<WorkBreakdownElement, WorkBreakdownElement> globalPresentedAfterMap) {
        if (wbe instanceof TaskDescriptor && DescriptorPropUtil.getDesciptorPropUtil().getGreenParent((Descriptor)((TaskDescriptor)wbe)) != null) {
            return true;
        }
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)act, ITreeItemContentProvider.class);
        Collection children = adapter.getChildren((Object)act);
        if (!(children instanceof List)) {
            return false;
        }
        WbePropUtil propUtil = WbePropUtil.getWbePropUtil();
        boolean completelyDone = false;
        List childList = (List)children;
        HashSet<WorkBreakdownElement> localSet = new HashSet<WorkBreakdownElement>();
        for (BreakdownElement be : act.getBreakdownElements()) {
            if (!(be instanceof WorkBreakdownElement) || be instanceof TaskDescriptor && DescriptorPropUtil.getDesciptorPropUtil().getGreenParent((Descriptor)((TaskDescriptor)be)) != null) continue;
            WorkBreakdownElement w = (WorkBreakdownElement)be;
            localSet.add(w);
            globalPresentedAfterMap.put(w, propUtil.getGlobalPresentedAfter(w));
        }
        if (localSet.isEmpty()) {
            return false;
        }
        Activity globalPresentedAfter = act;
        int i = 0;
        while (i < childList.size()) {
            Object child = childList.get(i);
            if (child == wbe) {
                Object newPrev = null;
                if (up) {
                    Object nextItem;
                    if (i == 0) break;
                    newPrev = i == 1 ? act : TngUtil.unwrap(childList.get(i - 2));
                    Object prevItem = childList.get(i - 1);
                    Object v0 = nextItem = i + 1 < childList.size() ? childList.get(i + 1) : null;
                    if (localSet.contains(prevItem)) {
                        propUtil.setGlobalPresentedAfter((WorkBreakdownElement)prevItem, wbe);
                    } else {
                        completelyDone = true;
                    }
                    if (nextItem != null && localSet.contains(nextItem)) {
                        WorkBreakdownElement nextWbe = nextItem;
                        if ((prevItem = TngUtil.unwrap(prevItem)) instanceof WorkBreakdownElement) {
                            propUtil.setGlobalPresentedAfter(nextWbe, (WorkBreakdownElement)prevItem);
                        } else {
                            propUtil.setGlobalPresentedAfter(nextWbe, null);
                        }
                    }
                } else {
                    Object newNextItem;
                    if (i == childList.size() - 1) break;
                    Object prevItem = i - 1 >= 0 ? childList.get(i - 1) : act;
                    newPrev = childList.get(i + 1);
                    if (localSet.contains(newPrev)) {
                        if ((prevItem = TngUtil.unwrap(prevItem)) instanceof WorkBreakdownElement) {
                            propUtil.setGlobalPresentedAfter((WorkBreakdownElement)newPrev, (WorkBreakdownElement)prevItem);
                        } else {
                            propUtil.setGlobalPresentedAfter((WorkBreakdownElement)newPrev, null);
                        }
                    } else {
                        completelyDone = true;
                        newPrev = TngUtil.unwrap(newPrev);
                    }
                    Object v1 = newNextItem = i + 2 < childList.size() ? childList.get(i + 2) : null;
                    if (localSet.contains(newNextItem)) {
                        propUtil.setGlobalPresentedAfter(newNextItem, wbe);
                    }
                }
                if (!(newPrev instanceof WorkBreakdownElement)) break;
                globalPresentedAfter = (WorkBreakdownElement)newPrev;
                break;
            }
            ++i;
        }
        propUtil.setGlobalPresentedAfter(wbe, (WorkBreakdownElement)globalPresentedAfter);
        if (!act.getBreakdownElements().isEmpty()) {
            ((EList)act.getBreakdownElements()).move(0, 0);
        }
        return completelyDone;
    }

    public void undo() {
        ((EList)this.activity.getBreakdownElements()).move(this.elementLocation, this.transferLocation);
        if (this.adjacent) {
            BreakdownElement prev = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement e = (BreakdownElement)this.elementObj;
            e.setPresentedAfter(prev.getPresentedAfter());
            prev.setPresentedAfter(e);
        }
        WbePropUtil propUtil = WbePropUtil.getWbePropUtil();
        if (!this.globalPresentedAfterMap.isEmpty()) {
            for (Map.Entry<WorkBreakdownElement, WorkBreakdownElement> entry : this.globalPresentedAfterMap.entrySet()) {
                propUtil.setGlobalPresentedAfter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

