/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class PBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map wpDescToDeliverableParts;
    private HashMap<WorkProductDescriptor, WorkProductDescriptor> wpdToDeliverableDescriptorMap;
    private BatchCommand updateDeliverablePartsCmd;
    private boolean newDuplicatesRemoved;
    private IConfigurator configurator;
    private ArrayList linkedTasks;
    private HashMap wpdToTaskFeaturesMap;

    public PBSDropCommand(Activity activity, List workProducts) {
        super(activity, workProducts);
        this.activity = activity;
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof WorkProduct) continue;
            iter.remove();
        }
    }

    public PBSDropCommand(Activity activity, List dropElements, boolean synch) {
        super(activity, dropElements, synch);
    }

    public PBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures, IConfigurator configurator) {
        super(activity, dropElements, config, synchFeatures);
        this.configurator = configurator;
    }

    protected boolean preExecute() {
        Object wpDesc;
        if (!super.preExecute()) {
            return false;
        }
        this.wpDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.roleDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        if (!this.synchronize || this.synchronize && this.synchFeatures.contains(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts())) {
            for (Object element : new ArrayList(this.dropElements)) {
                if (!(element instanceof Artifact)) continue;
                AbstractTreeIterator iterator = new AbstractTreeIterator(element, false){
                    private static final long serialVersionUID = -4820477887426087262L;

                    protected Iterator getChildren(Object object) {
                        Object subArtifacts = Providers.getConfigurationApplicator().getReference((VariabilityElement)object, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), PBSDropCommand.this.getMethodConfiguration());
                        return ((Collection)subArtifacts).iterator();
                    }
                };
                while (iterator.hasNext()) {
                    Artifact subArtifact = (Artifact)iterator.next();
                    if (this.dropElements.contains(subArtifact) || !this.prepareAdd((WorkProduct)subArtifact)) continue;
                    this.dropElements.add(subArtifact);
                }
            }
        }
        MethodConfiguration config = this.getMethodConfiguration();
        Set descriptorsToRefresh = this.synchronize ? this.batchCommand.getDescriptorsToRefresh() : null;
        List bes = this.activity.getBreakdownElements();
        UniqueNamePNameHandler uniqueNamesHandler = new UniqueNamePNameHandler(bes);
        int i = 0;
        while (i < this.dropElements.size()) {
            WorkProduct wp = (WorkProduct)this.dropElements.get(i);
            if (TngUtil.isContributor((VariabilityElement)wp)) {
                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
            }
            wpDesc = null;
            if (this.synchronize) {
                wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getBestDescriptor(wp, this.activity, config);
            }
            if (wpDesc == null) {
                Map featuresMap;
                wpDesc = ProcessCommandUtil.createWorkProductDescriptor(wp, config, this.wpDescToDeliverableParts);
                this.wpDescList.add(wpDesc);
                WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(this.activity, wp);
                if (descriptor != null) {
                    this.wpdToDeliverableDescriptorMap.put((WorkProductDescriptor)wpDesc, descriptor);
                }
                if (this.wpdToTaskFeaturesMap != null && (featuresMap = (Map)this.wpdToTaskFeaturesMap.get(wp)) != null) {
                    this.wpdToTaskFeaturesMap.remove(wp);
                    this.wpdToTaskFeaturesMap.put(wpDesc, featuresMap);
                }
            } else {
                if (descriptorsToRefresh != null && wpDesc.getIsSynchronizedWithSource().booleanValue()) {
                    descriptorsToRefresh.add(wpDesc);
                }
                if (wp instanceof Deliverable && this.synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                    ProcessCommandUtil.createDeliverableParts(wpDesc, (Deliverable)wp, config, this.wpDescToDeliverableParts, descriptorsToRefresh);
                }
                if (this.wpdToTaskFeaturesMap != null) {
                    this.wpdToTaskFeaturesMap.remove(wp);
                }
            }
            if (!this.synchronize) {
                List tasks = ProcessUtil.getTasksForWorkProduct(wp, config);
                if (tasks != null && tasks.size() > 0) {
                    final List finalTasks = tasks;
                    final WorkProduct finalWp = wp;
                    final ArrayList finalSelected = new ArrayList();
                    ArrayList selectedTasks = new ArrayList();
                    UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

                        public void run() {
                            List selected = UserInteractionHelper.selectTasks(finalTasks, finalWp);
                            finalSelected.addAll(selected);
                        }
                    }, true);
                    selectedTasks.addAll(finalSelected);
                    if (selectedTasks != null && !selectedTasks.isEmpty()) {
                        int j = 0;
                        while (j < selectedTasks.size()) {
                            Task task = (Task)selectedTasks.get(j);
                            PBSDropCommand.addToDescriptorLists(task, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, descriptorsToRefresh, this.batchCommand.getObjectToNewFeatureValuesMap(), config, true, this.synchFeatures);
                            ++j;
                        }
                    } else {
                        ProcessCommandUtil.addResponsibleRoleDescriptors(wpDesc, this.activity, this.roleDescList, descriptorsToRefresh, config);
                    }
                } else {
                    ProcessCommandUtil.addResponsibleRoleDescriptors(wpDesc, this.activity, this.roleDescList, descriptorsToRefresh, config);
                }
            }
            ++i;
        }
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            this.updateDeliverablePartsCmd = new BatchCommand(true);
            for (Map.Entry entry : this.wpDescToDeliverableParts.entrySet()) {
                wpDesc = entry.getKey();
                this.updateDeliverablePartsCmd.getObjectToNewFeatureValuesMap().put(wpDesc, Collections.singletonMap(UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), entry.getValue()));
            }
        }
        i = 0;
        while (i < this.wpDescList.size()) {
            WorkProductDescriptor wpDesc2 = (WorkProductDescriptor)this.wpDescList.get(i);
            if (wpDesc2 != null) {
                uniqueNamesHandler.ensureUnique((DescribableElement)wpDesc2);
            }
            ++i;
        }
        return !this.taskDescList.isEmpty() || !this.roleDescList.isEmpty() || !this.wpDescList.isEmpty() || this.updateDeliverablePartsCmd != null && this.updateDeliverablePartsCmd.canExecute() || !this.wpdToDeliverableDescriptorMap.isEmpty() || descriptorsToRefresh != null && !descriptorsToRefresh.isEmpty() || this.batchCommand.canExecute();
    }

    private boolean prepareAdd(WorkProduct wp) {
        if (this.synchronize) {
            Map featuresMap;
            List tasks = this.getLinkedTasks();
            if (!tasks.isEmpty() && !(featuresMap = ProcessCommandUtil.getFeaturesMap(tasks, wp, this.getMethodConfiguration())).isEmpty()) {
                if (this.wpdToTaskFeaturesMap == null) {
                    this.wpdToTaskFeaturesMap = new HashMap();
                }
                this.wpdToTaskFeaturesMap.put(wp, featuresMap);
                return true;
            }
            return false;
        }
        return true;
    }

    private List getLinkedTasks() {
        if (this.linkedTasks == null) {
            this.linkedTasks = new ArrayList();
            for (Object element : this.activity.getBreakdownElements()) {
                Task task;
                if (!(element instanceof TaskDescriptor) || (task = ((TaskDescriptor)element).getTask()) == null || !this.configurator.accept(element)) continue;
                this.linkedTasks.add(task);
            }
        }
        return this.linkedTasks;
    }

    private void removeNewDuplicates() {
        if (this.synchronize && !this.newDuplicatesRemoved) {
            Iterator iter = this.roleDescList.iterator();
            while (iter.hasNext()) {
                RoleDescriptor roleDesc = (RoleDescriptor)iter.next();
                Object desc = ProcessCommandUtil.getDescriptor((Object)roleDesc.getRole(), this.activity, this.getMethodConfiguration());
                if (desc == null) continue;
                iter.remove();
            }
            this.newDuplicatesRemoved = true;
        }
    }

    protected void doExecute() {
        ProcessPackage pkg;
        this.removeNewDuplicates();
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            for (Map.Entry<WorkProductDescriptor, WorkProductDescriptor> entry : this.wpdToDeliverableDescriptorMap.entrySet()) {
                WorkProductDescriptor deliverable = entry.getValue();
                deliverable.getDeliverableParts().add(entry.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (this.wpdToTaskFeaturesMap != null) {
            for (Map.Entry entry : this.wpdToTaskFeaturesMap.entrySet()) {
                Map taskFeatures = (Map)entry.getValue();
                for (Map.Entry ent : taskFeatures.entrySet()) {
                    TaskDescriptor taskDesc = (TaskDescriptor)ProcessCommandUtil.getDescriptor(ent.getKey(), this.activity.getBreakdownElements(), this.getMethodConfiguration(), false);
                    for (EStructuralFeature f : (Collection)ent.getValue()) {
                        EStructuralFeature descFeature = (EStructuralFeature)FEATURE_MAP.get(f);
                        if (descFeature.isMany()) {
                            ((List)taskDesc.eGet(descFeature)).add(entry.getKey());
                            continue;
                        }
                        taskDesc.eSet(descFeature, entry.getKey());
                    }
                }
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().addAll(this.taskDescList);
            pkg.getProcessElements().addAll(this.roleDescList);
            pkg.getProcessElements().addAll(this.wpDescList);
            Iterator iter = this.wpDescToDeliverableParts.values().iterator();
            while (iter.hasNext()) {
                pkg.getProcessElements().addAll((Collection)iter.next());
            }
        }
    }

    protected void updateDescriptors() {
        super.updateDescriptors();
        if (this.updateDeliverablePartsCmd != null) {
            this.updateDeliverablePartsCmd.execute();
        }
    }

    protected void undoUpdateDescriptors() {
        if (this.updateDeliverablePartsCmd != null) {
            this.updateDeliverablePartsCmd.undo();
        }
        super.undoUpdateDescriptors();
    }

    protected void doUndo() {
        ProcessPackage pkg;
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            for (Map.Entry<WorkProductDescriptor, WorkProductDescriptor> entry : this.wpdToDeliverableDescriptorMap.entrySet()) {
                WorkProductDescriptor deliverable = entry.getValue();
                deliverable.getDeliverableParts().remove(entry.getKey());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().removeAll(this.taskDescList);
            pkg.getProcessElements().removeAll(this.roleDescList);
            pkg.getProcessElements().removeAll(this.wpDescList);
            Iterator iter = this.wpDescToDeliverableParts.values().iterator();
            while (iter.hasNext()) {
                pkg.getProcessElements().removeAll((Collection)((Object)iter.next()));
            }
        }
        if (this.wpdToTaskFeaturesMap != null) {
            for (Map.Entry entry : this.wpdToTaskFeaturesMap.entrySet()) {
                Map taskFeatures = (Map)entry.getValue();
                for (Map.Entry ent : taskFeatures.entrySet()) {
                    TaskDescriptor taskDesc = (TaskDescriptor)ProcessCommandUtil.getDescriptor(ent.getKey(), this.activity, this.getMethodConfiguration());
                    for (EStructuralFeature f : (Collection)ent.getValue()) {
                        EStructuralFeature descFeature = (EStructuralFeature)FEATURE_MAP.get(f);
                        if (descFeature.isMany()) {
                            ((List)taskDesc.eGet(descFeature)).remove(entry.getKey());
                            continue;
                        }
                        taskDesc.eSet(descFeature, null);
                    }
                }
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.wpDescList != null) {
            return this.wpDescList;
        }
        return super.getAffectedObjects();
    }

    static boolean addToDescriptorLists(Task task, Activity activity, List taskDescList, List roleDescList, List wpDescList, Map wpDescToDeliverableParts, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap, MethodConfiguration config, boolean useExistingDescriptor, Set synchFeatures) {
        TaskDescriptor desc = ProcessCommandUtil.createTaskDescriptor(task, activity, roleDescList, wpDescList, wpDescToDeliverableParts, null, descriptorsToRefresh, descriptorToNewFeatureValuesMap, config, useExistingDescriptor, synchFeatures);
        if (desc != null && taskDescList != null && !taskDescList.contains(desc)) {
            taskDescList.add(desc);
        }
        return desc != null;
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        if (this.wpdToTaskFeaturesMap != null) {
            this.wpdToTaskFeaturesMap.clear();
        }
        super.dispose();
    }
}

