/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;

public class ProcessElementDeleteCommand
extends DeleteMethodElementCommand {
    private Set contentsToRemove;
    private ArrayList elementsToRemoveReferences;
    private boolean ownedElementsIncluded;

    public ProcessElementDeleteCommand(Command command, Collection elements) {
        super(command, elements);
    }

    public ProcessElementDeleteCommand(Command command, Collection elements, boolean confirmRemoveRefs) {
        super(command, elements, confirmRemoveRefs);
    }

    public void execute() {
        if (!this.ownedElementsIncluded) {
            Collection ownedElements = this.getOwnedElements(this.elements);
            if (!ownedElements.isEmpty()) {
                this.includeElements(ownedElements);
            }
            this.ownedElementsIncluded = true;
        }
        super.execute();
    }

    protected Collection getOwnedElements(Collection elements) {
        ArrayList ownedElements = new ArrayList();
        for (Object element : elements) {
            WorkProductDescriptor wpd;
            WorkProduct wp;
            if (!(element instanceof WorkProductDescriptor) || !((wp = (wpd = (WorkProductDescriptor)element).getWorkProduct()) instanceof Artifact)) continue;
            AbstractTreeIterator iter1 = new AbstractTreeIterator(wp, false){
                private static final long serialVersionUID = 422181782268878289L;

                protected Iterator getChildren(Object object) {
                    return ((Artifact)object).getContainedArtifacts().iterator();
                }
            };
            HashSet workProducts = new HashSet();
            while (iter1.hasNext()) {
                workProducts.add(iter1.next());
            }
            Activity activity = UmaUtil.getParentActivity((BreakdownElement)wpd);
            for (Object be : activity.getBreakdownElements()) {
                if (!(be instanceof WorkProductDescriptor) || !workProducts.contains(((WorkProductDescriptor)be).getWorkProduct())) continue;
                ownedElements.add(be);
            }
        }
        return ownedElements;
    }

    protected void excludeElements(Collection excludedElements) {
        this.elements.removeAll(excludedElements);
        for (Object element : excludedElements) {
            RemoveCommand cmd = this.getRemoveCommand(element);
            if (cmd == null) continue;
            cmd.getCollection().remove(element);
        }
    }

    protected void includeElements(Collection includedElements) {
        for (Object element : includedElements) {
            Collection collection;
            if (this.elements.contains(element)) continue;
            this.elements.add(element);
            RemoveCommand cmd = this.getRemoveCommand(element);
            if (cmd == null || (collection = cmd.getCollection()).contains(element)) continue;
            collection.add(element);
        }
    }

    public Collection getElementsToRemoveReferences() {
        if (this.elementsToRemoveReferences == null) {
            this.elementsToRemoveReferences = new ArrayList();
            for (Object element : this.elements) {
                if (element instanceof Activity) {
                    EObject pkg = ((Activity)element).eContainer();
                    if (pkg != null) {
                        this.elementsToRemoveReferences.add(pkg);
                        continue;
                    }
                    this.elementsToRemoveReferences.add(element);
                    continue;
                }
                this.elementsToRemoveReferences.add(element);
            }
        }
        return this.elementsToRemoveReferences;
    }

    protected boolean canRemoveReferences(MethodElement e) {
        return true;
    }

    protected void removeReferences() {
        this.contentsToRemove = new HashSet();
        for (Object obj : this.elements) {
            if (!(obj instanceof EObject)) continue;
            EObject eObj = (EObject)obj;
            if (obj instanceof Activity) {
                EObject container;
                Activity act = (Activity)obj;
                if (ContentDescriptionFactory.hasPresentation((MethodElement)act)) {
                    this.contentsToRemove.add(act.getPresentation());
                }
                if ((container = eObj.eContainer()) == null) continue;
                EcoreUtil.remove((EObject)container);
                TreeIterator iterator = container.eAllContents();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (!(element instanceof Activity) || !ContentDescriptionFactory.hasPresentation((MethodElement)(act = (Activity)element))) continue;
                    this.contentsToRemove.add(act.getPresentation());
                }
                continue;
            }
            EcoreUtil.remove((EObject)((EObject)obj));
        }
        super.removeReferences();
    }

    protected void deleteContent() throws Exception {
        Iterator iter = this.contentsToRemove.iterator();
        while (iter.hasNext()) {
            EcoreUtil.remove((EObject)((EObject)iter.next()));
        }
        this.elementsToDeleteContent.addAll(this.contentsToRemove);
        super.deleteContent();
    }

    protected boolean collectObjectsToRemove(Collection objectsToRemove, EObject elementToDelete, EObject referencer, Collection references) {
        boolean ret = super.collectObjectsToRemove(objectsToRemove, elementToDelete, referencer, references);
        for (EReference ref : references) {
            EObject container;
            if (ref != UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element() || (container = referencer.eContainer()) == null || container.eContainer() == null) continue;
            objectsToRemove.add(container);
            ret = true;
        }
        return ret;
    }

    public void dispose() {
        if (this.contentsToRemove != null) {
            this.contentsToRemove.clear();
        }
        if (this.elementsToRemoveReferences != null) {
            this.elementsToRemoveReferences.clear();
        }
        super.dispose();
    }

    protected void removeReferenceFollowUp(EObject referencer, EObject referenced, EStructuralFeature feature) {
        if (!ProcessUtil.isSynFree()) {
            return;
        }
        if (!(referencer instanceof Descriptor)) {
            return;
        }
        if (!(referenced instanceof Descriptor)) {
            return;
        }
        if (!(feature instanceof EReference)) {
            return;
        }
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        EReference ref = (EReference)feature;
        EReference eref = LibraryEditUtil.getInstance().getExcludeFeature(ref);
        if (eref == null) {
            return;
        }
        MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)referenced);
        boolean localUse = propUtil.localUse((Descriptor)referenced, (Descriptor)referencer, ref);
        if (localUse) {
            propUtil.removeLocalUse((Descriptor)referenced, (Descriptor)referencer, ref);
        } else if (element != null) {
            List excludeList = (List)referencer.eGet((EStructuralFeature)eref);
            excludeList.add(element);
        }
    }
}

