/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDuplicateReferenceCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Descriptor descriptor;
    private Collection<EReference> sourceFeatures;
    private Map<EStructuralFeature, Object> featureToOldValueMap = new HashMap<EStructuralFeature, Object>();
    private MethodConfiguration config;

    public RemoveDuplicateReferenceCommand(Descriptor descriptor, Collection<EReference> sourceFeatures, MethodConfiguration config) {
        this.descriptor = descriptor;
        this.sourceFeatures = sourceFeatures;
        this.config = config;
    }

    public Collection<Resource> getModifiedResources() {
        if (this.descriptor.eResource() != null) {
            return Collections.singletonList(this.descriptor.eResource());
        }
        return Collections.emptyList();
    }

    public void execute() {
        MethodElement source = ProcessUtil.getAssociatedElement(this.descriptor);
        if (source instanceof ContentElement) {
            ContentElement contentElement = (ContentElement)source;
            for (EReference sourceFeature : this.sourceFeatures) {
                EStructuralFeature feature;
                Object sourceValue = Providers.getConfigurationApplicator().getReference((VariabilityElement)contentElement, sourceFeature, this.config);
                if (sourceFeature.isMany() && ((List)sourceValue).isEmpty() || !sourceFeature.isMany() && sourceValue == null || (feature = BSDropCommand.getDescriptorFeature((EStructuralFeature)sourceFeature)) == null) continue;
                Object value = this.descriptor.eGet(feature);
                if (feature.isMany() && ((List)value).isEmpty() || !feature.isMany() && value == null || !feature.isMany()) continue;
                List list = (List)value;
                ArrayList oldList = new ArrayList(list);
                if (!list.removeAll((Collection)sourceValue)) continue;
                this.featureToOldValueMap.put(feature, oldList);
            }
        }
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        if (this.featureToOldValueMap != null) {
            for (Map.Entry<EStructuralFeature, Object> entry : this.featureToOldValueMap.entrySet()) {
                this.descriptor.eSet(entry.getKey(), entry.getValue());
            }
            this.featureToOldValueMap.clear();
        }
    }
}

